/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.function.Consumer;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.components.KeycardData;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;

public class KeycardItem
extends Item {
    private static final Component LINK_INFO = Component.translatable((String)"tooltip.securitycraft:keycard.link_info").setStyle(Utils.GRAY_STYLE);
    public static final Component LIMITED_INFO = Component.translatable((String)"tooltip.securitycraft:keycard.limited_info").setStyle(Utils.GRAY_STYLE);
    private final int level;

    public KeycardItem(Item.Properties properties, int level) {
        super(properties);
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, TooltipDisplay display, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        if (this != SCContent.LIMITED_USE_KEYCARD.get()) {
            DataComponentType type = (DataComponentType)SCContent.KEYCARD_DATA.get();
            KeycardData keycardData = (KeycardData)stack.get(type);
            if (keycardData != null) {
                if (display.shows(type)) {
                    keycardData.addToTooltip(ctx, tooltipAdder, flag, (DataComponentGetter)stack.getComponents());
                }
            } else {
                tooltipAdder.accept(LINK_INFO);
                tooltipAdder.accept(LIMITED_INFO);
            }
        }
    }
}

