/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.inventory.BlockEntityInventoryWrapper;
import net.geforcemods.securitycraft.inventory.LensSlot;
import net.geforcemods.securitycraft.inventory.OwnerRestrictedSlot;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class InventoryScannerMenu
extends AbstractContainerMenu {
    public final InventoryScannerBlockEntity be;
    private ContainerLevelAccess worldPosCallable;

    public InventoryScannerMenu(int windowId, Level level, BlockPos pos, Inventory inventory) {
        super((MenuType)SCContent.INVENTORY_SCANNER_MENU.get(), windowId);
        int j;
        int i;
        this.be = (InventoryScannerBlockEntity)level.getBlockEntity(pos);
        this.worldPosCallable = ContainerLevelAccess.create((Level)level, (BlockPos)pos);
        BlockEntityInventoryWrapper<InventoryScannerBlockEntity> wrapper = new BlockEntityInventoryWrapper<InventoryScannerBlockEntity>(this.be, this);
        for (i = 0; i < 10; ++i) {
            this.addSlot(new OwnerRestrictedSlot(wrapper, this.be, i, 6 + i * 18, 16, true));
        }
        if (this.be.isOwnedBy((Entity)inventory.player) && this.be.isModuleEnabled(ModuleType.STORAGE)) {
            for (i = 0; i < 9; ++i) {
                for (j = 0; j < 3; ++j) {
                    this.addSlot(new Slot(wrapper, 10 + (i * 3 + j), 188 + j * 18, 29 + i * 18));
                }
            }
        }
        this.addSlot(new LensSlot((Container)this.be.getLensContainer(), 0, 159, 89){

            public boolean mayPickup(Player player) {
                return InventoryScannerMenu.this.be.isOwnedBy((Entity)player);
            }
        });
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 15 + j * 18, 115 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 15 + i * 18, 173));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack toReturn = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            toReturn = slotStack.copy();
            if (index >= 10 && index <= 36 ? !this.moveItemStackTo(slotStack, 38, this.slots.size(), true) && !this.moveItemStackTo(slotStack, 37, 38, true) : (index == 37 ? !this.moveItemStackTo(slotStack, 38, this.slots.size(), true) : (index <= 64 ? !this.moveItemStackTo(slotStack, 65, this.slots.size(), true) : index < this.slots.size() && !this.moveItemStackTo(slotStack, 38, 65, true)))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return toReturn;
    }

    public void removed(Player player) {
        super.removed(player);
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.be.getLevel(), this.be.getBlockPos());
        if (connectedScanner != null) {
            connectedScanner.setContents(this.be.getContents());
        }
    }

    public boolean stillValid(Player player) {
        return InventoryScannerMenu.stillValid((ContainerLevelAccess)this.worldPosCallable, (Player)player, (Block)((Block)SCContent.INVENTORY_SCANNER.get()));
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        OwnerRestrictedSlot slot;
        Slot slot2;
        if (slotId >= 0 && slotId < 10 && (slot2 = this.getSlot(slotId)) instanceof OwnerRestrictedSlot && (slot = (OwnerRestrictedSlot)slot2).isGhostSlot()) {
            if (!player.isSpectator() && this.be.isOwnedBy((Entity)player)) {
                ItemStack pickedUpStack = this.getCarried().copy();
                pickedUpStack.setCount(1);
                this.be.getContents().set(slotId, (Object)pickedUpStack);
                this.be.setChanged();
            }
        } else {
            super.clicked(slotId, dragType, clickType, player);
        }
    }
}

