/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.geforcemods.securitycraft.api.IModuleInventoryWithContainer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlockEntityInventoryWrapper<T extends BlockEntity>
implements Container {
    private final T wrapped;
    private final AbstractContainerMenu menu;

    public BlockEntityInventoryWrapper(T wrapped, AbstractContainerMenu menu) {
        this.wrapped = wrapped;
        this.menu = menu;
    }

    public void clearContent() {
        for (int i = 0; i < ((IModuleInventoryWithContainer)this.wrapped).getContainerSize(); ++i) {
            ((IModuleInventoryWithContainer)this.wrapped).setContainerItem(i, ItemStack.EMPTY);
        }
        this.menu.slotsChanged((Container)this);
    }

    public int getContainerSize() {
        return ((IModuleInventoryWithContainer)this.wrapped).getContainerSize();
    }

    public boolean isEmpty() {
        return ((IModuleInventoryWithContainer)this.wrapped).isContainerEmpty();
    }

    public ItemStack getItem(int index) {
        return ((IModuleInventoryWithContainer)this.wrapped).getStackInContainer(index);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack toReturn = ((IModuleInventoryWithContainer)this.wrapped).removeContainerItem(index, count, false);
        this.menu.slotsChanged((Container)this);
        return toReturn;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack toReturn = ((IModuleInventoryWithContainer)this.wrapped).getStackInContainer(index);
        ((IModuleInventoryWithContainer)this.wrapped).setStackInSlot(index, ItemStack.EMPTY);
        this.menu.slotsChanged((Container)this);
        return toReturn;
    }

    public void setItem(int index, ItemStack stack) {
        ((IModuleInventoryWithContainer)this.wrapped).setContainerItem(index, stack);
        this.menu.slotsChanged((Container)this);
    }

    public void setChanged() {
        this.wrapped.setChanged();
        this.menu.slotsChanged((Container)this);
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

