/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.compat.jei.InventoryScannerGhostIngredientHandler;
import net.geforcemods.securitycraft.compat.jei.ReinforcerRecipe;
import net.geforcemods.securitycraft.compat.jei.SecurityCraftToVanillaCategory;
import net.geforcemods.securitycraft.compat.jei.SlotMover;
import net.geforcemods.securitycraft.compat.jei.VanillaToSecurityCraftCategory;
import net.geforcemods.securitycraft.screen.BlockChangeDetectorScreen;
import net.geforcemods.securitycraft.screen.BlockPocketManagerScreen;
import net.geforcemods.securitycraft.screen.CustomizeBlockScreen;
import net.geforcemods.securitycraft.screen.DisguiseModuleScreen;
import net.geforcemods.securitycraft.screen.InventoryScannerScreen;
import net.geforcemods.securitycraft.screen.ProjectorScreen;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@JeiPlugin
public class SCJEIPlugin
implements IModPlugin {
    public static final IRecipeType<ReinforcerRecipe> VTS = new IRecipeType.JeiRecipeType(SecurityCraft.resLoc("vanilla_to_securitycraft"), ReinforcerRecipe.class);
    public static final IRecipeType<ReinforcerRecipe> STV = new IRecipeType.JeiRecipeType(SecurityCraft.resLoc("securitycraft_to_vanilla"), ReinforcerRecipe.class);

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)SCContent.ADMIN_TOOL.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Utils.localize("gui.securitycraft:scManual.recipe.admin_tool", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)SCContent.KEYPAD.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Utils.localize("gui.securitycraft:scManual.recipe." + Utils.getRegistryName((Block)SCContent.KEYPAD.get()).getPath(), new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)SCContent.KEYPAD_CHEST.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Utils.localize("gui.securitycraft:scManual.recipe." + Utils.getRegistryName((Block)SCContent.KEYPAD_CHEST.get()).getPath(), new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)SCContent.KEYPAD_FURNACE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Utils.localize("gui.securitycraft:scManual.recipe." + Utils.getRegistryName((Block)SCContent.KEYPAD_FURNACE.get()).getPath(), new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)SCContent.KEYPAD_SMOKER.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Utils.localize("gui.securitycraft:scManual.recipe." + Utils.getRegistryName((Block)SCContent.KEYPAD_SMOKER.get()).getPath(), new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)SCContent.KEYPAD_BLAST_FURNACE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Utils.localize("gui.securitycraft:scManual.recipe." + Utils.getRegistryName((Block)SCContent.KEYPAD_BLAST_FURNACE.get()).getPath(), new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)SCContent.KEYPAD_TRAPDOOR.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Utils.localize("gui.securitycraft:scManual.recipe." + Utils.getRegistryName((Block)SCContent.KEYPAD_TRAPDOOR.get()).getPath(), new Object[0])});
        registration.addRecipes(VTS, IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.entrySet().stream().filter(entry -> ((Block)entry.getKey()).asItem() != Items.AIR && ((Block)entry.getValue()).asItem() != Items.AIR).map(entry -> new ReinforcerRecipe((Block)entry.getKey(), (Block)entry.getValue())).toList());
        registration.addRecipes(STV, IReinforcedBlock.SECURITYCRAFT_TO_VANILLA.entrySet().stream().filter(entry -> ((Block)entry.getKey()).asItem() != Items.AIR && ((Block)entry.getValue()).asItem() != Items.AIR).map(entry -> new ReinforcerRecipe((Block)entry.getValue(), (Block)entry.getKey())).toList());
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new VanillaToSecurityCraftCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SecurityCraftToVanillaCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        ItemStack reinforcer2 = new ItemStack((ItemLike)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_2.get());
        ItemStack reinforcer3 = new ItemStack((ItemLike)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_3.get());
        registration.addCraftingStation((IRecipeType)RecipeTypes.SMELTING, new ItemStack[]{new ItemStack((ItemLike)SCContent.KEYPAD_FURNACE.get())});
        registration.addCraftingStation((IRecipeType)RecipeTypes.SMOKING, new ItemStack[]{new ItemStack((ItemLike)SCContent.KEYPAD_SMOKER.get())});
        registration.addCraftingStation((IRecipeType)RecipeTypes.BLASTING, new ItemStack[]{new ItemStack((ItemLike)SCContent.KEYPAD_BLAST_FURNACE.get())});
        registration.addCraftingStation(VTS, new ItemStack[]{new ItemStack((ItemLike)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get()), reinforcer2, reinforcer3});
        registration.addCraftingStation(STV, new ItemStack[]{reinforcer2, reinforcer3});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(BlockChangeDetectorScreen.class, new SlotMover());
        registration.addGuiContainerHandler(BlockPocketManagerScreen.class, new SlotMover());
        registration.addGuiContainerHandler(CustomizeBlockScreen.class, new SlotMover());
        registration.addGuiContainerHandler(DisguiseModuleScreen.class, new SlotMover());
        registration.addGuiContainerHandler(ProjectorScreen.class, new SlotMover());
        registration.addGhostIngredientHandler(InventoryScannerScreen.class, (IGhostIngredientHandler)new InventoryScannerGhostIngredientHandler());
    }

    public ResourceLocation getPluginUid() {
        return SecurityCraft.resLoc("securitycraft");
    }
}

