/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Iterator;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class ReinforcedScaffoldingBlock
extends ScaffoldingBlock
implements EntityBlock,
IReinforcedBlock {
    public ReinforcedScaffoldingBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.getDestroyProgress(x$0, x$1, x$2, x$3), state, player, level, pos);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity(pos, state);
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.SCAFFOLDING;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        EntityCollisionContext ectx;
        if (ctx instanceof EntityCollisionContext && this.ownsScaffolding(level, pos, (ectx = (EntityCollisionContext)ctx).getEntity())) {
            return super.getShape(state, level, pos, ctx);
        }
        return (Boolean)state.getValue((Property)BOTTOM) != false ? SHAPE_UNSTABLE : SHAPE_STABLE;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        EntityCollisionContext ectx;
        if (ctx instanceof EntityCollisionContext && this.ownsScaffolding(level, pos, (ectx = (EntityCollisionContext)ctx).getEntity())) {
            return super.getCollisionShape(state, level, pos, ctx);
        }
        return Shapes.empty();
    }

    public boolean isScaffolding(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return this.ownsScaffolding((BlockGetter)level, pos, (Entity)entity);
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return super.isLadder(state, level, pos, entity) && this.ownsScaffolding((BlockGetter)level, pos, (Entity)entity);
    }

    public boolean ownsScaffolding(BlockGetter level, BlockPos pos, Entity entity) {
        IOwnable ownable;
        BlockEntity blockEntity;
        return !(entity instanceof LivingEntity) || (blockEntity = level.getBlockEntity(pos)) instanceof IOwnable && (ownable = (IOwnable)blockEntity).isOwnedBy(entity);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        int distance = ReinforcedScaffoldingBlock.getDistance((BlockGetter)level, pos);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER))).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(distance))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom((BlockGetter)level, pos, distance)));
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int distance = ReinforcedScaffoldingBlock.getDistance((BlockGetter)level, pos);
        BlockState newState = (BlockState)((BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(distance))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom((BlockGetter)level, pos, distance)));
        if ((Integer)newState.getValue((Property)DISTANCE) == 7) {
            if ((Integer)state.getValue((Property)DISTANCE) == 7) {
                CompoundTag data = level.getBlockEntity(pos).saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
                FallingBlockEntity entity = FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)newState);
                entity.blockData = data;
            } else {
                level.destroyBlock(pos, true);
            }
        } else if (state != newState) {
            level.setBlock(pos, newState, 3);
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return ReinforcedScaffoldingBlock.getDistance((BlockGetter)level, pos) < 7;
    }

    public static int getDistance(BlockGetter level, BlockPos pos) {
        Direction direction;
        BlockState offsetState;
        BlockPos.MutableBlockPos mutable = pos.mutable().move(Direction.DOWN);
        BlockState mutableState = level.getBlockState((BlockPos)mutable);
        int distance = 7;
        if (mutableState.is(SCContent.REINFORCED_SCAFFOLDING)) {
            distance = (Integer)mutableState.getValue((Property)DISTANCE);
        } else if (mutableState.isFaceSturdy(level, (BlockPos)mutable, Direction.UP)) {
            return 0;
        }
        Iterator iterator = Direction.Plane.HORIZONTAL.iterator();
        while (iterator.hasNext() && (!(offsetState = level.getBlockState((BlockPos)mutable.setWithOffset((Vec3i)pos, direction = (Direction)iterator.next()))).is(SCContent.REINFORCED_SCAFFOLDING) || (distance = Math.min(distance, (Integer)offsetState.getValue((Property)DISTANCE) + 1)) != 1)) {
        }
        return distance;
    }
}

