/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.blockentities.MineBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MineBlock
extends ExplosiveBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty DEACTIVATED = BooleanProperty.create((String)"deactivated");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);

    public MineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, Orientation orientation, boolean flag) {
        if (level.getBlockState(pos.below()).isAir()) {
            if (((Boolean)level.getBlockState(pos).getValue((Property)DEACTIVATED)).booleanValue()) {
                level.destroyBlock(pos, true);
            } else {
                this.explode(level, pos);
            }
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return BlockUtils.isSideSolid(level, pos.below(), Direction.UP);
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, tickAccess, pos, facing, facingPos, facingState, random);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!level.isClientSide) {
            MineBlockEntity mine = (MineBlockEntity)level.getBlockEntity(pos);
            TargetingMode mode = mine.getTargetingMode();
            if (!mode.allowsPlayers() || player != null && player.isCreative() && !((Boolean)ConfigHandler.SERVER.mineExplodesWhenInCreative.get()).booleanValue()) {
                return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
            }
            if (mine.isOwnedBy((Entity)player) && !mine.ignoresOwner()) {
                this.explode(level, pos);
                return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier) {
        if (!level.isClientSide && entity instanceof LivingEntity) {
            MineBlockEntity mine;
            TargetingMode mode;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.getShape(state, (BlockGetter)level, pos, CollisionContext.of((Entity)entity)).bounds().move(pos).inflate(0.01).intersects(entity.getBoundingBox()) && (mode = (mine = (MineBlockEntity)level.getBlockEntity(pos)).getTargetingMode()).canAttackEntity(livingEntity, mine, e -> false)) {
                this.explode(level, pos);
            }
        }
    }

    @Override
    public boolean activateMine(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (((Boolean)state.getValue((Property)DEACTIVATED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (!((Boolean)state.getValue((Property)DEACTIVATED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return true;
        }
        return false;
    }

    @Override
    public void explode(Level level, BlockPos pos) {
        if (!level.isClientSide && !((Boolean)level.getBlockState(pos).getValue((Property)DEACTIVATED)).booleanValue()) {
            level.destroyBlock(pos, false);
            level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 1.0f : 3.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionInteraction());
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DEACTIVATED, WATERLOGGED});
    }

    @Override
    public boolean isActive(Level level, BlockPos pos) {
        return (Boolean)level.getBlockState(pos).getValue((Property)DEACTIVATED) == false;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MineBlockEntity(pos, state);
    }
}

