/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;

public class SecureRedstoneInterfaceBlock
extends DisguisableBlock {
    public static final BooleanProperty SENDER = BooleanProperty.create((String)"sender");
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    private static final VoxelShape[] SENDER_SHAPES = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), (VoxelShape)Block.box((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)7.0, (double)7.0, (double)1.0, (double)9.0, (double)9.0, (double)9.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)7.0), (VoxelShape)Block.box((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)15.0)), Shapes.or((VoxelShape)Block.box((double)9.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)1.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)7.0, (double)7.0, (double)7.0, (double)15.0, (double)9.0, (double)9.0))};
    private static final VoxelShape[] RECEIVER_SHAPES = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)7.0, (double)3.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), (VoxelShape)Block.box((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)7.0, (double)7.0, (double)3.0, (double)9.0, (double)9.0, (double)9.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)7.0), (VoxelShape)Block.box((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)13.0)), Shapes.or((VoxelShape)Block.box((double)9.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)3.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)7.0, (double)7.0, (double)7.0, (double)13.0, (double)9.0, (double)9.0))};

    public SecureRedstoneInterfaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)SENDER, (Comparable)Boolean.valueOf(true))).setValue(FACING, (Comparable)Direction.UP));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getShape(level, pos, ctx);
        }
        return ((Boolean)state.getValue((Property)SENDER) != false ? SENDER_SHAPES : RECEIVER_SHAPES)[((Direction)state.getValue(FACING)).get3DDataValue()];
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        SecureRedstoneInterfaceBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SecureRedstoneInterfaceBlockEntity && (be = (SecureRedstoneInterfaceBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            if (!level.isClientSide) {
                if (be.isDisabled()) {
                    player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else if (be.getOwner().isValidated()) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new OpenScreen(OpenScreen.DataType.SECURE_REDSTONE_INTERFACE, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:universalOwnerChanger.ownerInvalidated", new Object[0]), ChatFormatting.RED);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean isSignalSource(BlockState state) {
        return (Boolean)state.getValue((Property)SENDER) == false;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, Orientation orientation, boolean movedByPiston) {
        SecureRedstoneInterfaceBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SecureRedstoneInterfaceBlockEntity && (be = (SecureRedstoneInterfaceBlockEntity)blockEntity).isSender() && !be.isDisabled()) {
            be.refreshPower();
        }
    }

    protected int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        if (state.getValue(FACING) == direction) {
            return this.getSignal(state, level, pos, direction);
        }
        return 0;
    }

    protected int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SecureRedstoneInterfaceBlockEntity) {
            SecureRedstoneInterfaceBlockEntity be = (SecureRedstoneInterfaceBlockEntity)blockEntity;
            return be.getRedstonePowerOutput();
        }
        return 0;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)super.getStateForPlacement(ctx).setValue(FACING, (Comparable)ctx.getClickedFace());
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SecureRedstoneInterfaceBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return SecureRedstoneInterfaceBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.SECURE_REDSTONE_INTERFACE_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SENDER, FACING, WATERLOGGED});
    }

    public static class DoorActivator
    implements IDoorActivator {
        private final List<Block> blocks = Arrays.asList((Block)SCContent.SECURE_REDSTONE_INTERFACE.get());

        @Override
        public boolean isPowering(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Direction direction, int distance) {
            SecureRedstoneInterfaceBlockEntity be;
            return (Boolean)state.getValue((Property)SENDER) == false && blockEntity instanceof SecureRedstoneInterfaceBlockEntity && (be = (SecureRedstoneInterfaceBlockEntity)blockEntity).isProtectedSignal() && be.getPower() > 0;
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }
    }
}

