/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ProjectorBlock
extends DisguisableBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty HANGING = BlockStateProperties.HANGING;
    private static final VoxelShape FLOOR_NORTH = Shapes.or((VoxelShape)Block.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), Block.box((double)9.0, (double)2.0, (double)15.0, (double)14.0, (double)7.0, (double)16.0), Block.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0)});
    private static final VoxelShape FLOOR_SOUTH = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), Block.box((double)2.0, (double)2.0, (double)0.0, (double)7.0, (double)7.0, (double)1.0), Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0)});
    private static final VoxelShape FLOOR_WEST = Shapes.or((VoxelShape)Block.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), Block.box((double)15.0, (double)2.0, (double)2.0, (double)16.0, (double)7.0, (double)7.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0)});
    private static final VoxelShape FLOOR_EAST = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), Block.box((double)0.0, (double)2.0, (double)9.0, (double)1.0, (double)7.0, (double)14.0), Block.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0)});
    private static final VoxelShape CEILING_NORTH = Shapes.or((VoxelShape)Block.box((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)9.0, (double)6.0, (double)15.0, (double)14.0, (double)11.0, (double)16.0), Block.box((double)7.0, (double)11.0, (double)4.0, (double)9.0, (double)16.0, (double)6.0)});
    private static final VoxelShape CEILING_SOUTH = Shapes.or((VoxelShape)Block.box((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)6.0, (double)0.0, (double)7.0, (double)11.0, (double)1.0), Block.box((double)7.0, (double)11.0, (double)10.0, (double)9.0, (double)16.0, (double)12.0)});
    private static final VoxelShape CEILING_WEST = Shapes.or((VoxelShape)Block.box((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)15.0, (double)6.0, (double)2.0, (double)16.0, (double)11.0, (double)7.0), Block.box((double)4.0, (double)11.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0)});
    private static final VoxelShape CEILING_EAST = Shapes.or((VoxelShape)Block.box((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)6.0, (double)9.0, (double)1.0, (double)11.0, (double)14.0), Block.box((double)10.0, (double)11.0, (double)7.0, (double)12.0, (double)16.0, (double)9.0)});

    public ProjectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)HANGING, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getShape(level, pos, ctx);
        }
        if (!((Boolean)disguisedState.getValue((Property)HANGING)).booleanValue()) {
            return switch ((Direction)disguisedState.getValue(FACING)) {
                case Direction.NORTH -> FLOOR_NORTH;
                case Direction.EAST -> FLOOR_EAST;
                case Direction.SOUTH -> FLOOR_SOUTH;
                case Direction.WEST -> FLOOR_WEST;
                default -> Shapes.block();
            };
        }
        return switch ((Direction)disguisedState.getValue(FACING)) {
            case Direction.NORTH -> CEILING_NORTH;
            case Direction.EAST -> CEILING_EAST;
            case Direction.SOUTH -> CEILING_SOUTH;
            case Direction.WEST -> CEILING_WEST;
            default -> Shapes.block();
        };
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ProjectorBlockEntity)) {
            return InteractionResult.FAIL;
        }
        ProjectorBlockEntity be = (ProjectorBlockEntity)blockEntity;
        boolean isOwner = be.isOwnedBy((Entity)player);
        if (!level.isClientSide && isOwner) {
            player.openMenu((MenuProvider)be);
        }
        return isOwner ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return direction != null && direction.getAxis() != Direction.Axis.Y;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, Orientation orientation, boolean isMoving) {
        ProjectorBlockEntity be;
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof ProjectorBlockEntity && (be = (ProjectorBlockEntity)blockEntity).isActivatedByRedstone()) {
            be.setActive(level.hasNeighborSignal(pos));
            level.sendBlockUpdated(pos, state, state, 3);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        ProjectorBlockEntity be;
        BlockEntity blockEntity;
        if (!level.hasNeighborSignal(pos) && (blockEntity = level.getBlockEntity(pos)) instanceof ProjectorBlockEntity && (be = (ProjectorBlockEntity)blockEntity).isActivatedByRedstone()) {
            be.setActive(false);
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)super.getStateForPlacement(ctx).setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)HANGING, (Comparable)Boolean.valueOf(ctx.getClickedFace() == Direction.DOWN));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HANGING, WATERLOGGED});
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ProjectorBlockEntity(pos, state);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }
}

