/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.MotionActivatedLightBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MotionActivatedLightBlock
extends OwnableBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)6.0, (double)3.0, (double)13.0, (double)10.0, (double)4.0, (double)14.0), (VoxelShape)Shapes.or((VoxelShape)Block.box((double)6.0, (double)6.0, (double)13.0, (double)10.0, (double)9.0, (double)14.0), (VoxelShape)Shapes.joinUnoptimized((VoxelShape)Block.box((double)7.0, (double)3.0, (double)14.0, (double)9.0, (double)8.0, (double)16.0), (VoxelShape)Block.box((double)7.0, (double)4.0, (double)14.0, (double)9.0, (double)7.0, (double)15.0), (BooleanOp)BooleanOp.ONLY_FIRST)));
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)Block.box((double)2.0, (double)3.0, (double)6.0, (double)3.0, (double)4.0, (double)10.0), (VoxelShape)Shapes.or((VoxelShape)Block.box((double)2.0, (double)6.0, (double)6.0, (double)3.0, (double)9.0, (double)10.0), (VoxelShape)Shapes.joinUnoptimized((VoxelShape)Block.box((double)0.0, (double)3.0, (double)7.0, (double)2.0, (double)8.0, (double)9.0), (VoxelShape)Block.box((double)1.0, (double)4.0, (double)7.0, (double)2.0, (double)7.0, (double)9.0), (BooleanOp)BooleanOp.ONLY_FIRST)));
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)6.0, (double)3.0, (double)2.0, (double)10.0, (double)4.0, (double)3.0), (VoxelShape)Shapes.or((VoxelShape)Block.box((double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)9.0, (double)3.0), (VoxelShape)Shapes.joinUnoptimized((VoxelShape)Block.box((double)7.0, (double)3.0, (double)0.0, (double)9.0, (double)8.0, (double)2.0), (VoxelShape)Block.box((double)7.0, (double)4.0, (double)1.0, (double)9.0, (double)7.0, (double)2.0), (BooleanOp)BooleanOp.ONLY_FIRST)));
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)Block.box((double)13.0, (double)3.0, (double)6.0, (double)14.0, (double)4.0, (double)10.0), (VoxelShape)Shapes.or((VoxelShape)Block.box((double)13.0, (double)6.0, (double)6.0, (double)14.0, (double)9.0, (double)10.0), (VoxelShape)Shapes.joinUnoptimized((VoxelShape)Block.box((double)14.0, (double)3.0, (double)7.0, (double)16.0, (double)8.0, (double)9.0), (VoxelShape)Block.box((double)14.0, (double)4.0, (double)7.0, (double)15.0, (double)7.0, (double)9.0), (BooleanOp)BooleanOp.ONLY_FIRST)));

    public MotionActivatedLightBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> Shapes.block();
        };
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction side = (Direction)state.getValue(FACING);
        return side != Direction.UP && side != Direction.DOWN && BlockUtils.isSideSolid(level, pos.relative(side.getOpposite()), side);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Direction facing = ctx.getClickedFace();
        return facing != Direction.UP && facing != Direction.DOWN && BlockUtils.isSideSolid((LevelReader)level, pos.relative(facing.getOpposite()), facing) ? (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER)) : null;
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, tickAccess, pos, facing, facingPos, facingState, random);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, Orientation orientation, boolean flag) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT, WATERLOGGED});
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MotionActivatedLightBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : BaseEntityBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.MOTION_LIGHT_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.getValue(FACING);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.getAxis() != Direction.Axis.Z) break;
                return (BlockState)state.setValue(FACING, (Comparable)facing.getOpposite());
            }
            case FRONT_BACK: {
                if (facing.getAxis() != Direction.Axis.X) break;
                return (BlockState)state.setValue(FACING, (Comparable)facing.getOpposite());
            }
        }
        return state;
    }
}

