/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerFieldBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;

public class InventoryScannerBlock
extends DisguisableBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty HORIZONTAL = BooleanProperty.create((String)"horizontal");

    public InventoryScannerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)HORIZONTAL, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (this.isFacingAnotherScanner(level, pos) && player instanceof ServerPlayer) {
            BlockEntity blockEntity;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof InventoryScannerBlockEntity) {
                InventoryScannerBlockEntity be = (InventoryScannerBlockEntity)blockEntity;
                if (be.isDisabled()) {
                    player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else {
                    serverPlayer.openMenu((MenuProvider)be);
                }
            }
            return InteractionResult.SUCCESS;
        }
        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((InventoryScannerBlock)SCContent.INVENTORY_SCANNER.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:invScan.notConnected", new Object[0]), ChatFormatting.RED);
        return InteractionResult.SUCCESS;
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        if (level.isClientSide) {
            return;
        }
        InventoryScannerBlock.checkAndPlaceAppropriately(level, pos, false);
    }

    public static void checkAndPlaceAppropriately(Level level, BlockPos pos, boolean force) {
        InventoryScannerBlockEntity thisBe = (InventoryScannerBlockEntity)level.getBlockEntity(pos);
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(level, pos);
        if (connectedScanner == null || !connectedScanner.getOwner().owns(thisBe)) {
            return;
        }
        if (!force) {
            if (connectedScanner.isDisabled()) {
                thisBe.setDisabled(true);
                return;
            }
        } else {
            thisBe.setDisabled(false);
            connectedScanner.setDisabled(false);
        }
        boolean horizontal = false;
        if (((Boolean)connectedScanner.getBlockState().getValue((Property)HORIZONTAL)).booleanValue()) {
            horizontal = true;
        }
        Direction facing = (Direction)level.getBlockState(pos).getValue(FACING);
        int loopBoundary = switch (facing) {
            case Direction.WEST, Direction.EAST -> Math.abs(pos.getX() - connectedScanner.getBlockPos().getX());
            case Direction.NORTH, Direction.SOUTH -> Math.abs(pos.getZ() - connectedScanner.getBlockPos().getZ());
            default -> 0;
        };
        thisBe.setHorizontal(horizontal);
        for (int i = 1; i < loopBoundary; ++i) {
            if (level.getBlockState(pos.relative(facing, i)).getBlock() != SCContent.INVENTORY_SCANNER_FIELD.get()) continue;
            return;
        }
        Option<?>[] customOptions = thisBe.customOptions();
        for (int i = 1; i < loopBoundary; ++i) {
            BlockPos offsetPos = pos.relative(facing, i);
            level.setBlockAndUpdate(offsetPos, (BlockState)((BlockState)((BlockState)((InventoryScannerFieldBlock)((Object)SCContent.INVENTORY_SCANNER_FIELD.get())).defaultBlockState().setValue(FACING, (Comparable)facing)).setValue((Property)HORIZONTAL, (Comparable)Boolean.valueOf(horizontal))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER)));
            BlockEntity blockEntity = level.getBlockEntity(offsetPos);
            if (!(blockEntity instanceof IOwnable)) continue;
            IOwnable ownable = (IOwnable)blockEntity;
            ownable.setOwner(thisBe.getOwner().getUUID(), thisBe.getOwner().getName());
        }
        for (ModuleType type : connectedScanner.getInsertedModules()) {
            thisBe.insertModule(connectedScanner.getModule(type), false);
        }
        ((Option.BooleanOption)customOptions[0]).setValue(connectedScanner.isHorizontal());
        ((Option.BooleanOption)customOptions[1]).setValue(connectedScanner.doesFieldSolidify());
        ((Option.BooleanOption)customOptions[2]).setValue(false);
    }

    public void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean isMoving) {
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner((Level)level, pos, state, null);
        BlockUtils.removeInSequence((direction, stateToCheck) -> {
            if (stateToCheck.getBlock() != SCContent.INVENTORY_SCANNER_FIELD.get()) {
                return false;
            }
            Direction stateToCheckFacing = (Direction)stateToCheck.getValue(FACING);
            return stateToCheckFacing == direction || stateToCheckFacing == direction.getOpposite();
        }, (LevelAccessor)level, pos, (Direction)state.getValue(FACING));
        level.updateNeighborsAt(pos, (Block)this);
        BlockUtils.updateIndirectNeighbors((Level)level, pos, (Block)this);
        if (connectedScanner != null) {
            for (int i = 0; i < connectedScanner.getContents().size(); ++i) {
                connectedScanner.getContents().set(i, (Object)ItemStack.EMPTY);
            }
            connectedScanner.getLensContainer().clearContent();
        }
        super.affectNeighborsAfterRemoval(state, level, pos, isMoving);
    }

    private boolean isFacingAnotherScanner(Level level, BlockPos pos) {
        return InventoryScannerBlock.getConnectedInventoryScanner(level, pos) != null;
    }

    public static InventoryScannerBlockEntity getConnectedInventoryScanner(Level level, BlockPos pos) {
        return InventoryScannerBlock.getConnectedInventoryScanner(level, pos, level.getBlockState(pos), null);
    }

    public static InventoryScannerBlockEntity getConnectedInventoryScanner(Level level, BlockPos pos, BlockState stateAtPos, Consumer<OwnableBlockEntity> fieldModifier) {
        Direction facing = (Direction)stateAtPos.getValue(FACING);
        ArrayList<BlockPos> fields = new ArrayList<BlockPos>();
        for (int i = 0; i <= (Integer)ConfigHandler.SERVER.inventoryScannerRange.get(); ++i) {
            boolean isField;
            BlockPos offsetPos = pos.relative(facing, i);
            BlockState state = level.getBlockState(offsetPos);
            Block block = state.getBlock();
            boolean bl = isField = block == SCContent.INVENTORY_SCANNER_FIELD.get();
            if (!(isField || state.isAir() || state.canBeReplaced() || block == SCContent.INVENTORY_SCANNER.get())) {
                return null;
            }
            if (isField) {
                fields.add(offsetPos);
            }
            if (block != SCContent.INVENTORY_SCANNER.get() || state.getValue(FACING) != facing.getOpposite()) continue;
            if (fieldModifier != null) {
                fields.stream().map(arg_0 -> ((Level)level).getBlockEntity(arg_0)).forEach(be -> fieldModifier.accept((OwnableBlockEntity)be));
            }
            return (InventoryScannerBlockEntity)level.getBlockEntity(offsetPos);
        }
        return null;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, Orientation orientation, boolean flag) {
        InventoryScannerBlock.checkAndPlaceAppropriately(level, pos, false);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof InventoryScannerBlockEntity)) {
            return 0;
        }
        InventoryScannerBlockEntity be = (InventoryScannerBlockEntity)blockEntity;
        return be.isProvidingPower() ? 15 : 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return this.getSignal(state, level, pos, side);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)super.getStateForPlacement(ctx).setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HORIZONTAL, WATERLOGGED});
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new InventoryScannerBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return InventoryScannerBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.INVENTORY_SCANNER_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    public static class DoorActivator
    implements IDoorActivator {
        private List<Block> blocks = Arrays.asList((Block)SCContent.INVENTORY_SCANNER.get());

        @Override
        public boolean isPowering(Level level, BlockPos pos, BlockState state, BlockEntity be, Direction direction, int distance) {
            return ((InventoryScannerBlockEntity)be).isProvidingPower();
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }
    }
}

