/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class TrackMineBlockEntity
extends OwnableBlockEntity {
    private boolean active = true;

    public TrackMineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.TRACK_MINE_BLOCK_ENTITY.get(), pos, state);
    }

    public void activate() {
        if (!this.active) {
            this.active = true;
            this.setChanged();
        }
    }

    public void deactivate() {
        if (this.active) {
            this.active = false;
            this.setChanged();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void saveAdditional(ValueOutput tag) {
        tag.putBoolean("TrackMineEnabled", this.active);
        super.saveAdditional(tag);
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.active = tag.getBooleanOr("TrackMineEnabled", true);
    }
}

