/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.ScannerTrapDoorBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class ScannerTrapdoorBlockEntity
extends DisguisableBlockEntity
implements IViewActivated,
ITickingBlockEntity,
ILockable {
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    protected Option.IntOption signalLength = new Option.IntOption("signalLength", 0, 0, 400, 5);
    private Option.DoubleOption maximumDistance = new Option.DoubleOption(this, "maximumDistance", 5.0, 0.1, 25.0, 0.1){

        @Override
        public String getKey(String denotation) {
            return "option.generic.viewActivated.maximumDistance";
        }
    };
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private int viewCooldown = 0;

    public ScannerTrapdoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.SCANNER_TRAPDOOR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        this.checkView(level, pos);
    }

    @Override
    public boolean onEntityViewed(LivingEntity entity, BlockHitResult hitResult) {
        block13: {
            Player player;
            BlockState state;
            block15: {
                block14: {
                    if (this.isConsideredInvisible(entity)) break block13;
                    state = this.getBlockState();
                    if (!(entity instanceof Player)) break block14;
                    player = (Player)entity;
                    if (this.isModuleEnabled(ModuleType.DISGUISE) || ((Boolean)state.getValue((Property)TrapDoorBlock.OPEN) == false ? hitResult.getDirection().getAxis() == Direction.Axis.Y : hitResult.getDirection().getAxis() == ((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getAxis())) break block15;
                }
                return false;
            }
            if (!this.isLocked() && !this.isDisabled()) {
                boolean shouldBeOpen;
                Owner viewingPlayer = new Owner(player);
                if (((Boolean)ConfigHandler.SERVER.trickScannersWithPlayerHeads.get()).booleanValue() && player.getItemBySlot(EquipmentSlot.HEAD).getItem() == Items.PLAYER_HEAD) {
                    viewingPlayer = PlayerUtils.getSkullOwner(player);
                }
                if (!this.isOwnedBy(viewingPlayer) && !this.isAllowed(viewingPlayer.getName())) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((ScannerTrapDoorBlock)SCContent.SCANNER_TRAPDOOR.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:retinalScanner.notOwner", PlayerUtils.getOwnerComponent(this.getOwner())), ChatFormatting.RED);
                    return true;
                }
                boolean bl = shouldBeOpen = (Boolean)state.getValue((Property)TrapDoorBlock.OPEN) == false;
                if (shouldBeOpen && ((Boolean)this.sendMessage.get()).booleanValue()) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((ScannerTrapDoorBlock)SCContent.SCANNER_TRAPDOOR.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:retinalScanner.hello", viewingPlayer.getName()), ChatFormatting.GREEN);
                }
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(shouldBeOpen)));
                BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, (Block)SCContent.SCANNER_TRAPDOOR.get());
                ((ScannerTrapDoorBlock)SCContent.SCANNER_TRAPDOOR.get()).playSound(null, this.level, this.worldPosition, shouldBeOpen);
                if (this.getSignalLength() > 0) {
                    this.level.scheduleTick(this.worldPosition, (Block)SCContent.SCANNER_TRAPDOOR.get(), this.getSignalLength());
                }
            } else if (this.isLocked() && ((Boolean)this.sendMessage.get()).booleanValue()) {
                MutableComponent blockName = Utils.localize(((ScannerTrapDoorBlock)SCContent.SCANNER_TRAPDOOR.get()).getDescriptionId(), new Object[0]);
                PlayerUtils.sendMessageToPlayer(player, blockName, Utils.localize("messages.securitycraft:sonic_security_system.locked", blockName), ChatFormatting.DARK_RED, false);
            } else if (this.isDisabled()) {
                player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getViewCooldown() {
        return this.viewCooldown;
    }

    @Override
    public void setViewCooldown(int viewCooldown) {
        this.viewCooldown = viewCooldown;
        this.setChanged();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public double getMaximumDistance() {
        return (Double)this.maximumDistance.get();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength, this.disabled, this.maximumDistance, this.respectInvisibility};
    }

    @Override
    public boolean isConsideredInvisible(LivingEntity entity) {
        return this.respectInvisibility.isConsideredInvisible(entity);
    }
}

