/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import com.mojang.authlib.properties.PropertyMap;
import java.util.Optional;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.RetinalScannerBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;

public class RetinalScannerBlockEntity
extends DisguisableBlockEntity
implements IViewActivated,
ITickingBlockEntity,
ILockable {
    private Option.BooleanOption activatedByEntities = new Option.BooleanOption("activatedByEntities", false);
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.SignalLengthOption(60);
    private Option.DoubleOption maximumDistance = new Option.DoubleOption(this, "maximumDistance", 5.0, 0.1, 25.0, 0.1){

        @Override
        public String getKey(String denotation) {
            return "option.generic.viewActivated.maximumDistance";
        }
    };
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private ResolvableProfile ownerProfile;
    private int viewCooldown = 0;

    public RetinalScannerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.RETINAL_SCANNER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        this.checkView(level, pos);
    }

    @Override
    public boolean onEntityViewed(LivingEntity entity, BlockHitResult hitResult) {
        if (!this.isLocked() && !this.isDisabled()) {
            BlockState state = this.getBlockState();
            if (state.getValue(RetinalScannerBlock.FACING) != hitResult.getDirection()) {
                return false;
            }
            int signalLength = this.getSignalLength();
            if (!(((Boolean)state.getValue((Property)RetinalScannerBlock.POWERED)).booleanValue() && signalLength != 0 || this.isConsideredInvisible(entity))) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    Owner viewingPlayer = new Owner(player);
                    if (((Boolean)ConfigHandler.SERVER.trickScannersWithPlayerHeads.get()).booleanValue() && player.getItemBySlot(EquipmentSlot.HEAD).getItem() == Items.PLAYER_HEAD) {
                        viewingPlayer = PlayerUtils.getSkullOwner(player);
                    }
                    if (!this.isOwnedBy(viewingPlayer) && !this.isAllowed(viewingPlayer.getName())) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((RetinalScannerBlock)SCContent.RETINAL_SCANNER.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:retinalScanner.notOwner", PlayerUtils.getOwnerComponent(this.getOwner())), ChatFormatting.RED);
                        return true;
                    }
                    if (((Boolean)this.sendMessage.get()).booleanValue()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((RetinalScannerBlock)SCContent.RETINAL_SCANNER.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:retinalScanner.hello", viewingPlayer.getName()), ChatFormatting.GREEN);
                    }
                } else if (this.activatedOnlyByPlayer()) {
                    return false;
                }
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.cycle((Property)RetinalScannerBlock.POWERED));
                BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, (Block)SCContent.RETINAL_SCANNER.get());
                if (signalLength > 0) {
                    this.level.scheduleTick(new BlockPos((Vec3i)this.worldPosition), (Block)SCContent.RETINAL_SCANNER.get(), signalLength);
                }
                return true;
            }
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isLocked() && ((Boolean)this.sendMessage.get()).booleanValue()) {
                MutableComponent blockName = Utils.localize(((RetinalScannerBlock)SCContent.RETINAL_SCANNER.get()).getDescriptionId(), new Object[0]);
                PlayerUtils.sendMessageToPlayer(player, blockName, Utils.localize("messages.securitycraft:sonic_security_system.locked", blockName), ChatFormatting.DARK_RED, false);
            } else if (this.isDisabled()) {
                player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            }
            return true;
        }
        return false;
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.signalLength) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)RetinalScannerBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, this.getBlockState().getBlock());
        }
        super.onOptionChanged(option);
    }

    @Override
    public int getDefaultViewCooldown() {
        return this.getSignalLength() + 30;
    }

    @Override
    public int getViewCooldown() {
        return this.viewCooldown;
    }

    @Override
    public void setViewCooldown(int viewCooldown) {
        this.viewCooldown = viewCooldown;
        this.setChanged();
    }

    @Override
    public boolean activatedOnlyByPlayer() {
        return (Boolean)this.activatedByEntities.get() == false;
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public double getMaximumDistance() {
        return (Double)this.maximumDistance.get();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.activatedByEntities, this.sendMessage, this.signalLength, this.disabled, this.maximumDistance, this.respectInvisibility};
    }

    @Override
    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        if (!StringUtil.isNullOrEmpty((String)this.getOwner().getName()) && !this.getOwner().getName().equals("owner") && this.ownerProfile != null) {
            tag.store("ownerProfile", ResolvableProfile.CODEC, (Object)this.ownerProfile);
        }
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.setOwnerProfile(tag.read("ownerProfile", ResolvableProfile.CODEC).orElse(null));
    }

    @Override
    public void onOwnerChanged(BlockState state, Level world, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        this.setOwnerProfile(new ResolvableProfile(Optional.of(this.getOwner().getName()), Optional.empty(), new PropertyMap()));
        super.onOwnerChanged(state, world, pos, player, oldOwner, newOwner);
    }

    public void setOwnerProfile(ResolvableProfile ownerProfile) {
        this.ownerProfile = ownerProfile;
        this.updateOwnerProfile();
    }

    private void updateOwnerProfile() {
        if (this.ownerProfile != null && !this.ownerProfile.isResolved()) {
            this.ownerProfile.resolve().thenAcceptAsync(ownerProfile -> {
                this.ownerProfile = ownerProfile;
                this.setChanged();
            }, SkullBlockEntity.CHECKED_MAIN_THREAD_EXECUTOR);
        } else {
            this.setChanged();
        }
    }

    public ResolvableProfile getPlayerProfile() {
        return this.ownerProfile;
    }

    @Override
    public boolean isConsideredInvisible(LivingEntity entity) {
        return this.respectInvisibility.isConsideredInvisible(entity);
    }
}

