/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.EnumMap;
import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedHopperBlock;
import net.geforcemods.securitycraft.inventory.VanillaHopperInsertOnlyItemHandler;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.IPistonMoveListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.VanillaHopperItemHandler;
import net.neoforged.neoforge.model.data.ModelData;

public class ReinforcedHopperBlockEntity
extends HopperBlockEntity
implements IOwnable,
IModuleInventory,
IPistonMoveListener {
    private NonNullList<ItemStack> modules = NonNullList.withSize((int)this.getMaxNumberOfModules(), (Object)ItemStack.EMPTY);
    private Owner owner = new Owner();
    private Map<ModuleType, Boolean> moduleStates = new EnumMap<ModuleType, Boolean>(ModuleType.class);

    public ReinforcedHopperBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public boolean isValidBlockState(BlockState state) {
        return this.getType().isValid(state);
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)SCContent.REINFORCED_HOPPER_BLOCK_ENTITY.get();
    }

    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.owner.load(tag);
        this.modules = this.readModuleInventory(tag);
        this.moduleStates = this.readModuleStates(tag);
    }

    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        if (this.owner != null) {
            this.owner.save(tag, this.needsValidation());
        }
        this.writeModuleInventory(tag);
        this.writeModuleStates(tag);
    }

    @Override
    public void prePistonPushSideEffects(BlockPos pos, BlockState state) {
        this.clearContent();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveCustomOnly(lookupProvider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ValueInput tag) {
        super.onDataPacket(net, tag);
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    public void onLoad() {
        super.onLoad();
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleInserted((BlockEntity)this, stack, toggled);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleRemoved((BlockEntity)this, stack, toggled);
        }
    }

    public void setRemoved() {
        super.setRemoved();
        DisguisableBlockEntity.onSetRemoved((BlockEntity)this);
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
        this.setChanged();
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : super.getItem(slot);
    }

    public ItemStack getItem(int slot) {
        return this.getStackInSlot(slot);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)((ReinforcedHopperBlock)SCContent.REINFORCED_HOPPER.get()).getDescriptionId());
    }

    public static IItemHandler getCapability(ReinforcedHopperBlockEntity be, Direction side) {
        return BlockUtils.isAllowedToExtractFromProtectedObject(side, be) ? new VanillaHopperItemHandler((HopperBlockEntity)be) : new VanillaHopperInsertOnlyItemHandler(be);
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && this.moduleStates.get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        this.moduleStates.put(module, shouldBeEnabled);
    }

    @Override
    public boolean needsValidation() {
        return true;
    }

    @Override
    public Level myLevel() {
        return this.level;
    }

    @Override
    public BlockPos myPos() {
        return this.worldPosition;
    }

    public ModelData getModelData() {
        return DisguisableBlockEntity.getModelData((BlockEntity)this);
    }
}

