/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.LaserFieldBlock;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.inventory.LaserBlockMenu;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.UpdateLaserColors;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;

public class LaserBlockBlockEntity
extends LinkableBlockEntity
implements MenuProvider,
ContainerListener {
    private Option.DisabledOption disabled = new Option.DisabledOption((Boolean)false){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            LaserBlockBlockEntity.this.setLasersAccordingToDisabledOption();
        }
    };
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.IntOption signalLength = new Option.SignalLengthOption(50);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private Map<Direction, Boolean> sideConfig = (Map)Util.make(() -> {
        EnumMap<Direction, Boolean> map = new EnumMap<Direction, Boolean>(Direction.class);
        for (Direction dir : Direction.values()) {
            map.put(dir, true);
        }
        return map;
    });
    private LensContainer lenses = new LensContainer(6);
    private long lastToggleTime;

    public LaserBlockBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.LASER_BLOCK_BLOCK_ENTITY.get(), pos, state);
        this.lenses.addListener(this);
    }

    @Override
    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        LaserBlockBlockEntity.saveSideConfig(tag.child("sideConfig"), this.sideConfig);
        for (int i = 0; i < this.lenses.getContainerSize(); ++i) {
            ItemStack lens = this.lenses.getItem(i);
            if (lens.isEmpty()) continue;
            tag.store("lens" + i, ItemStack.CODEC, (Object)lens);
        }
    }

    public static void saveSideConfig(ValueOutput sideConfigTag, Map<Direction, Boolean> sideConfig) {
        sideConfig.forEach((dir, enabled) -> sideConfigTag.putBoolean(dir.getName(), enabled.booleanValue()));
    }

    public static CompoundTag saveSideConfigToTag(Map<Direction, Boolean> sideConfig) {
        CompoundTag sideConfigTag = new CompoundTag();
        sideConfig.forEach((dir, enabled) -> sideConfigTag.putBoolean(dir.getName(), enabled.booleanValue()));
        return sideConfigTag;
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.sideConfig = LaserBlockBlockEntity.loadSideConfig(tag.childOrEmpty("sideConfig"));
        for (int i = 0; i < this.lenses.getContainerSize(); ++i) {
            this.lenses.setItemExclusively(i, tag.read("lens" + i, ItemStack.CODEC).orElse(ItemStack.EMPTY));
        }
        this.lenses.setChanged();
    }

    public static Map<Direction, Boolean> loadSideConfig(ValueInput sideConfigTag) {
        EnumMap<Direction, Boolean> sideConfig = new EnumMap<Direction, Boolean>(Direction.class);
        for (Direction dir : Direction.values()) {
            sideConfig.put(dir, sideConfigTag.getBooleanOr(dir.getName(), true));
        }
        return sideConfig;
    }

    public static Map<Direction, Boolean> loadSideConfigFromTag(CompoundTag sideConfigTag) {
        EnumMap<Direction, Boolean> sideConfig = new EnumMap<Direction, Boolean>(Direction.class);
        for (Direction dir : Direction.values()) {
            if (sideConfigTag.contains(dir.getName())) {
                sideConfig.put(dir, sideConfigTag.getBooleanOr(dir.getName(), false));
                continue;
            }
            sideConfig.put(dir, true);
        }
        return sideConfig;
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        if (this.level != null) {
            Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.lenses);
            this.lenses.clearContent();
        }
        super.preRemoveSideEffects(pos, state);
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        super.writeClientSideData(menu, buffer);
        buffer.writeBlockPos(this.worldPosition);
        buffer.writeNbt((Tag)LaserBlockBlockEntity.saveSideConfigToTag(this.sideConfig));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected void onLinkedBlockAction(ILinkedAction action, List<LinkableBlockEntity> excludedBEs) {
        block35: {
            v0 = action;
            Objects.requireNonNull(v0);
            var3_3 = v0;
            var4_5 = 0;
            block25: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ILinkedAction.OptionChanged.class, ILinkedAction.ModuleInserted.class, ILinkedAction.ModuleRemoved.class, ILinkedAction.OwnerChanged.class, ILinkedAction.StateChanged.class}, (Object)var3_3, var4_5)) {
                    case 0: {
                        var5_11 = (ILinkedAction.OptionChanged)var3_3;
                        var11_12 = var5_11.option();
                        var12_14 = 0;
                        block26: while (true) {
                            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Option.BooleanOption.class, Option.BooleanOption.class, Option.BooleanOption.class, Option.IntOption.class, Option.class}, var11_12, var12_14)) {
                                default: {
                                    throw new MatchException(null, null);
                                }
                                case 0: {
                                    option = (Option.BooleanOption)var11_12;
                                    if (!option.getName().equals(this.disabled.getName())) {
                                        var12_14 = 1;
                                        continue block26;
                                    }
                                    this.disabled.copy(option);
                                    this.setLasersAccordingToDisabledOption();
                                    break block25;
                                }
                                case 1: {
                                    option = (Option.BooleanOption)var11_12;
                                    if (!option.getName().equals(this.ignoreOwner.getName())) {
                                        var12_14 = 2;
                                        continue block26;
                                    }
                                    this.ignoreOwner.copy(option);
                                    break block25;
                                }
                                case 2: {
                                    option = (Option.BooleanOption)var11_12;
                                    if (!option.getName().equals(this.respectInvisibility.getName())) {
                                        var12_14 = 3;
                                        continue block26;
                                    }
                                    this.respectInvisibility.copy(option);
                                    break block25;
                                }
                                case 3: {
                                    option = (Option.IntOption)var11_12;
                                    if (!option.getName().equals(this.signalLength.getName())) {
                                        var12_14 = 4;
                                        continue block26;
                                    }
                                    this.signalLength.copy(option);
                                    this.turnOffRedstoneOutput();
                                    break block25;
                                }
                                case -1: 
                                case 4: 
                            }
                            break;
                        }
                        option = var11_12;
                        throw new UnsupportedOperationException("Unhandled option synchronization in laser block! " + option.getName());
                    }
                    case 1: {
                        var11_13 = (ILinkedAction.ModuleInserted)var3_3;
                        stack = var15_21 /* !! */  = var11_13.stack();
                        module /* !! */  = var15_21 /* !! */  = var11_13.module();
                        wasModuleToggled = var15_22 = var11_13.wasModuleToggled();
                        this.insertModule(stack, wasModuleToggled);
                        break block25;
                    }
                    case 2: {
                        var15_23 = (ILinkedAction.ModuleRemoved)var3_3;
                        moduleType = var18_26 = var15_23.moduleType();
                        wasModuleToggled = var18_27 = var15_23.wasModuleToggled();
                        this.removeModule(moduleType, wasModuleToggled);
                        break block25;
                    }
                    case 3: {
                        var18_28 = (ILinkedAction.OwnerChanged)var3_3;
                        newOwner = var20_6 = var18_28.newOwner();
                        this.setOwner(newOwner.getUUID(), newOwner.getName());
                        break block25;
                    }
                    case 4: {
                        var20_6 = (ILinkedAction.StateChanged)var3_3;
                        var24_10 /* !! */  = var20_6.property();
                        if (!(var24_10 /* !! */  instanceof BooleanProperty)) ** GOTO lbl89
                        property = (BooleanProperty)var24_10 /* !! */ ;
                        var24_10 /* !! */  = var20_6.oldValue();
                        if (!(var24_10 /* !! */  instanceof Boolean)) ** GOTO lbl89
                        oldValue = (Boolean)var24_10 /* !! */ ;
                        var24_10 /* !! */  = var20_6.newValue();
                        if (!(var24_10 /* !! */  instanceof Boolean)) ** GOTO lbl89
                        newValue = (Boolean)var24_10 /* !! */ ;
                        if (property == LaserBlock.POWERED) ** GOTO lbl91
lbl89:
                        // 4 sources

                        var4_5 = 5;
                        continue block25;
lbl91:
                        // 1 sources

                        if (this.timeSinceLastToggle() < 500L) {
                            this.setLastToggleTime(System.currentTimeMillis());
                            break block25;
                        }
                        state = this.getBlockState();
                        signalLength = this.getSignalLength();
                        this.setLastToggleTime(System.currentTimeMillis());
                        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.cycle((Property)LaserBlock.POWERED));
                        BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, (Block)SCContent.LASER_BLOCK.get());
                        if (signalLength <= 0) break block25;
                        this.level.scheduleTick(this.worldPosition, (Block)SCContent.LASER_BLOCK.get(), signalLength);
                        break block25;
                    }
                }
                break;
            }
            break block35;
            catch (Throwable var3_4) {
                throw new MatchException(var3_4.toString(), var3_4);
            }
        }
        excludedBEs.add(this);
        this.propagate(action, excludedBEs);
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.signalLength) {
            this.turnOffRedstoneOutput();
        }
        super.onOptionChanged(option);
    }

    private void turnOffRedstoneOutput() {
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)LaserBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, this.getBlockState().getBlock());
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleInserted(this, stack, toggled);
        } else if (module == ModuleType.SMART) {
            this.applyExistingSideConfig();
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleRemoved(this, stack, toggled);
        } else if (module == ModuleType.REDSTONE) {
            if (((Boolean)this.getBlockState().getValue((Property)LaserBlock.POWERED)).booleanValue()) {
                this.turnOffRedstoneOutput();
            }
        } else if (module == ModuleType.SMART) {
            this.applyExistingSideConfig();
        }
    }

    public void containerChanged(Container container) {
        if (this.level == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            int i = 1;
            BlockPos pos = this.getBlockPos();
            BlockPos modifiedPos = pos.relative(direction, i);
            BlockState stateAtModifiedPos = this.level.getBlockState(modifiedPos);
            ArrayList<BlockPos> positionsToUpdate = new ArrayList<BlockPos>();
            while (i < (Integer)ConfigHandler.SERVER.laserBlockRange.get() && stateAtModifiedPos.getBlock() != SCContent.LASER_BLOCK.get()) {
                modifiedPos = pos.relative(direction, ++i);
                stateAtModifiedPos = this.level.getBlockState(modifiedPos);
                positionsToUpdate.add(modifiedPos);
            }
            BlockEntity blockEntity = this.level.getBlockEntity(modifiedPos);
            if (!(blockEntity instanceof LaserBlockBlockEntity)) continue;
            LaserBlockBlockEntity otherLaser = (LaserBlockBlockEntity)blockEntity;
            otherLaser.getLensContainer().setItemExclusively(direction.getOpposite().ordinal(), this.lenses.getItem(direction.ordinal()));
            if (!this.level.isClientSide) {
                PacketDistributor.sendToPlayersInDimension((ServerLevel)((ServerLevel)this.level), (CustomPacketPayload)new UpdateLaserColors(positionsToUpdate), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.level.sendBlockUpdated(modifiedPos, stateAtModifiedPos, stateAtModifiedPos, 2);
        }
        this.setChanged();
    }

    public void onDataPacket(Connection net, ValueInput tag) {
        super.onDataPacket(net, tag);
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    public void onLoad() {
        super.onLoad();
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    @Override
    public void readOptions(ValueInput tag) {
        for (Option<?> option : this.customOptions()) {
            option.load(tag);
        }
    }

    public static IItemHandler getCapability(LaserBlockBlockEntity be, Direction side) {
        return BlockUtils.isAllowedToExtractFromProtectedObject(side, be) ? new InvWrapper((Container)be.lenses) : new InsertOnlyInvWrapper((Container)be.lenses);
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new LaserBlockMenu(id, this.level, this.worldPosition, this.sideConfig, inventory);
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }

    public LensContainer getLensContainer() {
        return this.lenses;
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        DisguisableBlockEntity.onSetRemoved(this);
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.HARMING, ModuleType.ALLOWLIST, ModuleType.DISGUISE, ModuleType.REDSTONE, ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled, this.ignoreOwner, this.signalLength, this.respectInvisibility};
    }

    public ModelData getModelData() {
        return DisguisableBlockEntity.getModelData(this);
    }

    public boolean isEnabled() {
        return (Boolean)this.disabled.get() == false;
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isConsideredInvisible(LivingEntity entity) {
        return this.respectInvisibility.isConsideredInvisible(entity);
    }

    public void setLastToggleTime(long lastToggleTime) {
        this.lastToggleTime = lastToggleTime;
    }

    public long getLastToggleTime() {
        return this.lastToggleTime;
    }

    public long timeSinceLastToggle() {
        return System.currentTimeMillis() - this.getLastToggleTime();
    }

    public void applyNewSideConfig(Map<Direction, Boolean> sideConfig, Player player) {
        sideConfig.forEach((direction, enabled) -> this.setSideEnabled((Direction)direction, (boolean)enabled, player));
    }

    public void applyExistingSideConfig() {
        for (Direction direction : Direction.values()) {
            this.toggleLaserOnSide(direction, this.isSideEnabled(direction), null, false);
        }
    }

    public void setSideEnabled(Direction direction, boolean enabled, Player player) {
        this.sideConfig.put(direction, enabled);
        if (this.isModuleEnabled(ModuleType.SMART)) {
            this.toggleLaserOnSide(direction, enabled, player, true);
        }
    }

    public void toggleLaserOnSide(Direction direction, boolean enabled, Player player, boolean modifyOtherLaser) {
        BlockEntity blockEntity;
        int i = 1;
        BlockPos pos = this.getBlockPos();
        BlockPos modifiedPos = pos.relative(direction, i);
        BlockState stateAtModifiedPos = this.level.getBlockState(modifiedPos);
        while (i < (Integer)ConfigHandler.SERVER.laserBlockRange.get() && stateAtModifiedPos.getBlock() != SCContent.LASER_BLOCK.get()) {
            modifiedPos = pos.relative(direction, ++i);
            stateAtModifiedPos = this.level.getBlockState(modifiedPos);
        }
        if (modifyOtherLaser && (blockEntity = this.level.getBlockEntity(modifiedPos)) instanceof LaserBlockBlockEntity) {
            LaserBlockBlockEntity otherLaser = (LaserBlockBlockEntity)blockEntity;
            otherLaser.sideConfig.put(direction.getOpposite(), enabled);
        }
        if (enabled && (blockEntity = this.getBlockState().getBlock()) instanceof LaserBlock) {
            LaserBlock block = (LaserBlock)blockEntity;
            block.setLaser(this.level, pos, direction, player);
        } else if (!enabled) {
            int boundType = LaserFieldBlock.getBoundType(direction);
            BlockUtils.removeInSequence((directionToCheck, stateToCheck) -> stateToCheck.is((Block)SCContent.LASER_FIELD.get()) && (Integer)stateToCheck.getValue((Property)LaserFieldBlock.BOUNDTYPE) == boundType, (LevelAccessor)this.level, this.worldPosition, direction);
        }
    }

    public Map<Direction, Boolean> getSideConfig() {
        return this.sideConfig;
    }

    public boolean isSideEnabled(Direction dir) {
        return !this.isModuleEnabled(ModuleType.SMART) || this.sideConfig.getOrDefault(dir, true) != false;
    }

    private void setLasersAccordingToDisabledOption() {
        if (this.isEnabled()) {
            ((LaserBlock)this.getBlockState().getBlock()).setLaser(this.level, this.worldPosition, null);
        } else {
            LaserBlock.destroyAdjacentLasers((LevelAccessor)this.level, this.worldPosition);
        }
    }

    public ModuleType synchronizeWith(LaserBlockBlockEntity that) {
        if (!LinkableBlockEntity.isLinkedWith(this, that)) {
            Object2BooleanArrayMap bothInsertedModules = new Object2BooleanArrayMap();
            List thisInsertedModules = this.getInsertedModules();
            List thatInsertedModules = that.getInsertedModules();
            for (ModuleType type : thisInsertedModules) {
                ItemStack thisModule = this.getModule(type);
                if (thatInsertedModules.contains((Object)type) && !ItemStack.isSameItemSameComponents((ItemStack)thisModule, (ItemStack)that.getModule(type))) {
                    return type;
                }
                bothInsertedModules.put(thisModule.copy(), this.isModuleEnabled(type));
                this.removeModule(type, false);
            }
            for (ModuleType type : thatInsertedModules) {
                bothInsertedModules.put(that.getModule(type).copy(), that.isModuleEnabled(type));
                that.removeModule(type, false);
                this.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(type, false), that);
            }
            Option<?>[] options = that.customOptions();
            Option<?>[] thisOptions = this.customOptions();
            for (int i = 0; i < options.length; ++i) {
                thisOptions[i].setValue(options[i].get());
            }
            LinkableBlockEntity.link(this, that);
            for (Map.Entry entry : bothInsertedModules.entrySet()) {
                ItemStack module = (ItemStack)entry.getKey();
                ModuleItem item = (ModuleItem)module.getItem();
                ModuleType type = item.getModuleType();
                this.insertModule((ItemStack)entry.getKey(), false);
                this.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(module, item, false), this);
                this.toggleModuleState(type, (Boolean)entry.getValue());
                this.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(module, item, true), this);
            }
        }
        return null;
    }
}

