/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IBlockMine;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.util.SCItemGroup;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class SCCreativeModeTabs {
    public static final Map<SCItemGroup, List<ItemStack>> STACKS_FOR_ITEM_GROUPS = (Map)Util.make(new EnumMap(SCItemGroup.class), map -> Arrays.stream(SCItemGroup.values()).forEach(key -> map.put(key, new ArrayList())));
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"securitycraft");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TECHNICAL_TAB = CREATIVE_MODE_TABS.register("technical", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).icon(() -> new ItemStack((ItemLike)SCContent.USERNAME_LOGGER.get())).title((Component)Component.translatable((String)"itemGroup.securitycraft.technical")).displayItems((itemDisplayParameters, output) -> {
        output.accept(new ItemStack((ItemLike)SCContent.SC_MANUAL.get()));
        output.accept(new ItemStack((ItemLike)SCContent.FRAME.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEY_PANEL.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEYPAD.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEYPAD_CHEST.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEYPAD_BARREL.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEYPAD_FURNACE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEYPAD_SMOKER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEYPAD_BLAST_FURNACE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.DISPLAY_CASE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.GLOW_DISPLAY_CASE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEYCARD_READER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEYCARD_LOCK.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEYCARD_LVL_1.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEYCARD_LVL_2.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEYCARD_LVL_3.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEYCARD_LVL_4.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEYCARD_LVL_5.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEYCARD_HOLDER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.LIMITED_USE_KEYCARD.get()));
        output.accept(new ItemStack((ItemLike)SCContent.CODEBREAKER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.UNIVERSAL_KEY_CHANGER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.RETINAL_SCANNER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.LASER_BLOCK.get()));
        output.accept(new ItemStack((ItemLike)SCContent.INVENTORY_SCANNER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.USERNAME_LOGGER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.PORTABLE_RADAR.get()));
        output.accept(new ItemStack((ItemLike)SCContent.TROPHY_SYSTEM.get()));
        output.accept(new ItemStack((ItemLike)SCContent.RIFT_STABILIZER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.BLOCK_CHANGE_DETECTOR.get()));
        output.accept(new ItemStack((ItemLike)SCContent.PROJECTOR.get()));
        output.accept(new ItemStack((ItemLike)SCContent.PROTECTO.get()));
        output.accept(new ItemStack((ItemLike)SCContent.MOTION_ACTIVATED_LIGHT.get()));
        output.accept(new ItemStack((ItemLike)SCContent.SECURITY_CAMERA.get()));
        output.accept(new ItemStack((ItemLike)SCContent.CAMERA_MONITOR.get()));
        output.accept(new ItemStack((ItemLike)SCContent.ALARM.get()));
        output.accept(new ItemStack((ItemLike)SCContent.PANIC_BUTTON.get()));
        output.accept(new ItemStack((ItemLike)SCContent.SENTRY.get()));
        output.accept(new ItemStack((ItemLike)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get()));
        output.accept(new ItemStack((ItemLike)SCContent.MINE_REMOTE_ACCESS_TOOL.get()));
        output.accept(new ItemStack((ItemLike)SCContent.FLOOR_TRAP.get()));
        output.accept(new ItemStack((ItemLike)SCContent.CAGE_TRAP.get()));
        output.accept(new ItemStack((ItemLike)SCContent.WIRE_CUTTERS.get()));
        output.accept(new ItemStack((ItemLike)SCContent.ELECTRIFIED_IRON_FENCE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.ELECTRIFIED_IRON_FENCE_GATE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.REINFORCED_IRON_TRAPDOOR.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEYPAD_TRAPDOOR.get()));
        output.accept(new ItemStack((ItemLike)SCContent.SCANNER_TRAPDOOR.get()));
        output.accept(new ItemStack((ItemLike)SCContent.REINFORCED_DOOR_ITEM.get()));
        output.accept(new ItemStack((ItemLike)SCContent.KEYPAD_DOOR_ITEM.get()));
        output.accept(new ItemStack((ItemLike)SCContent.SCANNER_DOOR_ITEM.get()));
        output.accept(new ItemStack((ItemLike)SCContent.BLOCK_POCKET_MANAGER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.BLOCK_POCKET_WALL.get()));
        output.accept(new ItemStack((ItemLike)SCContent.SONIC_SECURITY_SYSTEM.get()));
        output.accept(new ItemStack((ItemLike)SCContent.PORTABLE_TUNE_PLAYER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.SECURE_REDSTONE_INTERFACE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.REINFORCED_PISTON.get()));
        output.accept(new ItemStack((ItemLike)SCContent.REINFORCED_STICKY_PISTON.get()));
        output.accept(new ItemStack((ItemLike)SCContent.REINFORCED_DISPENSER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.REINFORCED_DROPPER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.REINFORCED_OBSERVER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.REINFORCED_CAULDRON.get()));
        output.accept(new ItemStack((ItemLike)SCContent.REINFORCED_LADDER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.REINFORCED_HOPPER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.LENS.get()));
        int colorAmount = SecurityCraft.RANDOM.nextInt(1, 4);
        ArrayList<DyeItem> list = new ArrayList<DyeItem>();
        ItemStack coloredLens = ItemStack.EMPTY;
        for (int i = 0; i < colorAmount; ++i) {
            list.add(DyeItem.byColor((DyeColor)DyeColor.byId((int)SecurityCraft.RANDOM.nextInt(16))));
        }
        coloredLens = DyedItemColor.applyDyes((ItemStack)new ItemStack((ItemLike)SCContent.LENS.get()), list);
        if (!coloredLens.isEmpty()) {
            output.accept(coloredLens);
        }
        output.accept(new ItemStack((ItemLike)SCContent.ALLOWLIST_MODULE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.DENYLIST_MODULE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.DISGUISE_MODULE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.REDSTONE_MODULE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.SPEED_MODULE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.SMART_MODULE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.STORAGE_MODULE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.HARMING_MODULE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.UNIVERSAL_BLOCK_MODIFIER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.UNIVERSAL_OWNER_CHANGER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get()));
        output.accept(new ItemStack((ItemLike)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_2.get()));
        output.accept(new ItemStack((ItemLike)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_3.get()));
        output.accept(new ItemStack((ItemLike)SCContent.UNIVERSAL_BLOCK_REMOVER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.TASER.get()));
        output.accept(new ItemStack((ItemLike)SCContent.BRIEFCASE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.FAKE_WATER_BUCKET.get()));
        output.accept(new ItemStack((ItemLike)SCContent.FAKE_LAVA_BUCKET.get()));
        output.accept(new ItemStack((ItemLike)SCContent.ADMIN_TOOL.get()));
        output.accept(new ItemStack((ItemLike)SCContent.OAK_SECURITY_SEA_BOAT.get()));
        output.accept(new ItemStack((ItemLike)SCContent.SPRUCE_SECURITY_SEA_BOAT.get()));
        output.accept(new ItemStack((ItemLike)SCContent.BIRCH_SECURITY_SEA_BOAT.get()));
        output.accept(new ItemStack((ItemLike)SCContent.JUNGLE_SECURITY_SEA_BOAT.get()));
        output.accept(new ItemStack((ItemLike)SCContent.ACACIA_SECURITY_SEA_BOAT.get()));
        output.accept(new ItemStack((ItemLike)SCContent.DARK_OAK_SECURITY_SEA_BOAT.get()));
        output.accept(new ItemStack((ItemLike)SCContent.MANGROVE_SECURITY_SEA_BOAT.get()));
        output.accept(new ItemStack((ItemLike)SCContent.CHERRY_SECURITY_SEA_BOAT.get()));
        output.accept(new ItemStack((ItemLike)SCContent.BAMBOO_SECURITY_SEA_RAFT.get()));
        output.acceptAll((Collection)STACKS_FOR_ITEM_GROUPS.get((Object)SCItemGroup.TECHNICAL));
    }).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MINE_TAB = CREATIVE_MODE_TABS.register("mine", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{TECHNICAL_TAB.getKey()}).icon(() -> new ItemStack((ItemLike)SCContent.MINE.get())).title((Component)Component.translatable((String)"itemGroup.securitycraft.explosives")).displayItems((itemDisplayParameters, output) -> {
        List<Item> vanillaOrderedItems = SCCreativeModeTabs.getVanillaOrderedItems();
        ArrayList<ItemStack> mineGroupItems = new ArrayList<ItemStack>((Collection)STACKS_FOR_ITEM_GROUPS.get((Object)SCItemGroup.EXPLOSIVES));
        mineGroupItems.sort(SCCreativeModeTabs.stackComparator(item -> {
            BlockItem blockItem;
            Block patt0$temp;
            if (item instanceof BlockItem && (patt0$temp = (blockItem = (BlockItem)item).getBlock()) instanceof IBlockMine) {
                IBlockMine blockMine = (IBlockMine)patt0$temp;
                return blockMine;
            }
            return null;
        }, blockMine -> vanillaOrderedItems.indexOf(blockMine.getBlockDisguisedAs().asItem()), false));
        output.accept((ItemLike)SCContent.MINE_REMOTE_ACCESS_TOOL.get());
        output.accept((ItemLike)SCContent.WIRE_CUTTERS.get());
        output.accept((ItemLike)Items.FLINT_AND_STEEL);
        output.accept((ItemLike)SCContent.MINE.get());
        output.acceptAll(mineGroupItems);
        output.accept(new ItemStack((ItemLike)SCContent.ANCIENT_DEBRIS_MINE_ITEM.get()));
        output.accept(new ItemStack((ItemLike)SCContent.FURNACE_MINE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.SMOKER_MINE.get()));
        output.accept(new ItemStack((ItemLike)SCContent.BLAST_FURNACE_MINE.get()));
    }).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> DECORATION_TAB = CREATIVE_MODE_TABS.register("decoration", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{MINE_TAB.getKey()}).icon(() -> new ItemStack((ItemLike)SCContent.REINFORCED_OAK_STAIRS.get())).title((Component)Component.translatable((String)"itemGroup.securitycraft.decoration")).displayItems((itemDisplayParameters, output) -> {
        List<Item> vanillaOrderedItems = SCCreativeModeTabs.getVanillaOrderedItems();
        ArrayList<ItemStack> decorationGroupItems = new ArrayList<ItemStack>((Collection)STACKS_FOR_ITEM_GROUPS.get((Object)SCItemGroup.DECORATION));
        decorationGroupItems.sort(SCCreativeModeTabs.stackComparator(item -> {
            BlockItem blockItem;
            Block patt0$temp;
            if (item instanceof BlockItem && (patt0$temp = (blockItem = (BlockItem)item).getBlock()) instanceof IReinforcedBlock) {
                IReinforcedBlock reinforcedBlock = (IReinforcedBlock)patt0$temp;
                return reinforcedBlock;
            }
            return null;
        }, reinforcedBlock -> vanillaOrderedItems.indexOf(reinforcedBlock.getVanillaBlock().asItem()), true));
        output.accept((ItemLike)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get());
        output.accept((ItemLike)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_2.get());
        output.accept((ItemLike)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_3.get());
        output.accept((ItemLike)SCContent.UNIVERSAL_BLOCK_REMOVER.get());
        output.acceptAll(decorationGroupItems);
        output.accept((ItemLike)SCContent.CRYSTAL_QUARTZ_BLOCK.get());
        output.accept((ItemLike)SCContent.CRYSTAL_QUARTZ_STAIRS.get());
        output.accept((ItemLike)SCContent.CRYSTAL_QUARTZ_SLAB.get());
        output.accept((ItemLike)SCContent.CHISELED_CRYSTAL_QUARTZ.get());
        output.accept((ItemLike)SCContent.CRYSTAL_QUARTZ_BRICKS.get());
        output.accept((ItemLike)SCContent.CRYSTAL_QUARTZ_PILLAR.get());
        output.accept((ItemLike)SCContent.SMOOTH_CRYSTAL_QUARTZ.get());
        output.accept((ItemLike)SCContent.SMOOTH_CRYSTAL_QUARTZ_STAIRS.get());
        output.accept((ItemLike)SCContent.SMOOTH_CRYSTAL_QUARTZ_SLAB.get());
        output.accept((ItemLike)SCContent.REINFORCED_CRYSTAL_QUARTZ_BLOCK.get());
        output.accept((ItemLike)SCContent.REINFORCED_CRYSTAL_QUARTZ_STAIRS.get());
        output.accept((ItemLike)SCContent.REINFORCED_CRYSTAL_QUARTZ_SLAB.get());
        output.accept((ItemLike)SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get());
        output.accept((ItemLike)SCContent.REINFORCED_CRYSTAL_QUARTZ_BRICKS.get());
        output.accept((ItemLike)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get());
        output.accept((ItemLike)SCContent.REINFORCED_SMOOTH_CRYSTAL_QUARTZ.get());
        output.accept((ItemLike)SCContent.REINFORCED_SMOOTH_CRYSTAL_QUARTZ_STAIRS.get());
        output.accept((ItemLike)SCContent.REINFORCED_SMOOTH_CRYSTAL_QUARTZ_SLAB.get());
        output.accept((ItemLike)SCContent.BLOCK_POCKET_WALL.get());
        output.accept((ItemLike)SCContent.ELECTRIFIED_IRON_FENCE.get());
        output.accept((ItemLike)SCContent.ELECTRIFIED_IRON_FENCE_GATE.get());
        output.accept((ItemLike)SCContent.REINFORCED_IRON_TRAPDOOR.get());
        output.accept((ItemLike)SCContent.KEYPAD_TRAPDOOR.get());
        output.accept((ItemLike)SCContent.SCANNER_TRAPDOOR.get());
        output.accept((ItemLike)SCContent.REINFORCED_DOOR_ITEM.get());
        output.accept((ItemLike)SCContent.KEYPAD_DOOR_ITEM.get());
        output.accept((ItemLike)SCContent.SCANNER_DOOR_ITEM.get());
        output.accept((ItemLike)SCContent.DISPLAY_CASE.get());
        output.accept((ItemLike)SCContent.GLOW_DISPLAY_CASE.get());
    }).build());

    private static <T> Comparator<ItemStack> stackComparator(Function<Item, T> blockInstanceGetter, ToIntFunction<T> indexGetter, boolean sortNonVanillaLast) {
        return (a, b) -> {
            int indexB;
            boolean blockBExists;
            Object blockA = blockInstanceGetter.apply(a.getItem());
            Object blockB = blockInstanceGetter.apply(b.getItem());
            boolean blockAExists = blockA != null;
            boolean bl = blockBExists = blockB != null;
            if (!blockAExists && !blockBExists) {
                return 0;
            }
            if (blockAExists ^ blockBExists) {
                return blockAExists == sortNonVanillaLast ? -1 : 1;
            }
            if (blockA == blockB) {
                return 0;
            }
            int indexA = indexGetter.applyAsInt(blockA);
            boolean indexAExists = indexA != -1;
            if (indexAExists ^ (indexB = indexGetter.applyAsInt(blockB)) != -1) {
                return indexAExists ? -1 : 1;
            }
            return Integer.compare(indexA, indexB);
        };
    }

    private static List<Item> getVanillaOrderedItems() {
        ArrayList<Item> vanillaOrderedItems = new ArrayList<Item>(SCCreativeModeTabs.getCreativeTabItems((ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS));
        vanillaOrderedItems.addAll(SCCreativeModeTabs.getCreativeTabItems((ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS));
        vanillaOrderedItems.addAll(SCCreativeModeTabs.getCreativeTabItems((ResourceKey<CreativeModeTab>)CreativeModeTabs.NATURAL_BLOCKS));
        vanillaOrderedItems.addAll(SCCreativeModeTabs.getCreativeTabItems((ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS));
        vanillaOrderedItems.addAll(SCCreativeModeTabs.getCreativeTabItems((ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS));
        return vanillaOrderedItems;
    }

    private static List<Item> getCreativeTabItems(ResourceKey<CreativeModeTab> tabKey) {
        return ((CreativeModeTab)((Holder.Reference)BuiltInRegistries.CREATIVE_MODE_TAB.get(tabKey).get()).value()).getDisplayItems().stream().map(ItemStack::getItem).toList();
    }

    private SCCreativeModeTabs() {
    }
}

