/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.supermartijn642.additionallanterns.LanternBlock;
import com.supermartijn642.additionallanterns.LanternMaterial;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class VanillaLanternEvents {
    public static void registerEventHandlers() {
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, false, VanillaLanternEvents::handleInteractWithLantern);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, false, VanillaLanternEvents::handleLanternPlacement);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, false, VanillaLanternEvents::handleLanternRedstone);
    }

    private static void handleInteractWithLantern(PlayerInteractEvent.RightClickBlock e) {
        BlockPos clickedPos;
        Level level = e.getLevel();
        BlockState oldState = level.getBlockState(clickedPos = e.getPos());
        if (oldState.getBlock() == Blocks.LANTERN) {
            if (!level.isClientSide) {
                BlockState newState = (BlockState)((BlockState)((BlockState)((BlockState)LanternMaterial.NORMAL.getLanternBlock().defaultBlockState().setValue((Property)LanternBlock.ON, (Comparable)Boolean.valueOf(false))).setValue((Property)LanternBlock.REDSTONE, (Comparable)Boolean.valueOf(level.hasNeighborSignal(clickedPos)))).setValue((Property)LanternBlock.HANGING, (Comparable)((Boolean)oldState.getValue((Property)BlockStateProperties.HANGING)))).setValue((Property)LanternBlock.WATERLOGGED, (Comparable)((Boolean)oldState.getValue((Property)BlockStateProperties.WATERLOGGED)));
                level.setBlock(clickedPos, newState, 3);
            }
            e.setCanceled(true);
            e.setCancellationResult((InteractionResult)(level.isClientSide ? InteractionResult.SUCCESS : InteractionResult.CONSUME));
        }
    }

    private static void handleLanternPlacement(BlockEvent.EntityPlaceEvent e) {
        LevelAccessor level = e.getLevel();
        if (!level.isClientSide()) {
            BlockState newState;
            BlockState oldState = e.getPlacedBlock();
            if (oldState.getBlock() == LanternMaterial.NORMAL.getLanternBlock() && ((Boolean)oldState.getValue((Property)LanternBlock.ON)).booleanValue() && !((Boolean)oldState.getValue((Property)LanternBlock.REDSTONE)).booleanValue()) {
                newState = (BlockState)((BlockState)Blocks.LANTERN.defaultBlockState().setValue((Property)BlockStateProperties.HANGING, (Comparable)((Boolean)oldState.getValue((Property)LanternBlock.HANGING)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)oldState.getValue((Property)LanternBlock.WATERLOGGED)));
                level.setBlock(e.getPos(), newState, 3);
            }
            if (oldState.getBlock() == Blocks.LANTERN && e.getLevel().hasNeighborSignal(e.getPos())) {
                newState = (BlockState)((BlockState)((BlockState)LanternMaterial.NORMAL.getLanternBlock().defaultBlockState().setValue((Property)BlockStateProperties.HANGING, (Comparable)((Boolean)oldState.getValue((Property)LanternBlock.HANGING)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)oldState.getValue((Property)LanternBlock.WATERLOGGED)))).setValue((Property)LanternBlock.REDSTONE, (Comparable)Boolean.valueOf(true));
                level.setBlock(e.getPos(), newState, 3);
            }
        }
    }

    private static void handleLanternRedstone(BlockEvent.NeighborNotifyEvent e) {
        LevelAccessor level = e.getLevel();
        BlockPos originatingPos = e.getPos();
        for (Direction direction : e.getNotifiedSides()) {
            BlockPos pos = originatingPos.relative(direction);
            BlockState oldState = level.getBlockState(pos);
            if (oldState.getBlock() != Blocks.LANTERN || !(level instanceof Level) || !((Level)level).hasNeighborSignal(pos)) continue;
            BlockState newState = (BlockState)((BlockState)((BlockState)LanternMaterial.NORMAL.getLanternBlock().defaultBlockState().setValue((Property)LanternBlock.REDSTONE, (Comparable)Boolean.valueOf(true))).setValue((Property)LanternBlock.HANGING, (Comparable)((Boolean)oldState.getValue((Property)BlockStateProperties.HANGING)))).setValue((Property)LanternBlock.WATERLOGGED, (Comparable)((Boolean)oldState.getValue((Property)BlockStateProperties.WATERLOGGED)));
            level.setBlock(pos, newState, 3);
        }
    }
}

