/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common.item;

import com.autovw.advancednetherite.api.annotation.Internal;
import com.autovw.advancednetherite.api.impl.IToolMaterial;
import com.autovw.advancednetherite.common.AdvancedUtil;
import com.autovw.advancednetherite.config.ConfigHelper;
import com.autovw.advancednetherite.core.util.ModTags;
import com.autovw.advancednetherite.core.util.ModTooltips;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.block.state.BlockState;

public class AdvancedHoeItem
extends HoeItem
implements IToolMaterial {
    private final ToolMaterial material;

    public AdvancedHoeItem(ToolMaterial material, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties.fireResistant());
        this.material = material;
    }

    public void addTooltips(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltips, TooltipFlag flag) {
    }

    public ChatFormatting customDurabilityBarColor(ItemStack stack) {
        return null;
    }

    @Internal
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag flag) {
        if (ConfigHelper.get().getClient().showTooltips()) {
            if (stack.is(ModTags.DROPS_ADDITIONAL_CROPS) && ConfigHelper.get().getCommon().getAdditionalDrops().enableAdditionalCropDrops()) {
                if (Screen.hasShiftDown()) {
                    tooltip.accept((Component)ModTooltips.ADDITIONAL_CROP_DROPS_TOOLTIP);
                } else {
                    tooltip.accept((Component)ModTooltips.SHIFT_KEY_TOOLTIP);
                }
            }
            this.addTooltips(stack, context, display, tooltip, flag);
        }
    }

    @Internal
    public int getBarColor(ItemStack stack) {
        int originalColor = super.getBarColor(stack);
        if (this.customDurabilityBarColor(stack) != null && ConfigHelper.get().getClient().matchingDurabilityBars()) {
            return Objects.requireNonNull(this.customDurabilityBarColor(stack).getColor());
        }
        return AdvancedUtil.getDurabilityBarColor(originalColor, stack);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        float originalSpeed = super.getDestroySpeed(stack, state);
        return AdvancedUtil.getDestroySpeed(originalSpeed, stack, state);
    }

    @Override
    public ToolMaterial getMaterial() {
        return this.material;
    }

    @Override
    public IToolMaterial.Type getToolType() {
        return IToolMaterial.Type.HOE;
    }
}

