/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common.item;

import com.autovw.advancednetherite.api.annotation.Internal;
import com.autovw.advancednetherite.api.impl.IArmorMaterial;
import com.autovw.advancednetherite.common.AdvancedUtil;
import com.autovw.advancednetherite.config.ConfigHelper;
import com.autovw.advancednetherite.core.util.ModTags;
import com.autovw.advancednetherite.core.util.ModTooltips;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;

public class AdvancedArmorItem
extends Item
implements IArmorMaterial {
    private final ArmorMaterial material;

    private static Item.Properties armorProperties(ArmorMaterial material, ArmorType armorType, Item.Properties properties) {
        return properties.durability(armorType.getDurability(AdvancedUtil.getArmorDurabilityMultiplier(material))).attributes(material.createAttributes(armorType)).enchantable(material.enchantmentValue()).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)armorType.getSlot()).setEquipSound(material.equipSound()).setAsset(material.assetId()).build()).repairable(material.repairIngredient());
    }

    public AdvancedArmorItem(ArmorMaterial material, ArmorType armorType, Item.Properties properties) {
        super(AdvancedArmorItem.armorProperties(material, armorType, properties).fireResistant());
        this.material = material;
    }

    public boolean pacifiesEndermen(ItemStack stack) {
        return stack.is(ModTags.PACIFY_ENDERMEN_ARMOR);
    }

    public boolean pacifiesPiglins(ItemStack stack) {
        return stack.is(ModTags.PACIFY_PIGLINS_ARMOR);
    }

    public boolean pacifiesPhantoms(ItemStack stack) {
        return stack.is(ModTags.PACIFY_PHANTOMS_ARMOR);
    }

    public void addTooltips(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltips, TooltipFlag flag) {
    }

    public ChatFormatting customDurabilityBarColor(ItemStack stack) {
        return null;
    }

    @Internal
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag flag) {
        if (ConfigHelper.get().getClient().showTooltips()) {
            if (Screen.hasShiftDown()) {
                if (this.pacifiesEndermen(stack)) {
                    tooltip.accept((Component)ModTooltips.ENDERMAN_PASSIVE_TOOLTIP);
                }
                if (this.pacifiesPiglins(stack)) {
                    tooltip.accept((Component)ModTooltips.PIGLIN_PASSIVE_TOOLTIP);
                }
                if (this.pacifiesPhantoms(stack)) {
                    tooltip.accept((Component)ModTooltips.PHANTOM_PASSIVE_TOOLTIP);
                }
            } else if (this.pacifiesEndermen(stack) || this.pacifiesPiglins(stack) || this.pacifiesPhantoms(stack)) {
                tooltip.accept((Component)ModTooltips.SHIFT_KEY_TOOLTIP);
            }
            this.addTooltips(stack, context, display, tooltip, flag);
        }
    }

    @Internal
    public int getBarColor(ItemStack stack) {
        int originalColor = super.getBarColor(stack);
        if (this.customDurabilityBarColor(stack) != null && ConfigHelper.get().getClient().matchingDurabilityBars()) {
            return Objects.requireNonNull(this.customDurabilityBarColor(stack).getColor());
        }
        return AdvancedUtil.getDurabilityBarColor(originalColor, stack);
    }

    @Override
    public ArmorMaterial getMaterial() {
        return this.material;
    }
}

