/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import java.util.Set;
import journeymap.api.services.Services;
import journeymap.client.Constants;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.network.model.Location;
import journeymap.common.properties.DimensionProperties;
import journeymap.common.properties.PropertiesManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;

public class JourneyMapTeleport {
    private static final JourneyMapTeleport INSTANCE = new JourneyMapTeleport();

    private JourneyMapTeleport() {
    }

    public static JourneyMapTeleport instance() {
        return INSTANCE;
    }

    public boolean attemptTeleport(Entity entity, Location location) {
        MinecraftServer mcServer = Services.COMMON_SERVICE.getServer();
        boolean creative = false;
        boolean cheatMode = false;
        if (entity == null) {
            Journeymap.getLogger().error("Attempted to teleport null entity.");
            return false;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            creative = serverPlayer.getAbilities().instabuild;
            boolean bl = cheatMode = mcServer.getPlayerList().isOp(serverPlayer.getGameProfile()) && Services.COMMON_SERVICE.isClient();
            if (mcServer == null) {
                serverPlayer.sendSystemMessage((Component)Constants.getStringTextComponent("Cannot Find World"));
                return false;
            }
            if (this.isTeleportAvailable((Entity)serverPlayer, location) || creative || cheatMode || Services.COMMON_SERVICE.isOp((Player)serverPlayer) && (mcServer.getProfilePermissions(serverPlayer.getGameProfile()) >= 2 || CommonConstants.debugOverride((Entity)serverPlayer))) {
                if (!serverPlayer.isAlive()) {
                    serverPlayer.sendSystemMessage((Component)Constants.getStringTextComponent("Cannot teleport when dead."));
                    return false;
                }
                ServerLevel destinationWorld = mcServer.getLevel(DimensionHelper.getWorldKeyForName(location.getDim()));
                if (destinationWorld == null) {
                    for (ServerLevel world : mcServer.getAllLevels()) {
                        if (!location.getDim().equalsIgnoreCase(DimensionHelper.getDimName((Level)world)) && !location.getDim().equalsIgnoreCase(DimensionHelper.getDimKeyName((ResourceKey<Level>)world.dimension()))) continue;
                        destinationWorld = world;
                        break;
                    }
                }
                if (destinationWorld == null) {
                    serverPlayer.sendSystemMessage((Component)Constants.getStringTextComponent("Could not get world for Dimension " + location.getDim()));
                    return false;
                }
                return this.teleportEntity(destinationWorld, entity, location);
            }
            serverPlayer.sendSystemMessage((Component)Constants.getStringTextComponent("Server has disabled JourneyMap teleport usage for your current or destination dimension."));
            return false;
        }
        return false;
    }

    private boolean isTeleportAvailable(Entity entity, Location location) {
        DimensionProperties destinationProperty = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getWorldKeyForName(location.getDim()));
        DimensionProperties entityLocationProperty = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getDimension(entity));
        return this.canDimTeleport(destinationProperty) && this.canDimTeleport(entityLocationProperty);
    }

    private boolean canDimTeleport(DimensionProperties properties) {
        if (properties.enabled.get().booleanValue()) {
            return properties.teleportEnabled.get();
        }
        return PropertiesManager.getInstance().getGlobalProperties().teleportEnabled.get();
    }

    private boolean teleportEntity(ServerLevel destinationWorld, Entity player, Location location) {
        boolean changedWorld;
        ServerLevel startWorld = (ServerLevel)player.level();
        boolean bl = changedWorld = startWorld != destinationWorld;
        if (player instanceof ServerPlayer) {
            boolean crossDimTpAllow;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            boolean bl2 = crossDimTpAllow = PropertiesManager.getInstance().getGlobalProperties().crossDimTeleport.get() != false || Services.COMMON_SERVICE.isOp((Player)((ServerPlayer)player));
            if (changedWorld) {
                if (crossDimTpAllow) {
                    TeleportTransition transition = new TeleportTransition(destinationWorld, new Vec3(location.getX() + 0.5, location.getY() + 0.5, location.getZ() + 0.5), Vec3.ZERO, 0.0f, 0.0f, Set.of(), TeleportTransition.DO_NOTHING);
                    serverPlayer.teleport(transition);
                } else {
                    serverPlayer.sendSystemMessage((Component)Constants.getStringTextComponent("Server disabled cross dimension teleport."));
                }
            } else {
                TeleportTransition transition = new TeleportTransition(serverPlayer.level(), new Vec3(location.getX(), location.getY(), location.getZ()), Vec3.ZERO, 0.0f, 0.0f, Set.of(), TeleportTransition.DO_NOTHING);
                serverPlayer.teleport(transition);
            }
            if (!CommonConstants.debugOverride((Entity)serverPlayer)) {
                Journeymap.getLogger().info("{} teleported to {} {} {} {}", (Object)serverPlayer.getName().getString(), (Object)location.getX(), (Object)location.getY(), (Object)location.getZ(), (Object)location.getDim());
            }
        }
        return false;
    }
}

