/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt.cache;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import journeymap.common.nbt.cache.CacheFileStorage;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.PriorityConsecutiveExecutor;
import net.minecraft.util.thread.StrictQueue;
import net.minecraft.world.level.ChunkPos;

public class CacheWorker
implements AutoCloseable {
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private final PriorityConsecutiveExecutor consecutiveExecutor;
    private final CacheFileStorage storage;
    private final Map<ChunkPos, PendingStore> pendingWrites = Maps.newLinkedHashMap();

    protected CacheWorker(Path path, boolean async) {
        this.storage = new CacheFileStorage(path, async);
        this.consecutiveExecutor = new PriorityConsecutiveExecutor(Priority.values().length, (Executor)Util.ioPool(), "JM-Cache");
    }

    public CompletableFuture<Void> store(ChunkPos chunkPos, @Nullable CompoundTag chunkData) {
        return this.store(chunkPos, () -> chunkData);
    }

    @Nullable
    public CompletableFuture<Void> store(ChunkPos p_360728_, Supplier<CompoundTag> p_361805_) {
        return this.submitTask(() -> {
            CompoundTag compoundtag = (CompoundTag)p_361805_.get();
            PendingStore ioworker$pendingstore = this.pendingWrites.computeIfAbsent(p_360728_, p_223488_ -> new PendingStore(compoundtag));
            ioworker$pendingstore.data = compoundtag;
            return ioworker$pendingstore.result;
        }).thenCompose(Function.identity());
    }

    @Nullable
    public CompoundTag load(ChunkPos chunkPos) throws IOException {
        CompletableFuture<Optional<CompoundTag>> future = this.loadAsync(chunkPos);
        try {
            return future.join().orElse(null);
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public CompletableFuture<Optional<CompoundTag>> loadAsync(ChunkPos chunkPos) {
        return this.submitThrowingTask(() -> {
            PendingStore ioworker$pendingstore = this.pendingWrites.get(chunkPos);
            if (ioworker$pendingstore != null) {
                return Optional.ofNullable(ioworker$pendingstore.copyData());
            }
            CompoundTag compoundtag = this.storage.read(chunkPos);
            return Optional.ofNullable(compoundtag);
        });
    }

    public CompletableFuture<Void> synchronize(boolean flushStorage) {
        CompletionStage completablefuture = this.submitTask(() -> CompletableFuture.allOf((CompletableFuture[])this.pendingWrites.values().stream().map(p_223475_ -> p_223475_.result).toArray(CompletableFuture[]::new))).thenCompose(Function.identity());
        return flushStorage ? ((CompletableFuture)completablefuture).thenCompose(p_371174_ -> this.submitThrowingTask(() -> {
            this.storage.flush();
            return null;
        })) : ((CompletableFuture)completablefuture).thenCompose(p_223477_ -> this.submitTask(() -> null));
    }

    private <T> CompletableFuture<T> submitThrowingTask(ThrowingSupplier<T> p_371938_) {
        return this.consecutiveExecutor.scheduleWithResult(Priority.FOREGROUND.ordinal(), p_371168_ -> {
            if (!this.shutdownRequested.get()) {
                try {
                    p_371168_.complete(p_371938_.get());
                }
                catch (Exception exception) {
                    p_371168_.completeExceptionally(exception);
                }
            }
            this.tellStorePending();
        });
    }

    private <T> CompletableFuture<T> submitTask(Supplier<T> task) {
        return this.consecutiveExecutor.scheduleWithResult(Priority.FOREGROUND.ordinal(), p_371173_ -> {
            if (!this.shutdownRequested.get()) {
                p_371173_.complete(task.get());
            }
            this.tellStorePending();
        });
    }

    private void storePendingChunk() {
        if (!this.pendingWrites.isEmpty()) {
            Iterator<Map.Entry<ChunkPos, PendingStore>> iterator = this.pendingWrites.entrySet().iterator();
            Map.Entry<ChunkPos, PendingStore> entry = iterator.next();
            iterator.remove();
            this.runStore(entry.getKey(), entry.getValue());
            this.tellStorePending();
        }
    }

    private void tellStorePending() {
        this.consecutiveExecutor.schedule((Runnable)new StrictQueue.RunnableWithPriority(Priority.BACKGROUND.ordinal(), this::storePendingChunk));
    }

    private void runStore(ChunkPos pos, PendingStore store) {
        try {
            this.storage.write(pos, store.data);
            store.result.complete(null);
        }
        catch (Exception e) {
            store.result.completeExceptionally(e);
        }
    }

    public boolean hasChunk(ChunkPos pos) {
        return this.storage.hasChunk(pos);
    }

    @Override
    public void close() throws IOException {
        if (this.shutdownRequested.compareAndSet(false, true)) {
            this.waitForShutdown();
            this.consecutiveExecutor.close();
            try {
                this.storage.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void waitForShutdown() {
        this.consecutiveExecutor.scheduleWithResult(Priority.SHUTDOWN.ordinal(), p_371169_ -> p_371169_.complete(Unit.INSTANCE)).join();
    }

    static enum Priority {
        FOREGROUND,
        BACKGROUND,
        SHUTDOWN;

    }

    @FunctionalInterface
    static interface ThrowingSupplier<T> {
        @Nullable
        public T get() throws Exception;
    }

    static class PendingStore {
        @Nullable
        CompoundTag data;
        final CompletableFuture<Void> result = new CompletableFuture();

        public PendingStore(@Nullable CompoundTag data) {
            this.data = data;
        }

        @Nullable
        CompoundTag copyData() {
            CompoundTag compoundtag = this.data;
            return compoundtag == null ? null : compoundtag.copy();
        }
    }
}

