/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.popupscreenbutton.colorpicker;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.function.Function;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.properties.CoreProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.TextBox;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.IntSliderButton;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.IntegerField;
import journeymap.common.properties.config.StringField;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class ColorPickerScreen
extends PopupButtonScreen<ColorPickerResponse> {
    private static final int SLIDERS_WIDTH = 265;
    private static final int[] PALETTE_COLORS = new int[]{-121070, -175352, -288510, -345086, -65997, -3085781, -10047438, -16543026, -16627714, -12779100, -7994961, -5826229, -1, -8355712, -16777216};
    private LinearLayout historyLayout;
    private LinearLayout paletteLayout;
    private final ResourceLocation colorwheelTexture;
    private final ResourceLocation colorwheelHandlerTexture;
    private final ResourceLocation colorBoxTexture;
    private final ResourceLocation colorVSliderTexture;
    private final ResourceLocation colorVSliderHandlerTexture;
    private final ResourceLocation colorHistoryButtonTexture;
    private final String labelOld = Constants.getString("jm.color.old");
    private final String labelNew = Constants.getString("jm.color.new");
    private final Component labelHistory = Component.translatable((String)"jm.color.history");
    private final Component labelPalette = Component.translatable((String)"jm.color.palette");
    private final Component labelHex = Component.translatable((String)"jm.color.hex");
    private final Component labelDec = Component.translatable((String)"jm.color.dec");
    private final String prefixR = Constants.getString("jm.color.red_abbreviated");
    private final String prefixG = Constants.getString("jm.color.green_abbreviated");
    private final String prefixB = Constants.getString("jm.color.blue_abbreviated");
    private final String prefixH = Constants.getString("jm.color.hue_abbreviated");
    private final String prefixS = Constants.getString("jm.color.saturation_abbreviated");
    private final String prefixV = Constants.getString("jm.color.value_abbreviated");
    private final String prefixA = Constants.getString("jm.color.alpha_abbreviated");
    private final Component labelSubmit = Component.translatable((String)"jm.common.submit");
    private final Component labelReset = Component.translatable((String)"jm.common.reset");
    private final Component labelCancel = Component.translatable((String)"jm.common.cancel");
    private final String formatHexNoAlpha = "%06X";
    private final String formatHexAlpha = "%08X";
    private final int maxHistory = 15;
    private TextBox fieldHex;
    private TextBox fieldDec;
    private final IntegerField fieldH = new IntegerField(Category.Hidden, "", 0, 255, 0);
    private final IntegerField fieldS = new IntegerField(Category.Hidden, "", 0, 255, 0);
    private final IntegerField fieldV = new IntegerField(Category.Hidden, "", 0, 255, 0);
    private final IntegerField fieldR = new IntegerField(Category.Hidden, "", 0, 255, 0);
    private final IntegerField fieldG = new IntegerField(Category.Hidden, "", 0, 255, 0);
    private final IntegerField fieldB = new IntegerField(Category.Hidden, "", 0, 255, 0);
    private final IntegerField fieldA = new IntegerField(Category.Hidden, "", 0, 255, 0);
    private IntSliderButton sliderH;
    private IntSliderButton sliderS;
    private IntSliderButton sliderV;
    private IntSliderButton sliderR;
    private IntSliderButton sliderG;
    private IntSliderButton sliderB;
    private IntSliderButton sliderA;
    private double colorwheelHandlerX = 0.0;
    private double colorwheelHandlerY = 0.0;
    private boolean draggingCWHandler = false;
    private final Rectangle2D.Double colorWheelRect;
    private double vSliderHandler = 0.0;
    private boolean draggingVSHandler = false;
    private final Rectangle2D.Double vSliderRect;
    private double aSliderHandler = 0.0;
    private boolean draggingASHandler = false;
    private final Rectangle2D.Double aSliderRect;
    private final int originalColor;
    private int currentColor;
    private int currentColorFullBrightness;
    private boolean withAlpha;

    protected ColorPickerScreen(Component title, Integer color, boolean withAlpha) {
        super(title);
        this.response = new ColorPickerResponse(0, true);
        this.colorwheelTexture = TextureCache.ColorWheel;
        this.colorwheelHandlerTexture = TextureCache.ColorWheelHandler;
        this.colorBoxTexture = TextureCache.ColorBox;
        this.colorVSliderTexture = TextureCache.ColorVSlider;
        this.colorVSliderHandlerTexture = TextureCache.ColorVSliderHandler;
        this.colorHistoryButtonTexture = TextureCache.ColorHistoryButton;
        this.colorWheelRect = new Rectangle2D.Double();
        this.vSliderRect = new Rectangle2D.Double();
        this.aSliderRect = new Rectangle2D.Double();
        this.originalColor = color;
        this.currentColor = color;
        this.withAlpha = withAlpha;
    }

    public void init() {
        this.layout.spacing(4).defaultCellSetting().alignHorizontallyLeft();
        this.layout.addChild((LayoutElement)new SpacerElement(265, 39));
        this.fieldHex = new TextBox("", this.font, 76, 20, false, false);
        this.fieldHex.setMaxLength(this.withAlpha ? 8 : 6);
        this.fieldDec = new TextBox("", this.font, 76, 20, true, true);
        this.fieldDec.setMaxLength(this.withAlpha ? 11 : 9);
        ColorPickerScreen.addTextBoxWithLabel(this.layout, this.font, this.labelHex, this.fieldHex);
        ColorPickerScreen.addTextBoxWithLabel(this.layout, this.font, this.labelDec, this.fieldDec);
        this.sliderH = this.createCenteredSlider(this.fieldH, this.prefixH, this::listenerHSV);
        this.sliderS = this.createCenteredSlider(this.fieldS, this.prefixS, this::listenerHSV);
        this.sliderV = this.createCenteredSlider(this.fieldV, this.prefixV, this::listenerHSV);
        this.sliderR = this.createCenteredSlider(this.fieldR, this.prefixR, this::listenerRGB);
        this.sliderG = this.createCenteredSlider(this.fieldG, this.prefixG, this::listenerRGB);
        this.sliderB = this.createCenteredSlider(this.fieldB, this.prefixB, this::listenerRGB);
        ColorPickerScreen.addSliderGroup(this.layout, this.sliderH, this.sliderS, this.sliderV);
        ColorPickerScreen.addSliderGroup(this.layout, this.sliderR, this.sliderG, this.sliderB);
        this.sliderA = this.createCenteredSlider(this.fieldA, this.prefixA, this::listenerAlpha);
        this.sliderA.visible = this.withAlpha;
        this.layout.addChild((LayoutElement)this.sliderA);
        FrameLayout bottomButtomsFrame = new FrameLayout();
        bottomButtomsFrame.setMinWidth(265);
        LinearLayout bottomButtons = LinearLayout.horizontal();
        bottomButtons.spacing(12);
        bottomButtons.addChild((LayoutElement)Button.builder((Component)this.labelSubmit, b -> this.submit()).width(this.font.width((FormattedText)this.labelSubmit) + 10).build());
        bottomButtons.addChild((LayoutElement)Button.builder((Component)this.labelReset, b -> this.reset()).width(this.font.width((FormattedText)this.labelReset) + 10).build());
        bottomButtons.addChild((LayoutElement)Button.builder((Component)this.labelCancel, b -> this.setResponseAndClose(new ColorPickerResponse(0, true))).width(this.font.width((FormattedText)this.labelCancel) + 10).build());
        bottomButtomsFrame.addChild((LayoutElement)bottomButtons);
        this.layout.addChild((LayoutElement)bottomButtomsFrame);
        CoreProperties properties = JourneymapClient.getInstance().getCoreProperties();
        List<StringField> history = properties.colorPickerHistory;
        if (!history.isEmpty()) {
            if (history.size() > 15) {
                history.subList(15, history.size()).clear();
            }
            this.historyLayout = LinearLayout.vertical();
            this.historyLayout.defaultCellSetting().alignHorizontallyCenter();
            this.historyLayout.addChild((LayoutElement)new StringWidget(this.labelHistory, this.font).setColor(Color.cyan.getRGB()));
            this.historyLayout.addChild((LayoutElement)SpacerElement.height((int)2));
            Object object = history.iterator();
            while (object.hasNext()) {
                StringField stringField = (StringField)object.next();
                this.historyLayout.addChild((LayoutElement)new HistoryButton(this.colorHistoryButtonTexture, RGB.hexToInt(stringField.get()), b -> this.historySelected((HistoryButton)b)));
            }
            this.historyLayout.visitWidgets(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
            });
        }
        this.paletteLayout = LinearLayout.vertical();
        this.paletteLayout.defaultCellSetting().alignHorizontallyCenter();
        this.paletteLayout.addChild((LayoutElement)new StringWidget(this.labelPalette, this.font).setColor(Color.cyan.getRGB()));
        this.paletteLayout.addChild((LayoutElement)SpacerElement.height((int)2));
        for (int color : PALETTE_COLORS) {
            this.paletteLayout.addChild((LayoutElement)new HistoryButton(this.colorHistoryButtonTexture, color, b -> this.historySelected((HistoryButton)b)));
        }
        this.paletteLayout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
        this.updateHSVfields();
        this.updateFullBrightness();
        this.updateRGBfields();
        this.updateHexField();
        this.updateDecField();
        this.updateColorWheelHandler();
        this.updateAlphaField();
        this.updateVSliderHandler();
        this.updateASliderHandler();
    }

    @Override
    public void renderPopupScreenBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(graphics);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, BACKGROUND_SPRITE, this.layout.getX() - 10, this.layout.getY() - 10, this.layout.getWidth() + 20, this.layout.getHeight() + 20);
        if (this.historyLayout != null) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, BACKGROUND_SPRITE, this.historyLayout.getX() - 10, this.historyLayout.getY() - 10, this.historyLayout.getWidth() + 20, this.historyLayout.getHeight() + 20);
        }
        if (this.paletteLayout != null) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, BACKGROUND_SPRITE, this.paletteLayout.getX() - 10, this.paletteLayout.getY() - 10, this.paletteLayout.getWidth() + 20, this.paletteLayout.getHeight() + 20);
        }
    }

    @Override
    protected void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
        if (this.historyLayout != null) {
            this.historyLayout.arrangeElements();
            this.historyLayout.setPosition(this.layout.getX() + this.layout.getWidth() + 24, this.layout.getY());
        }
        if (this.paletteLayout != null) {
            this.paletteLayout.arrangeElements();
            this.paletteLayout.setPosition(this.layout.getX() - 68, this.layout.getY());
        }
    }

    private static void addTextBoxWithLabel(LinearLayout layout, Font font, Component label, TextBox textBox) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.newCellSettings().alignVerticallyMiddle();
        gridLayout.spacing(4);
        gridLayout.addChild((LayoutElement)new StringWidget(label, font).alignLeft().setColor(Color.cyan.getRGB()), 0, 0, LayoutSettings.defaults().alignVerticallyMiddle());
        gridLayout.addChild((LayoutElement)textBox, 0, 1);
        layout.addChild((LayoutElement)gridLayout);
    }

    private static void addSliderGroup(LinearLayout layout, IntSliderButton slider1, IntSliderButton slider2, IntSliderButton slider3) {
        LinearLayout linearLayout = LinearLayout.vertical();
        linearLayout.addChild((LayoutElement)slider1);
        linearLayout.addChild((LayoutElement)slider2);
        linearLayout.addChild((LayoutElement)slider3);
        layout.addChild((LayoutElement)linearLayout);
    }

    private void submit() {
        StringField field = new StringField(Category.Hidden, "");
        field.set(RGB.toHexStringRGBA(this.currentColor));
        CoreProperties properties = JourneymapClient.getInstance().getCoreProperties();
        properties.colorPickerHistory.removeIf(f -> f.get().equals(field.get()));
        properties.colorPickerHistory.add(0, field);
        if (properties.colorPickerHistory.size() > 15) {
            properties.colorPickerHistory.remove(15);
        }
        properties.save();
        this.setResponseAndClose(new ColorPickerResponse(this.currentColor, false));
    }

    private void reset() {
        this.currentColor = this.originalColor;
        this.updateHSVfields();
        this.updateFullBrightness();
        this.updateRGBfields();
        this.updateHexField();
        this.updateDecField();
        this.updateColorWheelHandler();
        this.updateAlphaField();
        this.updateVSliderHandler();
        this.updateASliderHandler();
    }

    public void renderPopupScreen(GuiGraphics graphics, int x, int y, float partialTicks) {
        super.renderPopupScreen(graphics, x, y, partialTicks);
        this.renderColorBoxes(graphics, this.layout.getX() + 1, this.layout.getY() + 14);
        this.renderColorWheel(graphics, this.layout.getX() + 161, this.layout.getY() - 1);
        this.renderSlider(graphics, this.layout.getX() + 253, this.layout.getY(), this.vSliderRect, this.vSliderHandler, this.currentColorFullBrightness, -16777216);
        if (this.withAlpha) {
            this.renderSlider(graphics, this.layout.getX() + 146, this.layout.getY(), this.aSliderRect, this.aSliderHandler, this.currentColor | 0xFF000000, this.currentColor & 0xFFFFFF);
        }
    }

    private IntSliderButton createCenteredSlider(IntegerField field, String prefix, Function<Button, Boolean> listener) {
        IntSliderButton slider = new IntSliderButton(field, prefix + " ", "");
        slider.setWidth(265);
        slider.setHeight(14);
        slider.setDefaultStyle(false);
        slider.setDrawBackground(false);
        slider.addClickListener(listener);
        return slider;
    }

    private void renderColorBoxes(GuiGraphics graphics, int x, int y) {
        int texWidth = 98;
        int texHeight = 26;
        int colorWidth = (texWidth - 2) / 2;
        int colorHeight = (texHeight - 2) / 2;
        int x2 = x + colorWidth;
        int y2 = y + colorHeight;
        DrawUtil.drawTexture(graphics, this.colorBoxTexture, (double)(x - 1), (double)(y - 1), (double)texWidth, (double)texHeight, false, 1.0f, 0.0, false);
        graphics.fill(x, y, x + colorWidth, y + colorHeight, this.originalColor | 0xFF000000);
        graphics.fill(x2, y, x2 + colorWidth, y + colorHeight, this.currentColor | 0xFF000000);
        graphics.fill(x, y2, x + colorWidth, y2 + colorHeight, this.originalColor);
        graphics.fill(x2, y2, x2 + colorWidth, y2 + colorHeight, this.currentColor);
        graphics.drawString(this.font, this.labelOld, x + 2, y - 12, Color.cyan.getRGB());
        graphics.drawString(this.font, this.labelNew, x + texWidth - 1 - this.font.width(this.labelNew), y - 12, Color.cyan.getRGB());
    }

    private void renderColorWheel(GuiGraphics graphics, int x, int y) {
        int cwWidth = 89;
        int cwHeight = 89;
        DrawUtil.drawBlurredTexture(graphics, this.colorwheelTexture, x, y, cwWidth, cwHeight, false, 1.0f, 0.0);
        this.colorWheelRect.setRect(x + 1, y + 1, cwWidth - 2, cwHeight - 2);
        int handlerX = (int)((double)(x + (cwWidth >> 1)) + this.colorwheelHandlerX - 2.0);
        int handlerY = (int)((double)(y + (cwHeight >> 1)) + this.colorwheelHandlerY - 2.0);
        graphics.fill(handlerX + 2, handlerY + 2, handlerX + 3, handlerY + 3, this.currentColorFullBrightness);
        DrawUtil.drawTexture(graphics, this.colorwheelHandlerTexture, (double)handlerX, (double)handlerY, 5.0, 5.0, false, 1.0f, 0.0, false);
    }

    private void renderSlider(GuiGraphics graphics, int x, int y, Rectangle2D.Double rect, double handler, int colorTop, int colorBottom) {
        int vSliderWidth = 12;
        int vSliderHeight = 87;
        DrawUtil.drawTexture(graphics, this.colorVSliderTexture, (double)x, (double)y, (double)vSliderWidth, (double)vSliderHeight, false, 1.0f, 0.0, false);
        graphics.fillGradient(x + 1, y + 1, x + vSliderWidth - 1, y + vSliderHeight - 1, colorTop, colorBottom);
        rect.setRect(x, y, vSliderWidth, vSliderHeight);
        int handlerX = x + 1;
        int handlerY = (int)((double)y + handler + 1.5);
        graphics.fill(handlerX + 2, handlerY + 2, handlerX + 9, handlerY + 3, colorTop);
        DrawUtil.drawTexture(graphics, this.colorVSliderHandlerTexture, (double)handlerX, (double)handlerY, 10.0, 5.0, false, 1.0f, 0.0, false);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.fieldHex.keyPressed(keyCode, scanCode, modifiers)) {
            this.listenerHex();
            return true;
        }
        if (this.fieldDec.keyPressed(keyCode, scanCode, modifiers)) {
            this.listenerDec();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.fieldHex.charTyped(typedChar, keyCode)) {
            this.listenerHex();
            return true;
        }
        if (this.fieldDec.charTyped(typedChar, keyCode)) {
            this.listenerDec();
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.clearFocus();
            if (this.colorWheelRect.contains(mouseX, mouseY)) {
                return this.updateCWHandler(mouseX, mouseY);
            }
            if (this.vSliderRect.contains(mouseX, mouseY)) {
                return this.updateVSHandler(mouseX, mouseY);
            }
            if (this.withAlpha && this.aSliderRect.contains(mouseX, mouseY)) {
                return this.updateASHandler(mouseX, mouseY);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.draggingCWHandler = false;
            this.draggingVSHandler = false;
            this.draggingASHandler = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0) {
            if (this.draggingCWHandler) {
                return this.updateCWHandler(mouseX, mouseY);
            }
            if (this.draggingVSHandler) {
                return this.updateVSHandler(mouseX, mouseY);
            }
            if (this.draggingASHandler) {
                return this.updateASHandler(mouseX, mouseY);
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    private boolean updateCWHandler(double mouseX, double mouseY) {
        double localY;
        double localX = mouseX - this.colorWheelRect.getCenterX();
        double dist = Math.sqrt(localX * localX + (localY = mouseY - this.colorWheelRect.getCenterY()) * localY);
        if (dist < 44.0) {
            this.draggingCWHandler = true;
        }
        if (this.draggingCWHandler) {
            if (dist >= 42.0) {
                localX = localX / dist * 42.0;
                localY = localY / dist * 42.0;
            }
            this.colorwheelHandlerX = localX;
            this.colorwheelHandlerY = localY;
            double angle = Math.atan2(this.colorwheelHandlerX, -this.colorwheelHandlerY) / (Math.PI * 2);
            angle = angle < 0.0 ? angle + 1.0 : angle;
            this.sliderH.setValue((int)(angle * 255.0));
            this.sliderS.setValue((int)(dist / 42.0 * 255.0));
            this.currentColor = Color.HSBtoRGB((float)this.fieldH.get().intValue() / 255.0f, (float)this.fieldS.get().intValue() / 255.0f, (float)this.fieldV.get().intValue() / 255.0f);
            this.currentColor = this.currentColor & 0xFFFFFF | this.fieldA.get() << 24;
            this.updateFullBrightness();
            this.updateRGBfields();
            this.updateHexField();
            this.updateDecField();
            return true;
        }
        return false;
    }

    private boolean updateVSHandler(double mouseX, double mouseY) {
        this.draggingVSHandler = true;
        double localY = mouseY - this.vSliderRect.getY() - 3.0;
        if (localY < 0.0) {
            localY = 0.0;
        } else if (localY > 80.0) {
            localY = 80.0;
        }
        this.vSliderHandler = localY;
        this.sliderV.setValue((int)((1.0 - this.vSliderHandler / 80.0) * 255.0));
        this.currentColor = Color.HSBtoRGB((float)this.fieldH.get().intValue() / 255.0f, (float)this.fieldS.get().intValue() / 255.0f, (float)this.fieldV.get().intValue() / 255.0f);
        this.currentColor = this.currentColor & 0xFFFFFF | this.fieldA.get() << 24;
        this.updateFullBrightness();
        this.updateRGBfields();
        this.updateHexField();
        this.updateDecField();
        return true;
    }

    private boolean updateASHandler(double mouseX, double mouseY) {
        this.draggingASHandler = true;
        double localY = mouseY - this.aSliderRect.getY() - 3.0;
        if (localY < 0.0) {
            localY = 0.0;
        } else if (localY > 80.0) {
            localY = 80.0;
        }
        this.aSliderHandler = localY;
        this.sliderA.setValue((int)((1.0 - this.aSliderHandler / 80.0) * 255.0));
        this.currentColor = this.currentColor & 0xFFFFFF | this.fieldA.get() << 24;
        this.updateHexField();
        this.updateDecField();
        return true;
    }

    private boolean historySelected(HistoryButton button) {
        int color = button.getColor();
        if (!this.withAlpha) {
            color = color & 0xFFFFFF | this.currentColor & 0xFF000000;
        }
        this.currentColor = color;
        this.updateHSVfields();
        this.updateFullBrightness();
        this.updateRGBfields();
        this.updateColorWheelHandler();
        this.updateAlphaField();
        this.updateVSliderHandler();
        this.updateASliderHandler();
        this.updateHexField();
        this.updateDecField();
        return true;
    }

    private void updateColorWheelHandler() {
        double angle = (double)this.fieldH.get().intValue() / 255.0 * Math.PI * 2.0;
        double dist = (double)this.fieldS.get().intValue() / 255.0 * 42.0;
        this.colorwheelHandlerX = dist * Math.sin(angle);
        this.colorwheelHandlerY = dist * -Math.cos(angle);
    }

    private void updateVSliderHandler() {
        this.vSliderHandler = (1.0 - (double)this.fieldV.get().intValue() / 255.0) * 80.0;
    }

    private void updateASliderHandler() {
        if (this.withAlpha) {
            this.aSliderHandler = (1.0 - (double)this.fieldA.get().intValue() / 255.0) * 80.0;
        }
    }

    private boolean listenerHSV(Button button) {
        this.currentColor = Color.HSBtoRGB((float)this.fieldH.get().intValue() / 255.0f, (float)this.fieldS.get().intValue() / 255.0f, (float)this.fieldV.get().intValue() / 255.0f);
        this.currentColor = this.currentColor & 0xFFFFFF | this.fieldA.get() << 24;
        this.updateFullBrightness();
        this.updateRGBfields();
        this.updateColorWheelHandler();
        this.updateVSliderHandler();
        this.updateHexField();
        this.updateDecField();
        return true;
    }

    private boolean listenerRGB(Button button) {
        this.currentColor = this.fieldA.get() << 24 | this.fieldR.get() << 16 | this.fieldG.get() << 8 | this.fieldB.get();
        this.updateHSVfields();
        this.updateFullBrightness();
        this.updateColorWheelHandler();
        this.updateVSliderHandler();
        this.updateHexField();
        this.updateDecField();
        return true;
    }

    private boolean listenerAlpha(Button button) {
        this.currentColor = this.currentColor & 0xFFFFFF | this.fieldA.get() << 24;
        this.updateASliderHandler();
        this.updateHexField();
        this.updateDecField();
        return true;
    }

    private boolean listenerHex() {
        this.currentColor = this.getSafeColorHex(this.fieldHex);
        this.updateHSVfields();
        this.updateFullBrightness();
        this.updateRGBfields();
        this.updateColorWheelHandler();
        this.updateAlphaField();
        this.updateVSliderHandler();
        this.updateASliderHandler();
        this.updateDecField();
        return true;
    }

    private boolean listenerDec() {
        this.currentColor = this.getSafeColorDec(this.fieldDec);
        this.updateHSVfields();
        this.updateFullBrightness();
        this.updateRGBfields();
        this.updateColorWheelHandler();
        this.updateAlphaField();
        this.updateVSliderHandler();
        this.updateASliderHandler();
        this.updateHexField();
        return true;
    }

    private void updateRGBfields() {
        this.sliderR.setValue(this.currentColor >> 16 & 0xFF);
        this.sliderG.setValue(this.currentColor >> 8 & 0xFF);
        this.sliderB.setValue(this.currentColor & 0xFF);
    }

    private void updateHSVfields() {
        float[] hsv = Color.RGBtoHSB(this.currentColor >> 16 & 0xFF, this.currentColor >> 8 & 0xFF, this.currentColor & 0xFF, null);
        this.sliderH.setValue((int)(hsv[0] * 255.0f));
        this.sliderS.setValue((int)(hsv[1] * 255.0f));
        this.sliderV.setValue((int)(hsv[2] * 255.0f));
    }

    private void updateHexField() {
        String format = this.withAlpha ? "%08X" : "%06X";
        int color = this.withAlpha ? this.currentColor : this.currentColor & 0xFFFFFF;
        this.fieldHex.setText(String.format(format, color));
    }

    private void updateDecField() {
        int color = this.withAlpha ? this.currentColor : this.currentColor & 0xFFFFFF;
        this.fieldDec.setText(String.valueOf(color));
    }

    private void updateAlphaField() {
        if (this.withAlpha) {
            this.sliderA.setValue(this.currentColor >> 24 & 0xFF);
        } else {
            this.fieldA.set((Object)(this.currentColor >> 24 & 0xFF));
        }
    }

    private void updateFullBrightness() {
        this.currentColorFullBrightness = Color.HSBtoRGB((float)this.fieldH.get().intValue() / 255.0f, (float)this.fieldS.get().intValue() / 255.0f, 1.0f);
    }

    private int getSafeColorHex(TextBox field) {
        field.clamp();
        String text = field.getValue();
        int color = RGB.hexToInt(text);
        if (this.withAlpha) {
            return color;
        }
        return color & 0xFFFFFF | this.fieldA.get() << 24;
    }

    private int getSafeColorDec(TextBox field) {
        field.clamp();
        String text = field.getValue();
        if (text.isEmpty()) {
            return 0;
        }
        int val = 0;
        try {
            val = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!this.withAlpha) {
            val = val & 0xFFFFFF | this.fieldA.get() << 24;
        }
        return val;
    }

    public record ColorPickerResponse(int color, boolean canceled) {
    }

    private static class HistoryButton
    extends Button {
        private final ResourceLocation texture;
        private final int color;

        public HistoryButton(ResourceLocation texture, int color, Button.OnPress onPress) {
            super(44, 14, "", onPress);
            this.color = color;
            this.texture = texture;
        }

        @Override
        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            DrawUtil.drawTexture(graphics, this.texture, (double)super.getX(), (double)super.getY(), (double)this.width, (double)this.height, false, 1.0f, 0.0, false);
            int colorWidth = (this.width - 4) / 2;
            int colorHeight = this.height - 4;
            int colorX = super.getX() + 2;
            int colorY = super.getY() + 2;
            graphics.fill(colorX, colorY, colorX + colorWidth, colorY + colorHeight, this.color | 0xFF000000);
            graphics.fill(colorX + colorWidth, colorY, colorX + colorWidth * 2, colorY + colorHeight, this.color);
            if (this.isHoveredOrFocused()) {
                DrawUtil.drawRectangle(graphics, super.getX(), super.getY(), this.width, 1.0, 0xFFFFFF, 1.0f);
                DrawUtil.drawRectangle(graphics, super.getX(), super.getY(), 1.0, this.height, 0xFFFFFF, 1.0f);
                DrawUtil.drawRectangle(graphics, super.getX(), super.getY() + this.height - 1, this.width - 1, 1.0, 0xFFFFFF, 1.0f);
                DrawUtil.drawRectangle(graphics, super.getX() + this.width - 1, super.getY() + 1, 1.0, this.height - 1, 0xFFFFFF, 1.0f);
            }
        }

        public int getColor() {
            return this.color;
        }
    }
}

