/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.map;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.model.grid.GridSpec;
import journeymap.client.model.region.RegionCoord;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.MapRenderer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix4f;

public class GridLines {
    private final MapRenderer mapRenderer;

    public GridLines(MapRenderer mapRenderer) {
        this.mapRenderer = mapRenderer;
    }

    public void draw(GuiGraphics graphics, MultiBufferSource.BufferSource bufferSource, PoseStack poseStack, RegionCoord centerRegion, Point2D.Double centerPixel, Rectangle2D.Double regionBounds, double pixelOffsetX, double pixelOffsetZ, double offsetX, double offsetZ, int zoom, float alpha, boolean showGrid) {
        if (showGrid) {
            GridSpec gridSpec = JourneymapClient.getInstance().getCoreProperties().gridSpecs.getSpec(this.mapRenderer.mapType);
            Point2D.Double distToCornerRegion = new Point2D.Double((double)centerRegion.regionX - regionBounds.x, (double)centerRegion.regionZ - regionBounds.y);
            Point2D.Double upperLeftRegion = new Point2D.Double(centerPixel.x - (double)((int)distToCornerRegion.x * zoom) + pixelOffsetX + offsetX, centerPixel.y - (double)((int)distToCornerRegion.y * zoom) + pixelOffsetZ + offsetZ);
            int regionCols = (int)regionBounds.width;
            int regionRows = (int)regionBounds.height;
            double x = upperLeftRegion.x;
            double y = upperLeftRegion.y;
            if (zoom >= 512) {
                RenderType renderType = gridSpec.getRenderType(zoom);
                VertexConsumer gridLinesBuffer = bufferSource.getBuffer(renderType);
                DrawUtil.drawQuad(poseStack, gridLinesBuffer, gridSpec.getColor(), alpha * gridSpec.alpha, x, y, regionCols * zoom, regionRows * zoom, 0.0, 0.0, regionCols, regionRows, 0.0, false);
            } else {
                double y1;
                double x1;
                boolean drawChunkLines = zoom >= 128 && gridSpec.style.hasChunkLines();
                boolean drawRegionLines = zoom >= 8 && gridSpec.style.hasRegionLines();
                int chunkCols = regionCols * 32;
                int chunkRows = regionRows * 32;
                RenderType renderType = gridSpec.getRenderType(zoom);
                VertexConsumer gridLinesBuffer = bufferSource.getBuffer(renderType);
                PoseStack.Pose entry = poseStack.last();
                Matrix4f matrix4f = entry.pose();
                float gridAlpha = gridSpec.alpha * alpha;
                if (drawChunkLines) {
                    boolean regionLine;
                    int chunkColor = RGB.toArgb(gridSpec.getColor(), zoom == 256 ? gridAlpha * 0.6666f : gridAlpha * 0.3333f);
                    for (int c = 0; c < chunkCols; ++c) {
                        boolean bl = regionLine = c % 32 == 0;
                        if (drawRegionLines && regionLine) continue;
                        x1 = upperLeftRegion.x + (double)(c * (zoom >> 5));
                        y1 = upperLeftRegion.y + (double)(regionRows * zoom);
                        gridLinesBuffer.addVertex(matrix4f, (float)x1, (float)y, 0.0f).setColor(chunkColor);
                        gridLinesBuffer.addVertex(matrix4f, (float)x1, (float)y1, 0.0f).setColor(chunkColor);
                    }
                    for (int r = 0; r < chunkRows; ++r) {
                        boolean bl = regionLine = r % 32 == 0;
                        if (drawRegionLines && regionLine) continue;
                        x1 = upperLeftRegion.x + (double)(regionCols * zoom);
                        y1 = upperLeftRegion.y + (double)(r * (zoom >> 5));
                        gridLinesBuffer.addVertex(matrix4f, (float)x, (float)y1, 0.0f).setColor(chunkColor);
                        gridLinesBuffer.addVertex(matrix4f, (float)x1, (float)y1, 0.0f).setColor(chunkColor);
                    }
                }
                if (drawRegionLines) {
                    int baseColor;
                    int n = baseColor = gridSpec.style.hasChunkLines() ? RGB.tint(gridSpec.getColor(), 0xFF0000) : gridSpec.getColor();
                    int regionColor = RGB.toArgb(baseColor, zoom == 16 ? gridAlpha * 0.6666f : (zoom == 8 ? gridAlpha * 0.3333f : gridAlpha));
                    for (int c = 0; c < regionCols; ++c) {
                        x1 = upperLeftRegion.x + (double)(c * zoom);
                        y1 = upperLeftRegion.y + (double)(regionRows * zoom);
                        gridLinesBuffer.addVertex(matrix4f, (float)x1, (float)y, 0.0f).setColor(regionColor);
                        gridLinesBuffer.addVertex(matrix4f, (float)x1, (float)y1, 0.0f).setColor(regionColor);
                    }
                    for (int r = 0; r < regionRows; ++r) {
                        x1 = upperLeftRegion.x + (double)(regionCols * zoom);
                        y1 = upperLeftRegion.y + (double)(r * zoom);
                        gridLinesBuffer.addVertex(matrix4f, (float)x, (float)y1, 0.0f).setColor(regionColor);
                        gridLinesBuffer.addVertex(matrix4f, (float)x1, (float)y1, 0.0f).setColor(regionColor);
                    }
                }
            }
        }
    }
}

