/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import journeymap.api.v2.client.display.MarkerOverlay;
import journeymap.api.v2.client.model.MapImage;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.client.render.draw.BaseOverlayDrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Renderer;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class DrawMarkerStep
extends BaseOverlayDrawStep<MarkerOverlay> {
    private Point2D.Double markerPosition;
    private AbstractTexture iconTexture;
    private final ResourceLocation location;
    private boolean hasError;

    public DrawMarkerStep(MarkerOverlay marker) {
        super(marker);
        this.location = marker.getIcon().getImageLocation() == null ? ResourceLocation.fromNamespaceAndPath((String)"fake", (String)CommonConstants.getSafeString(((MarkerOverlay)this.overlay).getGuid(), "-").toLowerCase(Locale.ROOT)) : marker.getIcon().getImageLocation();
    }

    @Override
    public void draw(GuiGraphics graphics, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        if (!this.isOnScreen(xOffset, yOffset, renderer, rotation)) {
            return;
        }
        this.ensureTexture();
        if (!this.hasError && this.iconTexture != null && ((TextureAccess)this.iconTexture).journeymap$hasImage()) {
            MapImage icon = ((MarkerOverlay)this.overlay).getIcon();
            int width = this.iconTexture.getTexture().getWidth(0);
            int height = this.iconTexture.getTexture().getHeight(0);
            float minU = (float)icon.getTextureX() / (float)width;
            float maxU = minU + (float)icon.getTextureWidth() / (float)width;
            float minV = (float)icon.getTextureY() / (float)height;
            float maxV = minV + (float)icon.getTextureHeight() / (float)height;
            DrawUtil.drawOnMapImage(graphics, this.location, icon.getColor(), icon.getOpacity(), this.markerPosition.x + xOffset - icon.getAnchorX(), this.markerPosition.y + yOffset - icon.getAnchorY(), icon.getDisplayWidth(), icon.getDisplayHeight(), minU, maxU, minV, maxV, (double)icon.getRotation() + rotation, icon.isBlur());
        }
        super.drawText(graphics, xOffset, yOffset, renderer, fontScale, rotation);
    }

    protected void ensureTexture() {
        if (this.iconTexture != null) {
            return;
        }
        try {
            MapImage icon = ((MarkerOverlay)this.overlay).getIcon();
            this.iconTexture = TextureCache.getTexture(this.location);
            if (this.iconTexture == null && icon.getImage() != null) {
                DynamicTexture texture = new DynamicTexture(() -> ((ResourceLocation)this.location).toString(), icon.getImage());
                Minecraft.getInstance().getTextureManager().register(this.location, (AbstractTexture)texture);
                this.iconTexture = texture;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error getting MarkerOverlay image upperTexture: " + String.valueOf(e), (Throwable)e);
            this.hasError = true;
        }
    }

    @Override
    protected void updatePositions(Renderer renderer, double rotation) {
        MapImage icon = ((MarkerOverlay)this.overlay).getIcon();
        this.markerPosition = renderer.getBlockPixelInGrid(((MarkerOverlay)this.overlay).getPoint());
        int halfBlock = (int)this.lastUiState.blockSize / 2;
        this.markerPosition.setLocation(this.markerPosition.x + (double)halfBlock, this.markerPosition.y + (double)halfBlock);
        TextProperties textProperties = ((MarkerOverlay)this.overlay).getTextProperties();
        int xShift = -textProperties.getOffsetX();
        int yShift = -textProperties.getOffsetY();
        if (xShift != 0 || yShift != 0) {
            Point2D shiftedPoint = renderer.shiftWindowPosition(this.markerPosition.x, this.markerPosition.y, xShift, yShift);
            this.labelPosition.setLocation(shiftedPoint.getX(), shiftedPoint.getY());
        } else {
            this.labelPosition.setLocation(this.markerPosition.x, this.markerPosition.y);
        }
        this.screenBounds.setRect(this.markerPosition.x, this.markerPosition.y, this.lastUiState.blockSize, this.lastUiState.blockSize);
        this.screenBounds.add(this.labelPosition);
        Rectangle2D.Double iconBounds = new Rectangle2D.Double(this.markerPosition.x - icon.getAnchorX(), this.markerPosition.y - icon.getAnchorY(), icon.getDisplayWidth(), icon.getDisplayHeight());
        this.screenBounds.add(iconBounds);
    }

    public static class SimpleCacheLoader
    extends CacheLoader<MarkerOverlay, DrawMarkerStep> {
        public DrawMarkerStep load(MarkerOverlay overlay) throws Exception {
            return new DrawMarkerStep(overlay);
        }
    }
}

