/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.base.Strings;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.Overlay;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.api.v2.client.util.UIState;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.draw.OverlayDrawStep;
import journeymap.client.render.map.Renderer;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.Nullable;

public abstract class BaseOverlayDrawStep<T extends Overlay>
implements OverlayDrawStep {
    public final T overlay;
    protected Rectangle2D.Double screenBounds = new Rectangle2D.Double();
    protected Point2D.Double titlePosition = null;
    protected Point2D.Double labelPosition = new Point2D.Double();
    protected UIState lastUiState = null;
    protected boolean dragging = false;
    protected boolean enabled = true;
    protected String[] labelLines;
    protected String[] titleLines;

    protected BaseOverlayDrawStep(T overlay) {
        this.overlay = overlay;
    }

    protected abstract void updatePositions(Renderer var1, double var2);

    protected void drawText(GuiGraphics graphics, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        TextProperties textProperties = this.overlay.getTextProperties();
        if (textProperties.isActiveIn(renderer.getUIState())) {
            double y;
            double x;
            if (this.labelPosition != null) {
                if (this.labelLines == null) {
                    this.updateTextFields();
                }
                if (this.labelLines != null) {
                    x = this.labelPosition.x + xOffset;
                    y = this.labelPosition.y + yOffset;
                    DrawUtil.drawLabels(graphics, this.labelLines, x, y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, textProperties.getBackgroundColor(), textProperties.getBackgroundOpacity(), textProperties.getColor(), textProperties.getOpacity(), (double)textProperties.getScale() * fontScale, textProperties.hasFontShadow(), rotation);
                }
            }
            if (renderer.getUIState().ui != Context.UI.Minimap && this.titlePosition != null) {
                if (this.titleLines == null) {
                    this.updateTextFields();
                }
                if (this.titleLines != null) {
                    x = this.titlePosition.x + 5.0 + xOffset;
                    y = this.titlePosition.y + yOffset;
                    DrawUtil.drawLabels(graphics, this.titleLines, x, y, DrawUtil.HAlign.Right, DrawUtil.VAlign.Above, textProperties.getBackgroundColor(), textProperties.getBackgroundOpacity(), textProperties.getColor(), textProperties.getOpacity(), (double)textProperties.getScale() * fontScale, textProperties.hasFontShadow(), rotation);
                }
            }
        }
    }

    @Override
    public boolean isOnScreen(double xOffset, double yOffset, Renderer renderer, double rotation) {
        if (!this.enabled) {
            return false;
        }
        UIState uiState = renderer.getUIState();
        if (!this.overlay.isActiveIn(uiState)) {
            return false;
        }
        if (!this.overlay.isInZoomRange(uiState)) {
            return false;
        }
        boolean draggingDone = false;
        if (xOffset != 0.0 || yOffset != 0.0) {
            this.dragging = true;
        } else {
            draggingDone = this.dragging;
            this.dragging = false;
        }
        if (draggingDone || uiState.ui == Context.UI.Minimap || this.overlay.getNeedsRerender() || !Objects.equals(uiState, this.lastUiState)) {
            this.lastUiState = uiState;
            this.updatePositions(renderer, rotation);
            this.overlay.clearFlagForRerender();
        }
        if (this.screenBounds == null) {
            return false;
        }
        return renderer.isOnScreen(this.screenBounds);
    }

    protected void updateTextFields() {
        if (this.labelPosition != null) {
            String labelText = this.overlay.getLabel();
            this.labelLines = !Strings.isNullOrEmpty((String)labelText) ? labelText.split("\n") : null;
        }
        if (this.titlePosition != null) {
            String titleText = this.overlay.getTitle();
            this.titleLines = !Strings.isNullOrEmpty((String)titleText) ? titleText.split("\n") : null;
        }
    }

    @Override
    public void setTitlePosition(@Nullable Point2D.Double titlePosition) {
        this.titlePosition = titlePosition;
    }

    @Override
    public int getDisplayOrder() {
        return this.overlay.getDisplayOrder();
    }

    @Override
    public String getModId() {
        return this.overlay.getModId();
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return this.screenBounds;
    }

    public T getOverlay() {
        return this.overlay;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

