/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.worldgen.feature.configurations.TwigletTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public class TwigletTreeFeature
extends BOPTreeFeature<TwigletTreeConfiguration> {
    public TwigletTreeFeature(Codec<TwigletTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean doPlace(WorldGenLevel world, RandomSource random, BlockPos startPos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        TwigletTreeConfiguration config = (TwigletTreeConfiguration)configBase;
        while (startPos.getY() >= world.getMinY() + 1 && startPos.getY() <= world.getMaxY() - 1 && (world.isEmptyBlock(startPos) || world.getBlockState(startPos).is(BlockTags.LEAVES))) {
            startPos = startPos.below();
        }
        if (world.getBlockState(startPos).getBlock() == Blocks.BEDROCK) {
            return false;
        }
        int height = config.minHeight + random.nextInt(1 + config.maxHeight - config.minHeight);
        int baseHeight = height / 3;
        BlockPos pos = startPos.above();
        for (int y = 0; y < height; ++y) {
            float leafChance;
            if (!this.placeLog((LevelAccessor)world, pos.above(y), logs, config)) {
                return true;
            }
            float f = leafChance = (height - y) % 2 == 0 ? config.leafChanceEven : config.leafChanceOdd;
            if (y <= baseHeight) continue;
            if (random.nextFloat() < leafChance) {
                this.placeLeaves((LevelAccessor)world, pos.offset(1, y, 0), leaves, config);
            }
            if (random.nextFloat() < leafChance) {
                this.placeLeaves((LevelAccessor)world, pos.offset(-1, y, 0), leaves, config);
            }
            if (random.nextFloat() < leafChance) {
                this.placeLeaves((LevelAccessor)world, pos.offset(0, y, 1), leaves, config);
            }
            if (random.nextFloat() < leafChance) {
                this.placeLeaves((LevelAccessor)world, pos.offset(0, y, -1), leaves, config);
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos fruitPos = pos.offset(dir.getStepX(), y, dir.getStepZ());
                BlockState trunkFruit = config.trunkFruitProvider.getState(random, fruitPos);
                if (trunkFruit.getBlock() == Blocks.AIR || random.nextInt(4) != 0) continue;
                if (trunkFruit.getBlock() == Blocks.COCOA) {
                    fruitPos = pos.offset(dir.getOpposite().getStepX(), 0, dir.getOpposite().getStepZ());
                }
                this.generateTrunkFruit((LevelAccessor)world, random.nextInt(3), fruitPos, dir, config);
            }
        }
        this.placeLeaves((LevelAccessor)world, pos.offset(0, height, 0), leaves, config);
        return true;
    }

    private void generateTrunkFruit(LevelAccessor world, int age, BlockPos pos, Direction direction, TwigletTreeConfiguration config) {
        BlockState trunkFruit = config.trunkFruitProvider.getState(world.getRandom(), pos);
        if (trunkFruit == Blocks.COCOA.defaultBlockState()) {
            if (world.getBlockState(pos).getBlock() == Blocks.AIR || world.getBlockState(pos).getBlock() instanceof VegetationBlock) {
                this.setBlock((LevelWriter)world, pos, (BlockState)((BlockState)trunkFruit.setValue((Property)CocoaBlock.AGE, (Comparable)Integer.valueOf(age))).setValue((Property)CocoaBlock.FACING, (Comparable)direction));
            }
        } else if (world.getBlockState(pos).getBlock() == Blocks.AIR || world.getBlockState(pos).getBlock() instanceof VegetationBlock) {
            this.setBlock((LevelWriter)world, pos, (BlockState)trunkFruit.setValue((Property)CocoaBlock.FACING, (Comparable)direction));
        }
    }
}

