/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.WaterloggedTransparentBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class EndscraperFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.getBlockState(pos).getBlock() == Blocks.END_STONE;
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)pos) || world.getBlockState(pos).is(BlockTags.REPLACEABLE_BY_TREES) || world.getBlockState(pos).getBlock() instanceof VegetationBlock || world.getBlockState(pos).getBlock() == BOPBlocks.NULL_END_STONE || world.getBlockState(pos).getBlock() == BOPBlocks.UNMAPPED_END_STONE;

    public EndscraperFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        int z;
        int x;
        WorldGenLevel world = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos startPos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        while (startPos.getY() >= world.getMinY() + 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.below();
        }
        int size = 9 - 3 * rand.nextInt(2) + 3 * rand.nextInt(4);
        int stories = 1 + rand.nextInt(6);
        int roomHeight = 8;
        int height = stories * roomHeight + 1;
        if (!this.placeOn.matches(world, startPos.offset(size / 2, 0, size / 2))) {
            return false;
        }
        if (!this.checkSpace(world, startPos.above(), size, height)) {
            return false;
        }
        BlockPos pos = startPos.above();
        for (x = -1; x <= size + 1; ++x) {
            for (z = -1; z <= size + 1; ++z) {
                int depth = 4 + rand.nextInt(4);
                if ((x == -1 || x == size + 1) && (z == -1 || z == size + 1)) continue;
                for (int y = 0; y <= depth; ++y) {
                    this.setBlock(world, startPos.offset(x, -y, z), Blocks.END_STONE.defaultBlockState());
                }
            }
        }
        block11: for (int i = 0; i < stories; ++i) {
            int roomType = rand.nextInt(16);
            switch (roomType) {
                default: {
                    this.generateEmptyRoom(world, pos.above(i * roomHeight), size, roomHeight, false);
                    continue block11;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.generateChainRoom(world, pos.above(i * roomHeight), size, roomHeight);
                    continue block11;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.generateDoorRoom(world, pos.above(i * roomHeight), size, roomHeight);
                    continue block11;
                }
                case 12: 
                case 13: {
                    this.generateChorusFruitRoom(world, pos.above(i * roomHeight), size, roomHeight);
                    continue block11;
                }
                case 14: {
                    this.generatePoolRoom(world, pos.above(i * roomHeight), size, roomHeight);
                    continue block11;
                }
                case 15: {
                    this.generateBackroom(world, pos.above(i * roomHeight), size, roomHeight);
                }
            }
        }
        for (x = 0; x <= size; ++x) {
            for (z = 0; z <= size; ++z) {
                if (x == 0 || x == size || z == 0 || z == size) {
                    BlockState edgeBlock = Blocks.WAXED_WEATHERED_CUT_COPPER.defaultBlockState();
                    if (world.getRandom().nextInt(2) == 0) {
                        edgeBlock = Blocks.WAXED_WEATHERED_COPPER.defaultBlockState();
                    }
                    this.setBlock(world, startPos.offset(x, height, z), edgeBlock);
                } else {
                    this.setBlock(world, startPos.offset(x, height, z), Blocks.WAXED_WEATHERED_CUT_COPPER_SLAB.defaultBlockState());
                }
                if (x == 0 && z == 0) {
                    this.setBlock(world, startPos.offset(x, height + 1, z), (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue((Property)IronBarsBlock.SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)IronBarsBlock.EAST, (Comparable)Boolean.valueOf(true)));
                    continue;
                }
                if (x == 0 && z == size) {
                    this.setBlock(world, startPos.offset(x, height + 1, z), (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue((Property)IronBarsBlock.NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)IronBarsBlock.EAST, (Comparable)Boolean.valueOf(true)));
                    continue;
                }
                if (x == size && z == 0) {
                    this.setBlock(world, startPos.offset(x, height + 1, z), (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue((Property)IronBarsBlock.SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)IronBarsBlock.WEST, (Comparable)Boolean.valueOf(true)));
                    continue;
                }
                if (x == size && z == size) {
                    this.setBlock(world, startPos.offset(x, height + 1, z), (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue((Property)IronBarsBlock.NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)IronBarsBlock.WEST, (Comparable)Boolean.valueOf(true)));
                    continue;
                }
                if (x == 0 || x == size) {
                    this.setBlock(world, startPos.offset(x, height + 1, z), (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue((Property)IronBarsBlock.NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)IronBarsBlock.SOUTH, (Comparable)Boolean.valueOf(true)));
                }
                if (z != 0 && z != size) continue;
                this.setBlock(world, startPos.offset(x, height + 1, z), (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue((Property)IronBarsBlock.EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)IronBarsBlock.WEST, (Comparable)Boolean.valueOf(true)));
            }
        }
        return true;
    }

    public void generateEmptyRoom(WorldGenLevel world, BlockPos pos, int size, int roomHeight, boolean windowsOpen) {
        int z;
        int x;
        for (x = 0; x <= size; ++x) {
            for (z = 0; z <= size; ++z) {
                BlockState separatorBlock = Blocks.WAXED_WEATHERED_CUT_COPPER.defaultBlockState();
                if (world.getRandom().nextInt(2) == 0) {
                    separatorBlock = Blocks.WAXED_WEATHERED_COPPER.defaultBlockState();
                }
                this.setBlock(world, pos.offset(x, 0, z), separatorBlock);
            }
        }
        pos = pos.above();
        for (x = 0; x <= size; ++x) {
            for (z = 0; z <= size; ++z) {
                for (int y = 0; y <= roomHeight - 2; ++y) {
                    BlockState wallBlock = Blocks.AIR.defaultBlockState();
                    if (x == 0) {
                        wallBlock = z % 3 == 1 || z % 3 == 2 ? (y % 3 == 1 ? (BlockState)((BlockState)((BlockState)Blocks.WAXED_WEATHERED_COPPER_TRAPDOOR.defaultBlockState().setValue((Property)TrapDoorBlock.FACING, (Comparable)Direction.WEST)).setValue((Property)TrapDoorBlock.HALF, (Comparable)Half.BOTTOM)).setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(!windowsOpen)) : (y % 3 == 2 ? (BlockState)((BlockState)((BlockState)Blocks.WAXED_WEATHERED_COPPER_TRAPDOOR.defaultBlockState().setValue((Property)TrapDoorBlock.FACING, (Comparable)Direction.WEST)).setValue((Property)TrapDoorBlock.HALF, (Comparable)Half.TOP)).setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(!windowsOpen)) : (world.getRandom().nextInt(5) == 0 ? Blocks.END_STONE.defaultBlockState() : Blocks.END_STONE_BRICKS.defaultBlockState()))) : (world.getRandom().nextInt(5) == 0 ? Blocks.END_STONE.defaultBlockState() : Blocks.END_STONE_BRICKS.defaultBlockState());
                    }
                    if (x == size) {
                        wallBlock = z % 3 == 1 || z % 3 == 2 ? (y % 3 == 1 ? (BlockState)((BlockState)((BlockState)Blocks.WAXED_WEATHERED_COPPER_TRAPDOOR.defaultBlockState().setValue((Property)TrapDoorBlock.FACING, (Comparable)Direction.EAST)).setValue((Property)TrapDoorBlock.HALF, (Comparable)Half.BOTTOM)).setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(!windowsOpen)) : (y % 3 == 2 ? (BlockState)((BlockState)((BlockState)Blocks.WAXED_WEATHERED_COPPER_TRAPDOOR.defaultBlockState().setValue((Property)TrapDoorBlock.FACING, (Comparable)Direction.EAST)).setValue((Property)TrapDoorBlock.HALF, (Comparable)Half.TOP)).setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(!windowsOpen)) : (world.getRandom().nextInt(5) == 0 ? Blocks.END_STONE.defaultBlockState() : Blocks.END_STONE_BRICKS.defaultBlockState()))) : (world.getRandom().nextInt(5) == 0 ? Blocks.END_STONE.defaultBlockState() : Blocks.END_STONE_BRICKS.defaultBlockState());
                    }
                    if (z == 0) {
                        wallBlock = x % 3 == 1 || x % 3 == 2 ? (y % 3 == 1 ? (BlockState)((BlockState)((BlockState)Blocks.WAXED_WEATHERED_COPPER_TRAPDOOR.defaultBlockState().setValue((Property)TrapDoorBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)TrapDoorBlock.HALF, (Comparable)Half.BOTTOM)).setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(!windowsOpen)) : (y % 3 == 2 ? (BlockState)((BlockState)((BlockState)Blocks.WAXED_WEATHERED_COPPER_TRAPDOOR.defaultBlockState().setValue((Property)TrapDoorBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)TrapDoorBlock.HALF, (Comparable)Half.TOP)).setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(!windowsOpen)) : (world.getRandom().nextInt(5) == 0 ? Blocks.END_STONE.defaultBlockState() : Blocks.END_STONE_BRICKS.defaultBlockState()))) : (world.getRandom().nextInt(5) == 0 ? Blocks.END_STONE.defaultBlockState() : Blocks.END_STONE_BRICKS.defaultBlockState());
                    }
                    if (z == size) {
                        wallBlock = x % 3 == 1 || x % 3 == 2 ? (y % 3 == 1 ? (BlockState)((BlockState)((BlockState)Blocks.WAXED_WEATHERED_COPPER_TRAPDOOR.defaultBlockState().setValue((Property)TrapDoorBlock.FACING, (Comparable)Direction.SOUTH)).setValue((Property)TrapDoorBlock.HALF, (Comparable)Half.BOTTOM)).setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(!windowsOpen)) : (y % 3 == 2 ? (BlockState)((BlockState)((BlockState)Blocks.WAXED_WEATHERED_COPPER_TRAPDOOR.defaultBlockState().setValue((Property)TrapDoorBlock.FACING, (Comparable)Direction.SOUTH)).setValue((Property)TrapDoorBlock.HALF, (Comparable)Half.TOP)).setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(!windowsOpen)) : (world.getRandom().nextInt(5) == 0 ? Blocks.END_STONE.defaultBlockState() : Blocks.END_STONE_BRICKS.defaultBlockState()))) : (world.getRandom().nextInt(5) == 0 ? Blocks.END_STONE.defaultBlockState() : Blocks.END_STONE_BRICKS.defaultBlockState());
                    }
                    if (wallBlock.isAir()) continue;
                    this.setBlock(world, pos.offset(x, y, z), wallBlock);
                }
            }
        }
    }

    public void generateChainRoom(WorldGenLevel world, BlockPos pos, int size, int roomHeight) {
        this.generateEmptyRoom(world, pos, size, roomHeight, false);
        for (int x = 1; x <= size - 1; ++x) {
            for (int z = 1; z <= size - 1; ++z) {
                if (world.getRandom().nextInt(4) != 0) continue;
                int chainHeight = world.getRandom().nextInt(roomHeight);
                for (int y = 0; y < chainHeight; ++y) {
                    this.setBlock(world, pos.offset(x, roomHeight - 1 - y, z), Blocks.CHAIN.defaultBlockState());
                }
            }
        }
    }

    public void generateDoorRoom(WorldGenLevel world, BlockPos pos, int size, int roomHeight) {
        this.generateEmptyRoom(world, pos, size, roomHeight, false);
        for (int x = 1; x <= size - 1; ++x) {
            for (int z = 1; z <= size - 1; ++z) {
                if (!(x % 3 != 1 && x % 3 != 2 || z % 3 != 1 && z % 3 != 2)) {
                    this.setBlock(world, pos.offset(x, roomHeight - 1, z), Blocks.WAXED_WEATHERED_CHISELED_COPPER.defaultBlockState());
                }
                if (x % 3 != 0 || z % 3 != 0) continue;
                Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(world.getRandom());
                DoorHingeSide hingeSide = DoorHingeSide.LEFT;
                boolean open = false;
                if (world.getRandom().nextInt(2) == 0) {
                    hingeSide = DoorHingeSide.RIGHT;
                }
                if (world.getRandom().nextInt(2) == 0) {
                    open = true;
                }
                this.setBlock(world, pos.offset(x, 1, z), (BlockState)((BlockState)((BlockState)((BlockState)Blocks.WAXED_WEATHERED_COPPER_DOOR.defaultBlockState().setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)DoorBlock.FACING, (Comparable)direction)).setValue((Property)DoorBlock.HINGE, (Comparable)hingeSide)).setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(open)));
                this.setBlock(world, pos.offset(x, 2, z), (BlockState)((BlockState)((BlockState)((BlockState)Blocks.WAXED_WEATHERED_COPPER_DOOR.defaultBlockState().setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)DoorBlock.FACING, (Comparable)direction)).setValue((Property)DoorBlock.HINGE, (Comparable)hingeSide)).setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(open)));
            }
        }
    }

    public void generateChorusFruitRoom(WorldGenLevel world, BlockPos pos, int size, int roomHeight) {
        this.generateEmptyRoom(world, pos, size, roomHeight, false);
        for (int x = 1; x <= size - 1; ++x) {
            for (int z = 1; z <= size - 1; ++z) {
                BlockState floorBlock = Blocks.END_STONE_BRICKS.defaultBlockState();
                if (world.getRandom().nextInt(3) == 0) {
                    floorBlock = Blocks.END_STONE.defaultBlockState();
                }
                if (x == 1 || x == size - 1 || z == 1 || z == size - 1) {
                    this.setBlock(world, pos.offset(x, 1, z), floorBlock);
                    continue;
                }
                if (x % 3 == 0 && z % 3 == 0) {
                    this.setBlock(world, pos.offset(x, 1, z), Blocks.END_STONE.defaultBlockState());
                    this.setBlock(world, pos.offset(x, 2, z), Blocks.CHORUS_FLOWER.defaultBlockState());
                    continue;
                }
                if (x % 3 == 0 || z % 3 == 0) {
                    this.setBlock(world, pos.offset(x, 1, z), floorBlock);
                    continue;
                }
                this.setBlock(world, pos.offset(x, 1, z), Blocks.PURPUR_PILLAR.defaultBlockState());
            }
        }
    }

    public void generatePoolRoom(WorldGenLevel world, BlockPos pos, int size, int roomHeight) {
        this.generateEmptyRoom(world, pos, size, roomHeight, true);
        for (int x = 1; x <= size - 1; ++x) {
            for (int z = 1; z <= size - 1; ++z) {
                if (x == 1 || x == size - 1 || z == 1 || z == size - 1) {
                    this.setBlock(world, pos.offset(x, 1, z), (BlockState)Blocks.WAXED_WEATHERED_COPPER_GRATE.defaultBlockState().setValue((Property)WaterloggedTransparentBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
                    continue;
                }
                this.setBlock(world, pos.offset(x, 1, z), Blocks.WATER.defaultBlockState());
            }
        }
    }

    public void generateBackroom(WorldGenLevel world, BlockPos pos, int size, int roomHeight) {
        int z;
        int x;
        this.generateEmptyRoom(world, pos, size, roomHeight, false);
        for (x = 1; x <= size - 1; ++x) {
            for (z = 1; z <= size - 1; ++z) {
                for (int y = 1; y <= roomHeight - 1; ++y) {
                    if (x != 1 && x != size - 1 && z != 1 && z != size - 1) continue;
                    this.setBlock(world, pos.offset(x, y, z), Blocks.END_STONE.defaultBlockState());
                }
            }
        }
        for (x = 2; x <= size - 2; ++x) {
            for (z = 2; z <= size - 2; ++z) {
                this.setBlock(world, pos.offset(x, 1, z), BOPBlocks.ALGAL_END_STONE.defaultBlockState());
            }
        }
        for (x = 2; x <= size - 2; ++x) {
            for (z = 2; z <= size - 2; ++z) {
                if (z % 3 == 0 && x != 2 && x != size - 2) {
                    if (x % 3 == 1) {
                        this.setBlock(world, pos.offset(x, roomHeight - 1, z), (BlockState)Blocks.END_ROD.defaultBlockState().setValue((Property)EndRodBlock.FACING, (Comparable)Direction.EAST));
                        this.setBlock(world, pos.offset(x, roomHeight - 2, z), BOPBlocks.WISPJELLY.defaultBlockState());
                        continue;
                    }
                    if (x % 3 == 2) {
                        this.setBlock(world, pos.offset(x, roomHeight - 1, z), (BlockState)Blocks.END_ROD.defaultBlockState().setValue((Property)EndRodBlock.FACING, (Comparable)Direction.WEST));
                        this.setBlock(world, pos.offset(x, roomHeight - 2, z), BOPBlocks.WISPJELLY.defaultBlockState());
                        continue;
                    }
                    this.setBlock(world, pos.offset(x, roomHeight - 1, z), Blocks.END_STONE.defaultBlockState());
                    this.setBlock(world, pos.offset(x, roomHeight - 2, z), Blocks.END_STONE.defaultBlockState());
                    continue;
                }
                this.setBlock(world, pos.offset(x, roomHeight - 1, z), Blocks.END_STONE.defaultBlockState());
                this.setBlock(world, pos.offset(x, roomHeight - 2, z), Blocks.END_STONE.defaultBlockState());
            }
        }
        int wallLength = size / 3 - 1;
        int wallDistance = size / 3 - 2;
        for (int x2 = 0; x2 < wallLength; ++x2) {
            int y;
            for (y = 1; y <= roomHeight - 3; ++y) {
                this.setBlock(world, pos.offset(2 + x2, y, 2 + wallDistance), BOPBlocks.UNMAPPED_END_STONE.defaultBlockState());
                this.setBlock(world, pos.offset(size - 2 - x2, y, 2 + wallDistance), BOPBlocks.UNMAPPED_END_STONE.defaultBlockState());
            }
            for (y = 1; y <= roomHeight - 4; ++y) {
                this.setBlock(world, pos.offset(2 + x2, y, size - 2 - wallDistance), BOPBlocks.UNMAPPED_END_STONE.defaultBlockState());
                this.setBlock(world, pos.offset(size - 2 - x2, y, size - 2 - wallDistance), BOPBlocks.UNMAPPED_END_STONE.defaultBlockState());
            }
        }
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.setBlock((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos, int size, int height) {
        for (int y = 0; y <= height; ++y) {
            for (int x = -1; x <= size + 1; ++x) {
                for (int z = -1; z <= size + 1; ++z) {
                    BlockPos pos1 = pos.offset(x, y, z);
                    if (pos1.getY() < 255 && this.replace.matches(world, pos1) && this.respectsCutoff((WorldGenRegion)world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean respectsCutoff(WorldGenRegion region, BlockPos pos) {
        int i = SectionPos.blockToSectionCoord((int)pos.getX());
        int j = SectionPos.blockToSectionCoord((int)pos.getZ());
        ChunkPos chunkpos = region.getCenter();
        int k = Math.abs(chunkpos.x - i);
        int l = Math.abs(chunkpos.z - j);
        return k <= region.generatingStep.blockStateWriteRadius() && l <= region.generatingStep.blockStateWriteRadius();
    }
}

