/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.api.block.BOPBlockEntities;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BOPFluids;
import biomesoplenty.api.block.BOPWoodTypes;
import biomesoplenty.api.entity.BOPEntities;
import biomesoplenty.client.renderer.AnomalyRenderer;
import biomesoplenty.init.ModModelLayers;
import biomesoplenty.init.ModParticles;
import biomesoplenty.particle.BinaryParticle;
import biomesoplenty.particle.DripParticleBOP;
import biomesoplenty.particle.EndSporeParticle;
import biomesoplenty.particle.GlowwormParticle;
import biomesoplenty.particle.LargeLeafParticle;
import biomesoplenty.particle.LeafParticle;
import biomesoplenty.particle.NormalLeafParticle;
import biomesoplenty.particle.NullParticle;
import biomesoplenty.particle.PusParticle;
import biomesoplenty.particle.SteamParticle;
import biomesoplenty.particle.WispBubbleParticle;
import glitchcore.event.EventManager;
import glitchcore.event.client.RegisterColorsEvent;
import glitchcore.event.client.RegisterLayerDefinitionsEvent;
import glitchcore.event.client.RegisterParticleSpritesEvent;
import glitchcore.event.client.RegisterRenderersEvent;
import glitchcore.util.RenderHelper;
import glitchcore.util.SheetHelper;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;

public class ModClient {
    public static void setup() {
        ModClient.setupRenderTypes();
        ModClient.registerWoodTypes();
    }

    public static void addClientHandlers() {
        EventManager.addListener(ModClient::registerBlockColors);
        EventManager.addListener(ModClient::registerParticleSprites);
        EventManager.addListener(ModClient::registerLayerDefinitions);
        EventManager.addListener(ModClient::registerRenderers);
    }

    public static void setupRenderTypes() {
        RenderHelper.setRenderType((Block)BOPBlocks.MOSSY_BLACK_SAND, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.WISPJELLY, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.NULL_END_STONE, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.NULL_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.NULL_PLANT, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.GLOWING_MOSS_BLOCK, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.GLOWING_MOSS_CARPET, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.FLOWERING_OAK_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.CYPRESS_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.SNOWBLOSSOM_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.ORIGIN_OAK_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.FIR_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.PINE_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.RED_MAPLE_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.ORANGE_MAPLE_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.YELLOW_MAPLE_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.REDWOOD_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.MAHOGANY_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.JACARANDA_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.PALM_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.WILLOW_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.DEAD_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.MAGIC_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.UMBRAN_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.HELLBARK_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.EMPYREAL_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.FLOWERING_OAK_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.CYPRESS_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.SNOWBLOSSOM_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.ORIGIN_OAK_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.FIR_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.PINE_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.RED_MAPLE_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.ORANGE_MAPLE_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.YELLOW_MAPLE_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.REDWOOD_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.MAHOGANY_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.JACARANDA_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.PALM_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.WILLOW_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.DEAD_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.MAGIC_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.UMBRAN_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.HELLBARK_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.EMPYREAL_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.FLOWER_BUD, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.ORIGIN_DANDELION, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.ORIGIN_ROSE, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.MARIGOLD, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.VIOLET, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.LAVENDER, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.WHITE_LAVENDER, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.PURPLE_WILDFLOWERS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.ORANGE_COSMOS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.PINK_DAFFODIL, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.PINK_HIBISCUS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.WATERLILY, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.WHITE_PETALS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.GLOWFLOWER, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.WILTED_LILY, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.BURNING_BLOSSOM, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.TALL_LAVENDER, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.TALL_WHITE_LAVENDER, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.BLUE_HYDRANGEA, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.GOLDENROD, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.ICY_IRIS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.WILLOW_VINE, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.SPANISH_MOSS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.SPANISH_MOSS_PLANT, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.GLOWWORM_SILK, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.GLOWWORM_SILK_STRAND, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.HANGING_COBWEB, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.HANGING_COBWEB_STRAND, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.STRINGY_COBWEB, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.WEBBING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.SPROUT, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.HIGH_GRASS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.HIGH_GRASS_PLANT, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.CLOVER, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.HUGE_CLOVER_PETAL, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.HUGE_LILY_PAD, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.RED_MAPLE_LEAF_LITTER, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.ORANGE_MAPLE_LEAF_LITTER, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.YELLOW_MAPLE_LEAF_LITTER, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.DUNE_GRASS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.DESERT_GRASS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.DEAD_GRASS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.TUNDRA_SHRUB, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.CATTAIL, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.BARLEY, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.SEA_OATS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.REED, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.WATERGRASS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.DEAD_BRANCH, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.TINY_CACTUS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.BRAMBLE, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.BRAMBLE_LEAVES, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.TOADSTOOL, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.GLOWSHROOM, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.PUS_BUBBLE, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.FLESH_TENDONS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.FLESH_TENDONS_STRAND, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.EYEBULB, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.HAIR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.BRIMSTONE_BUD, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.BRIMSTONE_CLUSTER, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.ROSE_QUARTZ_CLUSTER, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.LARGE_ROSE_QUARTZ_BUD, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.MEDIUM_ROSE_QUARTZ_BUD, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.SMALL_ROSE_QUARTZ_BUD, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.BLACKSTONE_SPINES, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.BLACKSTONE_BULB, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.ENDBLOOM, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.ENDERPHYTE, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.LUMALOOP, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.LUMALOOP_PLANT, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.SPIDER_EGG, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.ORIGIN_OAK_DOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.FIR_DOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.PINE_DOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.MAPLE_DOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.REDWOOD_DOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.MAHOGANY_DOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.JACARANDA_DOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.PALM_DOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.WILLOW_DOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.DEAD_DOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.MAGIC_DOOR, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.UMBRAN_DOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.HELLBARK_DOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.EMPYREAL_DOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.ORIGIN_OAK_TRAPDOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.FIR_TRAPDOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.PINE_TRAPDOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.MAPLE_TRAPDOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.REDWOOD_TRAPDOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.MAHOGANY_TRAPDOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.JACARANDA_TRAPDOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.PALM_TRAPDOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.WILLOW_TRAPDOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.DEAD_TRAPDOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.MAGIC_TRAPDOOR, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.UMBRAN_TRAPDOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.HELLBARK_TRAPDOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.EMPYREAL_TRAPDOOR, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_FLOWERING_OAK_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_CYPRESS_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_SNOWBLOSSOM_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_ORIGIN_OAK_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_FIR_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_PINE_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_RED_MAPLE_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_ORANGE_MAPLE_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_YELLOW_MAPLE_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_REDWOOD_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_MAHOGANY_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_JACARANDA_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_PALM_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_WILLOW_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_DEAD_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_MAGIC_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_UMBRAN_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_HELLBARK_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_EMPYREAL_SAPLING, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_FLOWER_BUD, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_ORIGIN_DANDELION, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_ORIGIN_ROSE, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_MARIGOLD, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_VIOLET, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_LAVENDER, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_WHITE_LAVENDER, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_ORANGE_COSMOS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_PINK_DAFFODIL, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_PINK_HIBISCUS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_GLOWFLOWER, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_WILTED_LILY, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_BURNING_BLOSSOM, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_ENDBLOOM, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_SPROUT, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_TINY_CACTUS, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_TOADSTOOL, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_GLOWSHROOM, (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        RenderHelper.setRenderType((Block)BOPBlocks.BLOOD, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Fluid)BOPFluids.BLOOD, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Fluid)BOPFluids.FLOWING_BLOOD, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Block)BOPBlocks.LIQUID_NULL, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Fluid)BOPFluids.LIQUID_NULL, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
        RenderHelper.setRenderType((Fluid)BOPFluids.LIQUID_NULL, (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
    }

    public static void registerLayerDefinitions(RegisterLayerDefinitionsEvent event) {
        LayerDefinition boatLayerDefinition = BoatModel.createBoatModel();
        LayerDefinition chestBoatLayerDefinition = BoatModel.createChestBoatModel();
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.ORIGIN_OAK_BOAT, () -> boatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.ORIGIN_OAK_CHEST_BOAT, () -> chestBoatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.FIR_BOAT, () -> boatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.FIR_CHEST_BOAT, () -> chestBoatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.PINE_BOAT, () -> boatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.PINE_CHEST_BOAT, () -> chestBoatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.MAPLE_BOAT, () -> boatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.MAPLE_CHEST_BOAT, () -> chestBoatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.REDWOOD_BOAT, () -> boatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.REDWOOD_CHEST_BOAT, () -> chestBoatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.MAHOGANY_BOAT, () -> boatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.MAHOGANY_CHEST_BOAT, () -> chestBoatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.JACARANDA_BOAT, () -> boatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.JACARANDA_CHEST_BOAT, () -> chestBoatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.PALM_BOAT, () -> boatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.PALM_CHEST_BOAT, () -> chestBoatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.WILLOW_BOAT, () -> boatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.WILLOW_CHEST_BOAT, () -> chestBoatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.DEAD_BOAT, () -> boatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.DEAD_CHEST_BOAT, () -> chestBoatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.MAGIC_BOAT, () -> boatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.MAGIC_CHEST_BOAT, () -> chestBoatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.UMBRAN_BOAT, () -> boatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.UMBRAN_CHEST_BOAT, () -> chestBoatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.HELLBARK_BOAT, () -> boatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.HELLBARK_CHEST_BOAT, () -> chestBoatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.EMPYREAL_BOAT, () -> boatLayerDefinition);
        RenderHelper.registerLayerDefinition((ModelLayerLocation)ModModelLayers.EMPYREAL_CHEST_BOAT, () -> chestBoatLayerDefinition);
    }

    public static void registerRenderers(RegisterRenderersEvent event) {
        RenderHelper.registerBlockEntityRenderer(BOPBlockEntities.SIGN, SignRenderer::new);
        RenderHelper.registerBlockEntityRenderer(BOPBlockEntities.HANGING_SIGN, HangingSignRenderer::new);
        RenderHelper.registerBlockEntityRenderer(BOPBlockEntities.ANOMALY, AnomalyRenderer::new);
        RenderHelper.registerEntityRenderer(BOPEntities.ORIGIN_OAK_BOAT, context -> new BoatRenderer(context, ModModelLayers.ORIGIN_OAK_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.ORIGIN_OAK_CHEST_BOAT, context -> new BoatRenderer(context, ModModelLayers.ORIGIN_OAK_CHEST_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.FIR_BOAT, context -> new BoatRenderer(context, ModModelLayers.FIR_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.FIR_CHEST_BOAT, context -> new BoatRenderer(context, ModModelLayers.FIR_CHEST_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.PINE_BOAT, context -> new BoatRenderer(context, ModModelLayers.PINE_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.PINE_CHEST_BOAT, context -> new BoatRenderer(context, ModModelLayers.PINE_CHEST_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.MAPLE_BOAT, context -> new BoatRenderer(context, ModModelLayers.MAPLE_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.MAPLE_CHEST_BOAT, context -> new BoatRenderer(context, ModModelLayers.MAPLE_CHEST_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.REDWOOD_BOAT, context -> new BoatRenderer(context, ModModelLayers.REDWOOD_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.REDWOOD_CHEST_BOAT, context -> new BoatRenderer(context, ModModelLayers.REDWOOD_CHEST_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.MAHOGANY_BOAT, context -> new BoatRenderer(context, ModModelLayers.MAHOGANY_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.MAHOGANY_CHEST_BOAT, context -> new BoatRenderer(context, ModModelLayers.MAHOGANY_CHEST_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.JACARANDA_BOAT, context -> new BoatRenderer(context, ModModelLayers.JACARANDA_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.JACARANDA_CHEST_BOAT, context -> new BoatRenderer(context, ModModelLayers.JACARANDA_CHEST_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.PALM_BOAT, context -> new BoatRenderer(context, ModModelLayers.PALM_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.PALM_CHEST_BOAT, context -> new BoatRenderer(context, ModModelLayers.PALM_CHEST_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.WILLOW_BOAT, context -> new BoatRenderer(context, ModModelLayers.WILLOW_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.WILLOW_CHEST_BOAT, context -> new BoatRenderer(context, ModModelLayers.WILLOW_CHEST_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.DEAD_BOAT, context -> new BoatRenderer(context, ModModelLayers.DEAD_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.DEAD_CHEST_BOAT, context -> new BoatRenderer(context, ModModelLayers.DEAD_CHEST_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.MAGIC_BOAT, context -> new BoatRenderer(context, ModModelLayers.MAGIC_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.MAGIC_CHEST_BOAT, context -> new BoatRenderer(context, ModModelLayers.MAGIC_CHEST_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.UMBRAN_BOAT, context -> new BoatRenderer(context, ModModelLayers.UMBRAN_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.UMBRAN_CHEST_BOAT, context -> new BoatRenderer(context, ModModelLayers.UMBRAN_CHEST_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.HELLBARK_BOAT, context -> new BoatRenderer(context, ModModelLayers.HELLBARK_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.HELLBARK_CHEST_BOAT, context -> new BoatRenderer(context, ModModelLayers.HELLBARK_CHEST_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.EMPYREAL_BOAT, context -> new BoatRenderer(context, ModModelLayers.EMPYREAL_BOAT));
        RenderHelper.registerEntityRenderer(BOPEntities.EMPYREAL_CHEST_BOAT, context -> new BoatRenderer(context, ModModelLayers.EMPYREAL_CHEST_BOAT));
    }

    public static void registerBlockColors(RegisterColorsEvent.Block event) {
        event.register((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0), (Object[])new Block[]{BOPBlocks.FLOWER_STEM, BOPBlocks.MOSSY_BLACK_SAND, BOPBlocks.SPROUT, BOPBlocks.HIGH_GRASS, BOPBlocks.HIGH_GRASS_PLANT, BOPBlocks.CLOVER, BOPBlocks.HUGE_CLOVER_PETAL, BOPBlocks.BARLEY, BOPBlocks.WATERGRASS, BOPBlocks.POTTED_SPROUT});
        event.register((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)world, (BlockPos)pos) : -12012264, (Object[])new Block[]{BOPBlocks.FLOWERING_OAK_LEAVES, BOPBlocks.PINE_LEAVES, BOPBlocks.MAHOGANY_LEAVES, BOPBlocks.PALM_LEAVES, BOPBlocks.WILLOW_LEAVES, BOPBlocks.WILLOW_VINE, BOPBlocks.BRAMBLE_LEAVES});
        event.register((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.getAverageDryFoliageColor((BlockAndTintGetter)world, (BlockPos)pos) : -10732494, (Object[])new Block[]{BOPBlocks.DEAD_LEAVES, BOPBlocks.DESERT_GRASS});
        event.register((state, world, pos, tintIndex) -> {
            if (tintIndex != 0) {
                return world != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.getDefaultColor();
            }
            return -1;
        }, (Object[])new Block[]{BOPBlocks.WHITE_PETALS, BOPBlocks.PURPLE_WILDFLOWERS});
        event.register((state, world, pos, tintIndex) -> world != null && pos != null ? 2129968 : 7455580, (Object[])new Block[]{BOPBlocks.HUGE_LILY_PAD});
    }

    public static void registerParticleSprites(RegisterParticleSpritesEvent event) {
        event.registerSpriteSet((ParticleType)ModParticles.DRIPPING_BLOOD, DripParticleBOP.BloodHangProvider::new);
        event.registerSpriteSet((ParticleType)ModParticles.FALLING_BLOOD, DripParticleBOP.BloodFallProvider::new);
        event.registerSpriteSet((ParticleType)ModParticles.LANDING_BLOOD, DripParticleBOP.BloodLandProvider::new);
        event.registerSpriteSet((ParticleType)ModParticles.PUS, PusParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.GLOWWORM, GlowwormParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.STEAM, SteamParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.END_SPORE, EndSporeParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.WISP_BUBBLE, WispBubbleParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.NULL, NullParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.BINARY, BinaryParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.JACARANDA_LEAVES, p_277215_ -> (p_277217_, p_277218_, p_277219_, p_277220_, p_277221_, p_277222_, p_277223_, p_277224_) -> new LeafParticle(p_277218_, p_277219_, p_277220_, p_277221_, p_277215_));
        event.registerSpriteSet((ParticleType)ModParticles.SNOWBLOSSOM_LEAVES, p_277215_ -> (p_277217_, p_277218_, p_277219_, p_277220_, p_277221_, p_277222_, p_277223_, p_277224_) -> new LeafParticle(p_277218_, p_277219_, p_277220_, p_277221_, p_277215_));
        event.registerSpriteSet((ParticleType)ModParticles.RED_MAPLE_LEAVES, p_277215_ -> (p_277217_, p_277218_, p_277219_, p_277220_, p_277221_, p_277222_, p_277223_, p_277224_) -> new LargeLeafParticle(p_277218_, p_277219_, p_277220_, p_277221_, p_277215_));
        event.registerSpriteSet((ParticleType)ModParticles.ORANGE_MAPLE_LEAVES, p_277215_ -> (p_277217_, p_277218_, p_277219_, p_277220_, p_277221_, p_277222_, p_277223_, p_277224_) -> new LargeLeafParticle(p_277218_, p_277219_, p_277220_, p_277221_, p_277215_));
        event.registerSpriteSet((ParticleType)ModParticles.YELLOW_MAPLE_LEAVES, p_277215_ -> (p_277217_, p_277218_, p_277219_, p_277220_, p_277221_, p_277222_, p_277223_, p_277224_) -> new LargeLeafParticle(p_277218_, p_277219_, p_277220_, p_277221_, p_277215_));
        event.registerSpriteSet((ParticleType)ModParticles.FIR_LEAVES, p_277215_ -> (p_277217_, p_277218_, p_277219_, p_277220_, p_277221_, p_277222_, p_277223_, p_277224_) -> new NormalLeafParticle(p_277218_, p_277219_, p_277220_, p_277221_, p_277215_));
        event.registerSpriteSet((ParticleType)ModParticles.REDWOOD_LEAVES, p_277215_ -> (p_277217_, p_277218_, p_277219_, p_277220_, p_277221_, p_277222_, p_277223_, p_277224_) -> new NormalLeafParticle(p_277218_, p_277219_, p_277220_, p_277221_, p_277215_));
        event.registerSpriteSet((ParticleType)ModParticles.CYPRESS_LEAVES, p_277215_ -> (p_277217_, p_277218_, p_277219_, p_277220_, p_277221_, p_277222_, p_277223_, p_277224_) -> new NormalLeafParticle(p_277218_, p_277219_, p_277220_, p_277221_, p_277215_));
        event.registerSpriteSet((ParticleType)ModParticles.MAGIC_LEAVES, p_277215_ -> (p_277217_, p_277218_, p_277219_, p_277220_, p_277221_, p_277222_, p_277223_, p_277224_) -> new NormalLeafParticle(p_277218_, p_277219_, p_277220_, p_277221_, p_277215_));
        event.registerSpriteSet((ParticleType)ModParticles.UMBRAN_LEAVES, p_277215_ -> (p_277217_, p_277218_, p_277219_, p_277220_, p_277221_, p_277222_, p_277223_, p_277224_) -> new NormalLeafParticle(p_277218_, p_277219_, p_277220_, p_277221_, p_277215_));
        event.registerSpriteSet((ParticleType)ModParticles.HELLBARK_LEAVES, p_277215_ -> (p_277217_, p_277218_, p_277219_, p_277220_, p_277221_, p_277222_, p_277223_, p_277224_) -> new NormalLeafParticle(p_277218_, p_277219_, p_277220_, p_277221_, p_277215_));
    }

    public static void registerWoodTypes() {
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.ORIGIN_OAK);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.FIR);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.PINE);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.MAPLE);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.REDWOOD);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.MAHOGANY);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.JACARANDA);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.PALM);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.WILLOW);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.DEAD);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.MAGIC);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.UMBRAN);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.HELLBARK);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.EMPYREAL);
    }
}

