/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.client.renderer;

import biomesoplenty.block.AnomalyBlock;
import biomesoplenty.block.entity.AnomalyBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class AnomalyRenderer
implements BlockEntityRenderer<AnomalyBlockEntity> {
    private final BlockRenderDispatcher dispatcher;

    public AnomalyRenderer(BlockEntityRendererProvider.Context context) {
        this.dispatcher = context.getBlockRenderDispatcher();
    }

    public void render(AnomalyBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, Vec3 vec3) {
        if (blockEntity.getBlockState().getValue(AnomalyBlock.ANOMALY_TYPE) == AnomalyBlock.AnomalyType.STABLE) {
            return;
        }
        Level level = blockEntity.getLevel();
        BlockPos pos = blockEntity.getBlockPos();
        BlockState renderState = blockEntity.getRenderState();
        try {
            List parts = this.dispatcher.getBlockModel(renderState).collectParts(RandomSource.create((long)renderState.getSeed(pos)));
            this.dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, parts, renderState, pos, poseStack, buffer.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)renderState)), false, OverlayTexture.NO_OVERLAY);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getViewDistance() {
        return 32;
    }
}

