/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.worldgen.feature.BOPCaveFeatures;
import biomesoplenty.worldgen.feature.BOPVegetationFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;

public class MushroomBlockBOP
extends MushroomBlock
implements BonemealableBlock {
    public MushroomBlockBOP(BlockBehaviour.Properties properties) {
        super(null, properties);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.below();
        BlockState ground = level.getBlockState(below);
        return ground.is(BlockTags.MUSHROOM_GROW_BLOCK) || this.mayPlaceOn(ground, (BlockGetter)level, below);
    }

    public boolean growMushroom(ServerLevel level, BlockPos p_226940_2_, BlockState p_226940_3_, RandomSource p_226940_4_) {
        ConfiguredFeature feature;
        level.removeBlock(p_226940_2_, false);
        Registry configuredFeatureRegistry = level.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE);
        if (this == BOPBlocks.GLOWSHROOM) {
            feature = (ConfiguredFeature)((Holder.Reference)configuredFeatureRegistry.get(BOPCaveFeatures.HUGE_GLOWSHROOM_CAVE).orElseThrow()).value();
        } else {
            if (this != BOPBlocks.TOADSTOOL) {
                level.setBlock(p_226940_2_, p_226940_3_, 3);
                return false;
            }
            feature = (ConfiguredFeature)((Holder.Reference)configuredFeatureRegistry.get(BOPVegetationFeatures.HUGE_TOADSTOOL).orElseThrow()).value();
        }
        if (feature.place((WorldGenLevel)level, level.getChunkSource().getGenerator(), p_226940_4_, p_226940_2_)) {
            return true;
        }
        level.setBlock(p_226940_2_, p_226940_3_, 3);
        return false;
    }

    public boolean isValidBonemealTarget(LevelReader worldIn, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return (double)rand.nextFloat() < 0.4;
    }

    public void performBonemeal(ServerLevel p_225535_1_, RandomSource p_225535_2_, BlockPos p_225535_3_, BlockState p_225535_4_) {
        this.growMushroom(p_225535_1_, p_225535_3_, p_225535_4_, p_225535_2_);
    }
}

