/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BOPFluids;
import biomesoplenty.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class FleshBlock
extends Block {
    public FleshBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void stepOn(Level worldIn, BlockPos pos, BlockState blockState, Entity entityIn) {
        entityIn.setDeltaMovement(entityIn.getDeltaMovement().multiply(0.95, 1.0, 0.95));
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource p_221787_) {
        boolean bloodAdjacent = false;
        for (Direction direction : Direction.values()) {
            if (!worldIn.getFluidState(pos.relative(direction)).is(BOPFluids.BLOOD)) continue;
            bloodAdjacent = true;
        }
        if (bloodAdjacent && p_221787_.nextInt(15) == 0) {
            switch (p_221787_.nextInt(4)) {
                default: {
                    if (!worldIn.isEmptyBlock(pos.above())) break;
                    worldIn.setBlock(pos.above(), BOPBlocks.HAIR.defaultBlockState(), 2);
                    break;
                }
                case 1: {
                    if (!worldIn.isEmptyBlock(pos.above())) break;
                    worldIn.setBlock(pos.above(), BOPBlocks.PUS_BUBBLE.defaultBlockState(), 2);
                    break;
                }
                case 2: {
                    if (!worldIn.isEmptyBlock(pos.above()) || !worldIn.isEmptyBlock(pos.above(2))) break;
                    DoublePlantBlock.placeAt((LevelAccessor)worldIn, (BlockState)BOPBlocks.EYEBULB.defaultBlockState(), (BlockPos)pos.above(), (int)2);
                    break;
                }
                case 3: {
                    if (!worldIn.isEmptyBlock(pos.below())) break;
                    worldIn.setBlock(pos.below(), BOPBlocks.FLESH_TENDONS.defaultBlockState(), 2);
                }
            }
        }
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(ModTags.Items.SHEARS) && state.getBlock() == BOPBlocks.FLESH) {
            if (!level.isClientSide) {
                Direction direction = hitResult.getDirection();
                Direction direction1 = direction.getAxis() == Direction.Axis.Y ? player.getDirection().getOpposite() : direction;
                level.playSound((Entity)((Player)null), pos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlock(pos, BOPBlocks.POROUS_FLESH.defaultBlockState(), 11);
                ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5 + (double)direction1.getStepX() * 0.65, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5 + (double)direction1.getStepZ() * 0.65, new ItemStack((ItemLike)Items.ROTTEN_FLESH, 1));
                itementity.setDeltaMovement(0.05 * (double)direction1.getStepX() + level.random.nextDouble() * 0.02, 0.05, 0.05 * (double)direction1.getStepZ() + level.random.nextDouble() * 0.02);
                level.addFreshEntity((Entity)itementity);
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                level.gameEvent((Entity)player, (Holder)GameEvent.SHEAR, pos);
                player.awardStat(Stats.ITEM_USED.get((Object)Items.SHEARS));
            }
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

