/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.components.item;

import com.google.common.collect.Lists;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class KeyringContents
implements TooltipComponent {
    public static final KeyringContents EMPTY = new KeyringContents(List.of());
    public static final Codec<KeyringContents> CODEC = ItemStack.CODEC.listOf().xmap(KeyringContents::new, kc -> kc.items);
    public static final StreamCodec<RegistryFriendlyByteBuf, KeyringContents> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(KeyringContents::new, kc -> kc.items);
    private static final int NO_STACK_INDEX = -1;
    public static final int NO_SELECTED_ITEM_INDEX = -1;
    final List<ItemStack> items;
    final int selectedItem;

    public KeyringContents(List<ItemStack> items, int selectedItem) {
        this.items = items;
        this.selectedItem = selectedItem;
    }

    public KeyringContents(List<ItemStack> items) {
        this(items, -1);
    }

    public ItemStack getItemUnsafe(int index) {
        return this.items.get(index);
    }

    public Stream<ItemStack> itemCopyStream() {
        return this.items.stream().map(ItemStack::copy);
    }

    public Iterable<ItemStack> items() {
        return this.items;
    }

    public Iterable<ItemStack> itemsCopy() {
        return Lists.transform(this.items, ItemStack::copy);
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int getSelectedItem() {
        return this.selectedItem;
    }

    public boolean hasSelectedItem() {
        return this.selectedItem != -1;
    }

    public int getMaxShowSize() {
        return 16;
    }

    public int getShowRowSize() {
        return 4;
    }

    public int getNumberOfItemsToShow() {
        int count = this.size();
        int maxShowCount = this.getMaxShowSize();
        int rowSize = this.getShowRowSize();
        int adjCount = count > maxShowCount ? maxShowCount - 1 : maxShowCount;
        int remainder = count % rowSize;
        int filled = remainder == 0 ? 0 : rowSize - remainder;
        return Math.min(count, adjCount - filled);
    }

    public boolean equals(Object obj) {
        boolean bl;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KeyringContents)) {
            bl = false;
        } else {
            KeyringContents contents = (KeyringContents)obj;
            bl = ItemStack.listMatches(this.items, contents.items);
        }
        return bl;
    }

    public int hashCode() {
        return ItemStack.hashStackList(this.items);
    }

    public String toString() {
        return "KeyringContents" + String.valueOf(this.items);
    }

    public static class Mutable {
        private final List<ItemStack> items;
        private int selectedItem;

        public Mutable(KeyringContents contents) {
            this.items = new ArrayList<ItemStack>(contents.items);
            this.selectedItem = contents.selectedItem;
        }

        public int size() {
            return this.items.size();
        }

        public Mutable clearItems() {
            this.items.clear();
            this.selectedItem = -1;
            return this;
        }

        private int findStackIndex(ItemStack stack) {
            for (int i = 0; i < this.items.size(); ++i) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)this.items.get(i), (ItemStack)stack)) continue;
                return i;
            }
            return -1;
        }

        private int getMaxAmountToAdd(ItemStack stack) {
            return 1;
        }

        public int tryInsert(ItemStack stack) {
            if (stack.isEmpty() || !(stack.getItem() instanceof ItemKey)) {
                return 0;
            }
            int toAdd = Math.min(stack.getCount(), this.getMaxAmountToAdd(stack));
            if (toAdd == 0) {
                return 0;
            }
            int index = this.findStackIndex(stack);
            if (index >= 0) {
                return 0;
            }
            this.items.add(0, stack.split(toAdd));
            return toAdd;
        }

        public int tryTransfer(Slot slot, Player player) {
            ItemStack stack = slot.getItem();
            int toAdd = this.getMaxAmountToAdd(stack);
            return this.tryInsert(slot.safeTake(stack.getCount(), toAdd, player));
        }

        public void toggleSelectedItem(int index) {
            this.selectedItem = this.selectedItem != index && !this.indexIsOutsideAllowedBounds(index) ? index : -1;
        }

        private boolean indexIsOutsideAllowedBounds(int index) {
            return index < 0 || index >= this.items.size();
        }

        @Nullable
        public ItemStack removeOne() {
            if (this.items.isEmpty()) {
                return null;
            }
            return this.items.remove(0).copy();
        }

        public KeyringContents toImmutable() {
            return new KeyringContents(List.copyOf(this.items));
        }
    }
}

