/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.block.BlockFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.EnumFramingTablePart;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BlockEntityFramingRenderer
implements BlockEntityRenderer<BlockEntityFramingTable> {
    private final BlockEntityRendererProvider.Context context;
    private final ItemStackRenderState itemRenderState = new ItemStackRenderState();

    public BlockEntityFramingRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(@NotNull BlockEntityFramingTable blockEntityTable, float partialTickTime, @NotNull PoseStack matrix, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 camPosition) {
        BlockItem blockItem;
        Block targetBlock;
        Level level = blockEntityTable.getLevel();
        if (level == null) {
            return;
        }
        BlockState state = blockEntityTable.getBlockState();
        if (!(state.getBlock() instanceof BlockFramingTable)) {
            return;
        }
        if (state.getValue(BlockFramingTable.PART) != EnumFramingTablePart.RIGHT) {
            return;
        }
        MaterialData matData = blockEntityTable.material();
        if (matData == null) {
            return;
        }
        this.renderSlot(blockEntityTable, matData.getSide(), matrix, buffer, combinedLight, combinedOverlay, 1.0f, 1.15f, 0.15f, -0.275f);
        this.renderSlot(blockEntityTable, matData.getTrim(), matrix, buffer, combinedLight, combinedOverlay, 1.0f, -0.14999998f, 0.15f, -0.275f);
        this.renderSlot(blockEntityTable, matData.getFront(), matrix, buffer, combinedLight, combinedOverlay, 1.0f, 1.15f, 0.15f, -0.725f);
        if (matData.getEffectiveSide().isEmpty()) {
            return;
        }
        ItemStack target = blockEntityTable.inventory().getItem(0);
        if (target == null || target.isEmpty()) {
            return;
        }
        Item item = target.getItem();
        if (item instanceof BlockItem && (targetBlock = (blockItem = (BlockItem)item).getBlock()) instanceof IFramedSourceBlock) {
            IFramedSourceBlock fsb = (IFramedSourceBlock)targetBlock;
            ItemStack result = fsb.makeFramedItem(target, matData.getEffectiveSide(), matData.getEffectiveTrim(), matData.getEffectiveFront());
            this.renderSlot(blockEntityTable, result, matrix, buffer, combinedLight, combinedOverlay, 1.6f, 0.5f, 0.1f, -0.5f);
        }
    }

    private void renderSlot(BlockEntityFramingTable blockEntityTable, ItemStack item, PoseStack matrix, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay, float scale, float tx, float ty, float tz) {
        if (item == null) {
            return;
        }
        Block itemBlock = Block.byItem((Item)item.getItem());
        if (itemBlock == Blocks.AIR) {
            return;
        }
        Direction facing = (Direction)blockEntityTable.getBlockState().getValue((Property)BlockFramingTable.FACING);
        matrix.pushPose();
        switch (facing) {
            case NORTH: {
                matrix.mulPose((Matrix4fc)new Matrix4f().rotateY((float)Math.toRadians(180.0)));
                break;
            }
            case EAST: {
                matrix.mulPose((Matrix4fc)new Matrix4f().rotateY((float)Math.toRadians(90.0)));
                break;
            }
            case WEST: {
                matrix.mulPose((Matrix4fc)new Matrix4f().rotateY((float)Math.toRadians(270.0)));
                break;
            }
            case SOUTH: {
                matrix.mulPose((Matrix4fc)new Matrix4f().rotateY((float)Math.toRadians(0.0)));
            }
        }
        switch (facing) {
            case NORTH: {
                matrix.translate(-0.5f, 0.8f, 0.0f);
                break;
            }
            case EAST: {
                matrix.translate(-0.5f, 0.8f, 1.0f);
                break;
            }
            case WEST: {
                matrix.translate(0.5f, 0.8f, 0.0f);
                break;
            }
            case SOUTH: {
                matrix.translate(0.5f, 0.8f, 1.0f);
            }
        }
        matrix.translate(tx, ty, tz);
        matrix.mulPose((Matrix4fc)new Matrix4f().scale(scale, scale, scale));
        try {
            this.context.getItemModelResolver().updateForTopItem(this.itemRenderState, item, ItemDisplayContext.GROUND, this.context.getBlockEntityRenderDispatcher().level, null, 0);
            this.itemRenderState.render(matrix, buffer, combinedLight, combinedOverlay);
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrix.popPose();
    }

    public AABB getRenderBoundingBox(BlockEntityFramingTable blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 1, 1));
    }
}

