/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.ModConstants;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.config.ModClientConfig;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.util.CountFormatter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BlockEntityDrawersRenderer
implements BlockEntityRenderer<BlockEntityDrawers> {
    private final ItemStack[] renderStacks = new ItemStack[4];
    private ItemRenderer itemRenderer;
    private ItemStackRenderState itemRenderState = new ItemStackRenderState();
    private RandomSource randomSource = RandomSource.create();
    private final BlockEntityRendererProvider.Context context;
    private static final int TEXT_COLOR_TRANSPARENT = ARGB.color((int)0, (int)255, (int)255, (int)255);
    private static final Matrix3f ITEM_LIGHT_ROTATION_3D = new Matrix3f().rotationYXZ(0.36f, -0.36f, -0.014f);
    private static final float[] sideRotationY2D = new float[]{0.0f, 0.0f, 2.0f, 0.0f, 3.0f, 1.0f};
    public static final ResourceLocation TEXTURE_IND_1 = ModConstants.loc("block/indicator/indicator_1_on");
    public static final ResourceLocation TEXTURE_IND_2 = ModConstants.loc("block/indicator/indicator_2_on");
    public static final ResourceLocation TEXTURE_IND_4 = ModConstants.loc("block/indicator/indicator_4_on");
    public static final ResourceLocation TEXTURE_IND_COMP_3 = ModConstants.loc("block/indicator/indicator_comp_on");
    public static final ResourceLocation TEXTURE_IND_COMP_2 = ModConstants.loc("block/indicator/indicator_comp2_on");

    public BlockEntityDrawersRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(@NotNull BlockEntityDrawers blockEntityDrawers, float partialTickTime, @NotNull PoseStack matrix, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 camPosition) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Level level = blockEntityDrawers.getLevel();
        if (level == null) {
            return;
        }
        BlockState state = blockEntityDrawers.getBlockState();
        if (!(state.getBlock() instanceof BlockDrawers)) {
            return;
        }
        Direction side = (Direction)state.getValue((Property)BlockDrawers.FACING);
        if (this.playerBehindBlock(blockEntityDrawers.getBlockPos(), side)) {
            return;
        }
        float distance = (float)Math.sqrt(blockEntityDrawers.getBlockPos().distToCenterSqr((Position)player.position()));
        double renderDistance = (Double)ModClientConfig.INSTANCE.RENDER.labelRenderDistance.get();
        if (renderDistance > 0.0 && (double)distance > renderDistance) {
            return;
        }
        this.itemRenderer = Minecraft.getInstance().getItemRenderer();
        int enforcedLightLevel = blockEntityDrawers.upgrades().hasIlluminationUpgrade() ? (Integer)ModCommonConfig.INSTANCE.UPGRADES.illuminationUpgrade.illuminationLevel.get() : (Integer)ModCommonConfig.INSTANCE.UPGRADES.illuminationUpgrade.minIlluminationLevel.get();
        int blockLight = Math.max(combinedLight % 65536, enforcedLightLevel * 16);
        combinedLight = combinedLight & 0xFFFF0000 | blockLight;
        if (!blockEntityDrawers.getDrawerAttributes().isConcealed()) {
            this.renderFastItemSet(blockEntityDrawers, state, matrix, buffer, combinedLight, combinedOverlay, side, partialTickTime, distance);
        }
        if (blockEntityDrawers.getDrawerAttributes().hasFillLevel()) {
            this.renderIndicator((BlockDrawers)state.getBlock(), blockEntityDrawers, matrix, buffer, (Direction)state.getValue((Property)BlockDrawers.FACING), combinedLight, combinedOverlay);
        }
    }

    private boolean playerBehindBlock(BlockPos blockPos, Direction facing) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        BlockPos playerPos = player.blockPosition();
        return switch (facing) {
            case Direction.NORTH -> {
                if (playerPos.getZ() > blockPos.getZ()) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (playerPos.getZ() < blockPos.getZ()) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (playerPos.getX() > blockPos.getX()) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (playerPos.getX() < blockPos.getX()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private void renderFastItemSet(BlockEntityDrawers blockEntityDrawers, BlockState state, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Direction side, float partialTickTime, float distance) {
        int i;
        int drawerCount = blockEntityDrawers.getGroup().getDrawerCount();
        for (i = 0; i < drawerCount; ++i) {
            ItemStack itemStack;
            this.renderStacks[i] = ItemStack.EMPTY;
            IDrawer drawer = blockEntityDrawers.getGroup().getDrawer(i);
            if (!drawer.isEnabled() || drawer.isEmpty()) continue;
            this.renderStacks[i] = itemStack = drawer.getStoredItemPrototype();
        }
        for (i = 0; i < drawerCount; ++i) {
            ItemStack itemStack = this.renderStacks[i];
            if (itemStack.isEmpty()) continue;
            this.renderFastItem(itemStack, state, i, matrix, buffer, combinedLight, combinedOverlay, side);
        }
        if (blockEntityDrawers.getDrawerAttributes().isShowingQuantity()) {
            double renderDistance;
            float alpha = 1.0f;
            double fadeDistance = (Double)ModClientConfig.INSTANCE.RENDER.quantityFadeDistance.get();
            if (fadeDistance == 0.0 || (double)distance > fadeDistance) {
                alpha = Math.max(1.0f - (distance - 4.0f) / 6.0f, 0.05f);
            }
            if ((renderDistance = ((Double)ModClientConfig.INSTANCE.RENDER.quantityRenderDistance.get()).doubleValue()) == 0.0 || (double)distance < renderDistance) {
                for (int i2 = 0; i2 < drawerCount; ++i2) {
                    String format = CountFormatter.format(this.context.getFont(), blockEntityDrawers.getGroup().getDrawer(i2));
                    this.renderText(format, state, i2, matrix, buffer, combinedLight, side, alpha);
                }
            }
        }
    }

    private void renderText(String text, BlockState state, int slot, PoseStack matrix, MultiBufferSource buffer, int combinedLight, Direction side, float alpha) {
        if (text == null || text.isEmpty()) {
            return;
        }
        Font fontRenderer = this.context.getFont();
        BlockDrawers block = (BlockDrawers)state.getBlock();
        AABB labelGeometry = block.countGeometry[slot];
        int textWidth = fontRenderer.width(text);
        float x = (float)(labelGeometry.minX + labelGeometry.getXsize() / 2.0);
        float y = 16.0f - (float)labelGeometry.minY - (float)labelGeometry.getYsize();
        float z = (float)labelGeometry.minZ * 0.0625f - 0.01f;
        matrix.pushPose();
        this.alignRendering(matrix, side);
        matrix.translate(x / 16.0f, 1.0f - y / 16.0f, 1.0f - z);
        matrix.scale(0.0078125f, -0.0078125f, 1.0f);
        int color = (int)(255.0f * alpha) << 24 | TEXT_COLOR_TRANSPARENT;
        fontRenderer.drawInBatch(text, (float)(-textWidth) / 2.0f, 0.0f, color, false, matrix.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
        matrix.popPose();
    }

    private void renderFastItem(@NotNull ItemStack itemStack, BlockState state, int slot, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Direction side) {
        BlockDrawers block = (BlockDrawers)state.getBlock();
        AABB labelGeometry = block.labelGeometry[slot];
        float scaleX = (float)labelGeometry.getXsize() / 16.0f;
        float scaleY = (float)labelGeometry.getYsize() / 16.0f;
        float moveX = (float)labelGeometry.minX + 8.0f * scaleX;
        float moveY = 16.0f - (float)labelGeometry.maxY + 8.0f * scaleY;
        float moveZ = (float)labelGeometry.minZ * 0.0625f - 0.0025f;
        matrix.pushPose();
        this.alignRendering(matrix, side);
        matrix.translate(moveX / 16.0f, 1.0f - moveY / 16.0f, 1.0f - moveZ);
        matrix.mulPose((Matrix4fc)new Matrix4f().scale(scaleX, scaleY, 0.001f));
        matrix.last().trustedNormals = true;
        try {
            this.context.getItemModelResolver().updateForTopItem(this.itemRenderState, itemStack, ItemDisplayContext.GUI, this.context.getBlockEntityRenderDispatcher().level, null, 0);
            matrix.last().normal().rotateYXZ(-this.getRotationYForSide2D(side), 0.0f, 0.0f).mul((Matrix3fc)ITEM_LIGHT_ROTATION_3D);
            this.itemRenderState.render(matrix, buffer, combinedLight, combinedOverlay);
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrix.popPose();
    }

    private void alignRendering(PoseStack matrix, Direction side) {
        matrix.translate(0.5f, 0.0f, 0.5f);
        matrix.mulPose((Matrix4fc)new Matrix4f().rotateYXZ(this.getRotationYForSide2D(side), 0.0f, 0.0f));
        matrix.translate(-0.5f, 0.0f, -0.5f);
    }

    private float getRotationYForSide2D(Direction side) {
        return sideRotationY2D[side.ordinal()] * 90.0f * (float)Math.PI / 180.0f;
    }

    private void renderIndicator(BlockDrawers block, BlockEntityDrawers blockEntityDrawers, PoseStack matrixStack, MultiBufferSource buffer, Direction side, int combinedLight, int combinedOverlay) {
        int count = blockEntityDrawers instanceof BlockEntityDrawersComp ? 1 : block.getDrawerCount();
        ResourceLocation resource = TEXTURE_IND_1;
        if (blockEntityDrawers instanceof BlockEntityDrawersComp) {
            resource = block.getDrawerCount() == 2 ? TEXTURE_IND_COMP_2 : TEXTURE_IND_COMP_3;
        } else if (count == 2) {
            resource = TEXTURE_IND_2;
        } else if (count == 4) {
            resource = TEXTURE_IND_4;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(resource);
        SpriteContents contents = sprite.contents();
        float u1 = sprite.getU0();
        float u2 = sprite.getU1();
        float v1 = sprite.getV0();
        float v2 = sprite.getV1();
        float pxW = contents.width();
        float pxH = contents.height();
        float unit = 0.0625f;
        float divU = unit * (u2 - u1);
        float divV = unit * (v2 - v1);
        matrixStack.pushPose();
        this.alignRendering(matrixStack, side);
        for (int i = 0; i < count; ++i) {
            IDrawer drawer = blockEntityDrawers.getGroup().getDrawer(i);
            if (drawer == Drawers.DISABLED || blockEntityDrawers.getDrawerAttributes().isConcealed()) continue;
            AABB bb = block.indGeometry[i];
            AABB bbbase = block.indBaseGeometry[i];
            float x1 = unit * (float)bb.minX;
            float x2 = unit * (float)bb.maxX;
            float xb2 = unit * (float)bbbase.maxX;
            float y1 = unit * (float)bb.minY;
            float y2 = unit * (float)bb.maxY;
            float yb2 = unit * (float)bbbase.maxY;
            float z = 1.0f - unit * (float)bb.minZ;
            float su1 = u1 + (float)bb.minX * divU;
            float su2 = u1 + (float)bb.maxX * divU;
            float sv1 = v2 - (float)bb.minY * divV;
            float sv2 = v2 - (float)bb.maxY * divV;
            int stepX = (int)((x2 - xb2) * pxW);
            int stepY = (int)((y2 - yb2) * pxH);
            float xCur = stepX == 0 ? x2 : this.getIndEnd(blockEntityDrawers, i, x1, x2 - xb2, stepX);
            float xFrac = x2 == xb2 ? 1.0f : (xCur - x1) / (x2 - xb2);
            float uCur = su1 + xFrac * (su2 - su1);
            float yCur = stepY == 0 ? y2 : this.getIndEnd(blockEntityDrawers, i, y1, y2 - yb2, stepY);
            float yFrac = y2 == yb2 ? 1.0f : (yCur - y1) / (y2 - yb2);
            float vCur = sv1 + yFrac * (sv2 - sv1);
            if (!(xCur > x1) || !(yCur > y1)) continue;
            Matrix4f matrix = matrixStack.last().pose();
            VertexConsumer builder = buffer.getBuffer(RenderType.solid());
            BlockEntityDrawersRenderer.addQuad(matrix, matrixStack.last(), builder, combinedLight, combinedOverlay, x1, xCur, y1, yCur, z, uCur, su1, sv1, vCur);
        }
        matrixStack.popPose();
    }

    public static void addQuad(Matrix4f matrix, PoseStack.Pose normal, VertexConsumer buffer, int combinedLight, int combinedOverlay, float x1, float x2, float y1, float y2, float z, float u1, float u2, float v1, float v2) {
        BlockEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x2, y1, z, u1, v1);
        BlockEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x2, y2, z, u1, v2);
        BlockEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x1, y2, z, u2, v2);
        BlockEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x1, y1, z, u2, v1);
    }

    private static void addVertex(Matrix4f matrix, PoseStack.Pose normal, VertexConsumer buffer, int combinedLight, int combinedOverlay, float x, float y, float z, float u, float v) {
        buffer.addVertex(matrix, x, y, z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u, v).setOverlay(combinedOverlay).setLight(combinedLight).setNormal(normal, 0.0f, 1.0f, 0.0f);
    }

    private float getIndEnd(BlockEntityDrawers blockEntityDrawers, int slot, float x, float w, int step) {
        IDrawer drawer = blockEntityDrawers.getGroup().getDrawer(slot);
        if (drawer == Drawers.DISABLED) {
            return x;
        }
        int cap = drawer.getMaxCapacity();
        int count = drawer.getStoredItemCount();
        if (cap == 0 || count == 0) {
            return x;
        }
        float fillAmt = (float)(step * count / cap) / (float)step;
        return x + w * fillAmt;
    }
}

