/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.google.common.base.Suppliers;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.DrawerModelProperties;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.FramedModelProperties;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.RenderDataProvider;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.client.model.ItemModelStore;
import com.jaquadro.minecraft.storagedrawers.client.model.ModelContextSupplier;
import com.jaquadro.minecraft.storagedrawers.client.model.ParentModel;
import com.jaquadro.minecraft.storagedrawers.client.model.context.ModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.ModelDecorator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.DynamicBlockStateModel;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class PlatformDecoratedModel<C extends ModelContext>
extends ParentModel
implements DynamicBlockStateModel {
    private final ModelDecorator<C> decorator;
    private final ModelContextSupplier<C> contextSupplier;

    public PlatformDecoratedModel(BlockStateModel parent, ModelDecorator<C> decorator, ModelContextSupplier<C> contextSupplier) {
        super(parent);
        this.decorator = decorator;
        this.contextSupplier = contextSupplier;
    }

    public void collectParts(BlockAndTintGetter level, BlockPos blockPos, BlockState state, RandomSource randomSource, List<BlockModelPart> list) {
        BlockEntity entity = level.getBlockEntity(blockPos);
        if (entity instanceof RenderDataProvider) {
            RenderDataProvider renderProvider = (RenderDataProvider)entity;
            Object renderData = renderProvider.getRenderData();
            Supplier<ModelContext> supplier = () -> this.contextSupplier.makeContext(state, randomSource, renderData);
            if (this.decorator.shouldRenderBase(supplier)) {
                this.parent.collectParts(level, blockPos, state, randomSource, list);
            }
            Consumer<BlockStateModel> emitModel = model -> {
                if (model != null) {
                    model.collectParts(level, blockPos, state, randomSource, list);
                }
            };
            try {
                this.decorator.emitQuads(supplier, emitModel);
            }
            catch (Exception exception) {}
        } else {
            this.parent.collectParts(level, blockPos, state, randomSource, list);
        }
    }

    public TextureAtlasSprite particleIcon(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof RenderDataProvider) {
            Item item;
            ItemStack side;
            RenderDataProvider renderProvider = (RenderDataProvider)entity;
            Object renderData = renderProvider.getRenderData();
            MaterialData matData = null;
            if (renderData instanceof DrawerModelProperties) {
                DrawerModelProperties drawerProps = (DrawerModelProperties)renderData;
                matData = new MaterialData(drawerProps.material);
            } else if (renderData instanceof FramedModelProperties) {
                FramedModelProperties frameProps = (FramedModelProperties)renderData;
                matData = new MaterialData(frameProps.material);
            }
            if (matData != null && (side = matData.getEffectiveSide()) != ItemStack.EMPTY && (item = side.getItem()) instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                BlockStateModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(blockItem.getBlock().defaultBlockState());
                return model.particleIcon();
            }
        }
        return super.particleIcon(level, pos, state);
    }

    public static class ItemRender<C extends ModelContext>
    extends ParentModel {
        PlatformDecoratedModel<C> parent;
        private ItemStack stack;

        public ItemRender(PlatformDecoratedModel<C> parent, ItemStack stack) {
            super(parent);
            this.parent = parent;
            this.stack = stack;
        }

        @Override
        public void collectParts(RandomSource randomSource, List<BlockModelPart> list) {
            ModelDecorator<ModelContext> decorator = this.parent.decorator;
            Supplier<ModelContext> supplier = () -> this.parent.contextSupplier.makeContext(this.stack);
            if (decorator.shouldRenderBase(supplier, this.stack)) {
                this.parent.collectParts(randomSource, list);
            }
            Consumer<BlockStateModel> emitModel = model -> {
                if (model != null) {
                    model.collectParts(randomSource, list);
                }
            };
            try {
                decorator.emitItemQuads(supplier, emitModel, this.stack);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class PlatformDecoratedItemModel
    implements ItemModel {
        private final ResourceLocation location;
        private final String variant;
        private final ModelRenderProperties properties;
        private final Supplier<Vector3f[]> extents;
        private final Map<MaterialData, BlockStateModel> modelCache = new HashMap<MaterialData, BlockStateModel>();
        PlatformDecoratedModel<?> parent;
        BlockStateModel model;
        ItemStack stack;
        BlockState state;

        public PlatformDecoratedItemModel(ResourceLocation location, String variant, ModelRenderProperties properties) {
            this.location = location;
            this.variant = variant;
            this.properties = properties;
            this.extents = Suppliers.memoize(() -> {
                Vector3f[] ext = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)};
                return ext;
            });
        }

        public void update(ItemStackRenderState itemStackRenderState, ItemStack itemStack, ItemModelResolver itemModelResolver, ItemDisplayContext itemDisplayContext, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i) {
            BlockStateModel stored;
            itemStackRenderState.appendModelIdentityElement((Object)this);
            itemStackRenderState.appendModelIdentityElement((Object)itemStack);
            if (this.state == null) {
                String[] props;
                Optional blockOption = BuiltInRegistries.BLOCK.get(this.location);
                if (blockOption.isEmpty()) {
                    return;
                }
                Block block = (Block)((Holder.Reference)blockOption.get()).value();
                this.state = block.defaultBlockState();
                for (String prop : props = this.variant.split(",")) {
                    String[] keyVal = prop.split("=");
                    if (keyVal.length != 2) continue;
                    String key = keyVal[0].trim();
                    String value = keyVal[1].trim();
                    Property property = this.state.getBlock().getStateDefinition().getProperty(key);
                    if (property == null) continue;
                    this.state = PlatformDecoratedItemModel.setProperty(this.state, property, value);
                }
            }
            if (this.parent == null && (stored = ItemModelStore.models.get(this.state)) instanceof PlatformDecoratedModel) {
                PlatformDecoratedModel p;
                this.parent = p = (PlatformDecoratedModel)stored;
            }
            if (!(this.stack != null && ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)itemStack) || this.parent == null)) {
                this.stack = itemStack.transmuteCopy((ItemLike)itemStack.getItem());
                this.model = new ItemRender(this.parent, this.stack);
            }
            if (this.model != null) {
                ArrayList parts = new ArrayList();
                this.model.collectParts(null, parts);
                HashMap<ChunkSectionLayer, ItemStackRenderState.LayerRenderState> layers = new HashMap<ChunkSectionLayer, ItemStackRenderState.LayerRenderState>();
                for (BlockModelPart part : parts) {
                    ChunkSectionLayer partType = part.getRenderType(this.state);
                    if (!layers.containsKey(partType)) {
                        ItemStackRenderState.LayerRenderState renderState = itemStackRenderState.newLayer();
                        layers.put(partType, renderState);
                        RenderType itemRenderType = null;
                        if (partType == ChunkSectionLayer.SOLID) {
                            itemRenderType = Sheets.solidBlockSheet();
                        }
                        if (partType == ChunkSectionLayer.CUTOUT_MIPPED || partType == ChunkSectionLayer.CUTOUT) {
                            itemRenderType = Sheets.cutoutBlockSheet();
                        } else if (partType == ChunkSectionLayer.TRANSLUCENT) {
                            itemRenderType = Sheets.translucentItemSheet();
                        }
                        renderState.setRenderType(itemRenderType);
                        renderState.setExtents(this.extents);
                    }
                    ItemStackRenderState.LayerRenderState layer = (ItemStackRenderState.LayerRenderState)layers.get(partType);
                    this.properties.applyToLayer(layer, itemDisplayContext);
                    layer.prepareQuadList().addAll(part.getQuads(null));
                    for (Direction direction : Direction.values()) {
                        layer.prepareQuadList().addAll(part.getQuads(direction));
                    }
                }
            }
        }

        private static <T extends Comparable<T>> BlockState setProperty(BlockState state, Property<T> property, String valueName) {
            Optional parsed = property.getValue(valueName);
            return parsed.map(v -> (BlockState)state.setValue(property, v)).orElse(state);
        }

        public record Unbaked(ResourceLocation model, String variant) implements ItemModel.Unbaked
        {
            public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("model").forGetter(Unbaked::model), (App)Codec.STRING.fieldOf("variant").forGetter(Unbaked::variant)).apply((Applicative)builder, Unbaked::new));

            public MapCodec<? extends ItemModel.Unbaked> type() {
                return MAP_CODEC;
            }

            public ItemModel bake(ItemModel.BakingContext bakingContext) {
                ModelBaker modelbaker = bakingContext.blockModelBaker();
                ResolvedModel resolvedmodel = modelbaker.getModel(ResourceLocation.fromNamespaceAndPath((String)"storagedrawers", (String)"block/oak_full_drawers_2"));
                TextureSlots textureslots = resolvedmodel.getTopTextureSlots();
                ModelRenderProperties modelrenderproperties = ModelRenderProperties.fromResolvedModel((ModelBaker)modelbaker, (ResolvedModel)resolvedmodel, (TextureSlots)textureslots);
                return new PlatformDecoratedItemModel(this.model, this.variant, modelrenderproperties);
            }

            public void resolveDependencies(ResolvableModel.Resolver resolver) {
            }
        }
    }
}

