/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMeta;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaFacingSized;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaFacingSizedOpen;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaFacingSizedSlotted;
import com.jaquadro.minecraft.storagedrawers.client.model.SpriteReplacementModel;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DrawerModelStore {
    public static final FrameMatSet FramedStandardDrawerMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_DRAWERS_SIDE).trimPart(DynamicPart.FRAMED_DRAWERS_TRIM).frontPart(DynamicPart.FRAMED_DRAWERS_FRONT).shadeFrontPart(DynamicPart.FRAMED_DRAWERS_SHADING);
    public static final FrameMatSet FramedComp2DrawerMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_COMP2_SIDE).trimPart(DynamicPart.FRAMED_COMP2_TRIM).frontPart(DynamicPart.FRAMED_COMP2_FRONT).shadeFrontPart(DynamicPart.FRAMED_COMP2_SHADING);
    public static final FrameMatSet FramedComp3DrawerMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_COMP3_SIDE).trimPart(DynamicPart.FRAMED_COMP3_TRIM).frontPart(DynamicPart.FRAMED_COMP3_FRONT).shadeFrontPart(DynamicPart.FRAMED_COMP3_SHADING);
    public static final FrameMatSet FramedControllerMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_CONTROLLER_SIDE).trimPart(DynamicPart.FRAMED_CONTROLLER_TRIM).frontPart(DynamicPart.FRAMED_CONTROLLER_FRONT).shadeFrontPart(DynamicPart.FRAMED_CONTROLLER_SHADING);
    public static final FrameMatSet FramedControllerIOMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_CONTROLLER_IO_SIDE).trimPart(DynamicPart.FRAMED_CONTROLLER_IO_TRIM).shadeFrontPart(DynamicPart.FRAMED_CONTROLLER_IO_SHADING);
    public static final FrameMatSet FramedTrimMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_TRIM_SIDE).trimPart(DynamicPart.FRAMED_TRIM_TRIM);
    private static final Map<BlockState, BlockStateModel> modelStore = new HashMap<BlockState, BlockStateModel>();
    private static final Map<BlockState, Map<BlockState, BlockStateModel>> replacementStore = new HashMap<BlockState, Map<BlockState, BlockStateModel>>();
    private static final Set<BlockState> locationStore = new HashSet<BlockState>();
    public static final DecorationSet INSTANCE = new DecorationSet();
    private static final DynamicPart[] missingSlots1 = new DynamicPart[]{DynamicPart.MISSING_1};
    private static final DynamicPart[] missingSlots2 = new DynamicPart[]{DynamicPart.MISSING_1, DynamicPart.MISSING_2};
    private static final DynamicPart[] missingSlots4 = new DynamicPart[]{DynamicPart.MISSING_1, DynamicPart.MISSING_2, DynamicPart.MISSING_3, DynamicPart.MISSING_4};
    public static final DynamicPart[][] missingSlots = new DynamicPart[][]{missingSlots1, missingSlots2, new DynamicPart[0], missingSlots4};

    static BlockState addLocation(BlockState loc) {
        locationStore.add(loc);
        modelStore.put(loc, null);
        return loc;
    }

    static String getVariant() {
        return "";
    }

    static String getVariant(boolean trans) {
        return "trans=" + trans;
    }

    static String getVariant(Direction dir) {
        return "facing=" + dir.getName();
    }

    static String getVariant(Direction dir, boolean half) {
        return "facing=" + dir.getName() + ",half=" + half;
    }

    static String getVariant(Direction dir, boolean half, int slots) {
        return "facing=" + dir.getName() + ",half=" + half + ",slots=" + slots;
    }

    static String getVariant(Direction dir, boolean half, EnumCompDrawer slots) {
        return "facing=" + dir.getName() + ",half=" + half + ",slots=" + String.valueOf(slots);
    }

    static String getSlotVariant(Direction dir, boolean half, int slot) {
        return "facing=" + dir.getName() + ",half=" + half + ",slot=" + slot;
    }

    static String getVariant(DynamicPart part) {
        return "part=" + part.getName();
    }

    static String getVariant(DynamicPart part, boolean trans) {
        return "part=" + part.getName() + ",trans=" + trans;
    }

    static String getVariant(DynamicPart part, Direction dir) {
        return "part=" + part.getName() + ",facing=" + dir.getName();
    }

    static String getVariant(DynamicPart part, Direction dir, boolean half) {
        return "part=" + part.getName() + ",facing=" + dir.getName() + ",half=" + half;
    }

    static String getVariant(DynamicPart part, Direction dir, boolean half, int slots) {
        return "part=" + part.getName() + ",facing=" + dir.getName() + ",half=" + half + ",slots=" + slots;
    }

    static String getVariant(DynamicPart part, Direction dir, boolean half, EnumCompDrawer slots) {
        return "part=" + part.getName() + ",facing=" + dir.getName() + ",half=" + half + ",slots=" + String.valueOf(slots);
    }

    static String getSlotVariant(DynamicPart part, Direction dir, boolean half, int slot) {
        return "part=" + part.getName() + ",facing=" + dir.getName() + ",half=" + half + ",slot=" + slot;
    }

    public static Stream<BlockState> getModelLocations() {
        return locationStore.stream();
    }

    public static void tryAddModel(BlockState loc, BlockStateModel model) {
        if (loc == null) {
            return;
        }
        if (modelStore.containsKey(loc)) {
            modelStore.put(loc, model);
        }
    }

    public static BlockStateModel getModel(BlockState state) {
        if (state == null) {
            return null;
        }
        BlockStateModel storedModel = modelStore.getOrDefault(state, null);
        if (storedModel == null) {
            return Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(state);
        }
        return storedModel;
    }

    public static BlockStateModel getModel(String variant) {
        return DrawerModelStore.getModel(DrawerModelStore.INSTANCE.overlays.getOrDefault(variant, null));
    }

    public static BlockStateModel getModel(DynamicPart part) {
        return DrawerModelStore.getModel(DrawerModelStore.getVariant(part));
    }

    public static BlockStateModel getModel(DynamicPart part, boolean trans) {
        return DrawerModelStore.getModel(DrawerModelStore.getVariant(part, trans));
    }

    public static BlockStateModel getModel(DynamicPart part, Direction dir) {
        return DrawerModelStore.getModel(DrawerModelStore.getVariant(part, dir));
    }

    public static BlockStateModel getModel(DynamicPart part, Direction dir, boolean half) {
        return DrawerModelStore.getModel(DrawerModelStore.getVariant(part, dir, half));
    }

    public static BlockStateModel getModel(DynamicPart part, Direction dir, boolean half, int slots) {
        return DrawerModelStore.getModel(DrawerModelStore.getVariant(part, dir, half, slots));
    }

    public static BlockStateModel getModel(DynamicPart part, Direction dir, boolean half, EnumCompDrawer slots) {
        return DrawerModelStore.getModel(DrawerModelStore.getVariant(part, dir, half, slots));
    }

    public static BlockStateModel getReplacementModel(BlockState loc, BlockState replaceLoc) {
        Map<Object, Object> store;
        if (replacementStore.containsKey(loc)) {
            store = replacementStore.get(loc);
        } else {
            store = new HashMap();
            replacementStore.put(loc, store);
        }
        if (store.containsKey(replaceLoc)) {
            return (BlockStateModel)store.get(replaceLoc);
        }
        BlockStateModel model = DrawerModelStore.getModel(loc);
        BlockStateModel replacementModel = DrawerModelStore.getModel(replaceLoc);
        if (replacementModel == null) {
            return model;
        }
        SpriteReplacementModel merged = new SpriteReplacementModel(model, replacementModel, ChunkSectionLayer.CUTOUT_MIPPED);
        store.put(replaceLoc, merged);
        return merged;
    }

    public static BlockStateModel getReplacementModel(String variant, String replaceVariant) {
        return DrawerModelStore.getReplacementModel(DrawerModelStore.INSTANCE.overlays.getOrDefault(variant, null), DrawerModelStore.INSTANCE.overlays.getOrDefault(replaceVariant, null));
    }

    public static BlockStateModel getReplacementModel(DynamicPart part, Direction dir, boolean half, int slot, DynamicPart iconPart) {
        return DrawerModelStore.getReplacementModel(DrawerModelStore.getSlotVariant(part, dir, half, slot), DrawerModelStore.getVariant(iconPart));
    }

    static {
        INSTANCE.add();
        for (int i = 0; i < 4; ++i) {
            Direction dir = Direction.from2DDataValue((int)i);
            INSTANCE.add(dir, true);
            INSTANCE.add(dir, false);
        }
    }

    public static enum DynamicPart {
        LOCK("lock"),
        CLAIM("claim"),
        LOCK_CLAIM("lock_claim"),
        VOID_ICON("void_icon"),
        SHROUD_ICON("shroud_icon"),
        SUSPEND_ICON("suspend_icon"),
        MAGNET_ICON("magnet_icon"),
        PRIORITY_P1_ICON("priority_p1_icon"),
        PRIORITY_P2_ICON("priority_p2_icon"),
        PRIORITY_N1_ICON("priority_n1_icon"),
        PRIORITY_N2_ICON("priority_n2_icon"),
        INDICATOR("indicator"),
        INDICATOR_COMP("indicator_comp"),
        RIGHT_LABEL("right_label"),
        HOPPER("hopper"),
        MISSING_1("missing_1"),
        MISSING_2("missing_2"),
        MISSING_3("missing_3"),
        MISSING_4("missing_4"),
        FRAMED_DRAWERS_SIDE("framed_drawers_side"),
        FRAMED_DRAWERS_TRIM("framed_drawers_trim"),
        FRAMED_DRAWERS_FRONT("framed_drawers_front"),
        FRAMED_DRAWERS_SHADING("framed_drawers_shading"),
        FRAMED_TRIM_SIDE("framed_trim_side"),
        FRAMED_TRIM_TRIM("framed_trim_trim"),
        FRAMED_CONTROLLER_SIDE("framed_controller_side"),
        FRAMED_CONTROLLER_TRIM("framed_controller_trim"),
        FRAMED_CONTROLLER_FRONT("framed_controller_front"),
        FRAMED_CONTROLLER_SHADING("framed_controller_shading"),
        FRAMED_CONTROLLER_IO_SIDE("framed_controller_io_side"),
        FRAMED_CONTROLLER_IO_TRIM("framed_controller_io_trim"),
        FRAMED_CONTROLLER_IO_SHADING("framed_controller_io_shading"),
        FRAMED_COMP2_SIDE("framed_comp2_side"),
        FRAMED_COMP2_TRIM("framed_comp2_trim"),
        FRAMED_COMP2_FRONT("framed_comp2_front"),
        FRAMED_COMP2_SHADING("framed_comp2_shading"),
        FRAMED_COMP3_SIDE("framed_comp3_side"),
        FRAMED_COMP3_TRIM("framed_comp3_trim"),
        FRAMED_COMP3_FRONT("framed_comp3_front"),
        FRAMED_COMP3_SHADING("framed_comp3_shading");

        private String name;

        private DynamicPart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class DecorationSet {
        public final Set<BlockState> targetBlocks = new HashSet<BlockState>();
        public final Map<String, BlockState> overlays = new HashMap<String, BlockState>();

        public DecorationSet() {
            ModBlocks.getDrawersOfType(BlockDrawers.class).forEach(blockDrawers -> this.targetBlocks.addAll((Collection<BlockState>)blockDrawers.getStateDefinition().getPossibleStates()));
            ModBlocks.getFramedBlocks().forEach(blockTrim -> {
                if (blockTrim instanceof Block) {
                    Block mcBlock = (Block)blockTrim;
                    this.targetBlocks.addAll((Collection<BlockState>)mcBlock.getStateDefinition().getPossibleStates());
                }
            });
        }

        public void add() {
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.VOID_ICON), ((BlockMeta)((Object)ModBlocks.META_VOID_ICON.get())).defaultBlockState());
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.SHROUD_ICON), ((BlockMeta)((Object)ModBlocks.META_SHROUD_ICON.get())).defaultBlockState());
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.SUSPEND_ICON), ((BlockMeta)((Object)ModBlocks.META_SUSPEND_ICON.get())).defaultBlockState());
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MAGNET_ICON), ((BlockMeta)((Object)ModBlocks.META_MAGNET_ICON.get())).defaultBlockState());
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.PRIORITY_P1_ICON), ((BlockMeta)((Object)ModBlocks.META_PRIORITY_P1_ICON.get())).defaultBlockState());
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.PRIORITY_P2_ICON), ((BlockMeta)((Object)ModBlocks.META_PRIORITY_P2_ICON.get())).defaultBlockState());
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.PRIORITY_N1_ICON), ((BlockMeta)((Object)ModBlocks.META_PRIORITY_N1_ICON.get())).defaultBlockState());
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.PRIORITY_N2_ICON), ((BlockMeta)((Object)ModBlocks.META_PRIORITY_N2_ICON.get())).defaultBlockState());
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.HOPPER), ((BlockMeta)((Object)ModBlocks.META_HOPPER.get())).defaultBlockState());
        }

        public void add(Direction dir, boolean half) {
            EnumCompDrawer open;
            int i;
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.LOCK, dir, half), (BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_LOCKED.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.CLAIM, dir, half), (BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_CLAIMED.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.LOCK_CLAIM, dir, half), (BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_LOCKED_CLAIMED.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            for (i = 1; i <= 6; ++i) {
                this.addOverlay(DrawerModelStore.getSlotVariant(DynamicPart.RIGHT_LABEL, dir, half, i), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_RIGHT_LABEL.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Label.SLOT, (Comparable)Integer.valueOf(i)));
            }
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.INDICATOR, dir, half, 1), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_INDICATOR.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots124.SLOTS, (Comparable)Integer.valueOf(1)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.INDICATOR, dir, half, 2), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_INDICATOR.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots124.SLOTS, (Comparable)Integer.valueOf(2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.INDICATOR, dir, half, 4), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_INDICATOR.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots124.SLOTS, (Comparable)Integer.valueOf(4)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.INDICATOR_COMP, dir, half, 2), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_COMP_INDICATOR.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots23.SLOTS, (Comparable)Integer.valueOf(2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.INDICATOR_COMP, dir, half, 3), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_COMP_INDICATOR.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots23.SLOTS, (Comparable)Integer.valueOf(3)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_1, dir, half, 1), (BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_MISSING_1_1.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_1, dir, half, 2), (BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_MISSING_2_1.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_1, dir, half, 4), (BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_MISSING_4_1.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_2, dir, half, 2), (BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_MISSING_2_2.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_2, dir, half, 4), (BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_MISSING_4_2.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_3, dir, half, 4), (BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_MISSING_4_3.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_4, dir, half, 4), (BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_MISSING_4_4.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SIDE, dir, half, 1), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_SIDE.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots124.SLOTS, (Comparable)Integer.valueOf(1)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SIDE, dir, half, 2), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_SIDE.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots124.SLOTS, (Comparable)Integer.valueOf(2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SIDE, dir, half, 4), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_SIDE.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots124.SLOTS, (Comparable)Integer.valueOf(4)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_TRIM, dir, half, 1), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_TRIM.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots124.SLOTS, (Comparable)Integer.valueOf(1)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_TRIM, dir, half, 2), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_TRIM.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots124.SLOTS, (Comparable)Integer.valueOf(2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_TRIM, dir, half, 4), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_TRIM.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots124.SLOTS, (Comparable)Integer.valueOf(4)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_FRONT, dir, half, 1), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_FRONT.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots124.SLOTS, (Comparable)Integer.valueOf(1)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_FRONT, dir, half, 2), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_FRONT.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots124.SLOTS, (Comparable)Integer.valueOf(2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_FRONT, dir, half, 4), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_FRONT.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots124.SLOTS, (Comparable)Integer.valueOf(4)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SHADING, dir, half, 1), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_SHADING.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots124.SLOTS, (Comparable)Integer.valueOf(1)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SHADING, dir, half, 2), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_SHADING.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots124.SLOTS, (Comparable)Integer.valueOf(2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SHADING, dir, half, 4), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_SHADING.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue((Property)BlockMetaFacingSizedSlotted.Slots124.SLOTS, (Comparable)Integer.valueOf(4)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_TRIM_SIDE), ((BlockMeta)((Object)ModBlocks.META_FRAMED_TRIM_SIDE.get())).defaultBlockState());
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_TRIM_TRIM), ((BlockMeta)((Object)ModBlocks.META_FRAMED_TRIM_TRIM.get())).defaultBlockState());
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_SIDE, dir), (BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_CONTROLLER_SIDE.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_TRIM, dir), (BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_CONTROLLER_TRIM.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_FRONT, dir), (BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_CONTROLLER_FRONT.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_SHADING, dir), (BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_CONTROLLER_SHADING.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_IO_SIDE), ((BlockMeta)((Object)ModBlocks.META_FRAMED_CONTROLLER_IO_SIDE.get())).defaultBlockState());
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_IO_TRIM), ((BlockMeta)((Object)ModBlocks.META_FRAMED_CONTROLLER_IO_TRIM.get())).defaultBlockState());
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_IO_SHADING), ((BlockMeta)((Object)ModBlocks.META_FRAMED_CONTROLLER_IO_SHADING.get())).defaultBlockState());
            for (i = 1; i <= 2; ++i) {
                open = EnumCompDrawer.byOpenSlots(i);
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP2_SIDE, dir, half, open), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_COMPDRAWERS_2_SIDE.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue(BlockMetaFacingSizedOpen.Open2.SLOTS, (Comparable)((Object)open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP2_TRIM, dir, half, open), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_COMPDRAWERS_2_TRIM.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue(BlockMetaFacingSizedOpen.Open2.SLOTS, (Comparable)((Object)open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP2_FRONT, dir, half, open), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_COMPDRAWERS_2_FRONT.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue(BlockMetaFacingSizedOpen.Open2.SLOTS, (Comparable)((Object)open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP2_SHADING, dir, half, open), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_COMPDRAWERS_2_SHADING.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue(BlockMetaFacingSizedOpen.Open2.SLOTS, (Comparable)((Object)open)));
            }
            for (i = 1; i <= 3; ++i) {
                open = EnumCompDrawer.byOpenSlots(i);
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP3_SIDE, dir, half, open), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_COMPDRAWERS_3_SIDE.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue(BlockMetaFacingSizedOpen.Open3.SLOTS, (Comparable)((Object)open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP3_TRIM, dir, half, open), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_COMPDRAWERS_3_TRIM.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue(BlockMetaFacingSizedOpen.Open3.SLOTS, (Comparable)((Object)open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP3_FRONT, dir, half, open), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_COMPDRAWERS_3_FRONT.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue(BlockMetaFacingSizedOpen.Open3.SLOTS, (Comparable)((Object)open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP3_SHADING, dir, half, open), (BlockState)((BlockState)((BlockState)((BlockMeta)((Object)ModBlocks.META_FRAMED_COMPDRAWERS_3_SHADING.get())).defaultBlockState().setValue((Property)BlockMetaFacingSized.FACING, (Comparable)dir)).setValue((Property)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).setValue(BlockMetaFacingSizedOpen.Open3.SLOTS, (Comparable)((Object)open)));
            }
        }

        void addOverlay(String variant, BlockState loc) {
            this.overlays.put(variant, DrawerModelStore.addLocation(loc));
        }

        public boolean isTargetedModel(BlockState loc) {
            if (loc == null) {
                return false;
            }
            return this.targetBlocks.contains(loc);
        }
    }

    public static class FrameMatSet {
        private DynamicPart sidePart;
        private DynamicPart trimPart;
        private DynamicPart frontPart;
        private DynamicPart shadeFrontPart;
        private DynamicPart shadeSidePart;

        public DynamicPart sidePart() {
            return this.sidePart;
        }

        public DynamicPart trimPart() {
            return this.trimPart;
        }

        public DynamicPart frontPart() {
            return this.frontPart;
        }

        public DynamicPart shadeFrontPart() {
            return this.shadeFrontPart;
        }

        public DynamicPart shadeSidePart() {
            return this.shadeSidePart;
        }

        public FrameMatSet sidePart(DynamicPart part) {
            this.sidePart = part;
            return this;
        }

        public FrameMatSet trimPart(DynamicPart part) {
            this.trimPart = part;
            return this;
        }

        public FrameMatSet frontPart(DynamicPart part) {
            this.frontPart = part;
            return this;
        }

        public FrameMatSet shadeFrontPart(DynamicPart part) {
            this.shadeFrontPart = part;
            return this;
        }

        public FrameMatSet shadeSidePart(DynamicPart part) {
            this.shadeSidePart = part;
            return this;
        }
    }
}

