/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.block.EnumFramingTablePart;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import com.mojang.serialization.MapCodec;
import com.texelsaurus.minecraft.chameleon.inventory.ContentMenuProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockFramingTable
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final EnumProperty<EnumFramingTablePart> PART = EnumProperty.create((String)"part", EnumFramingTablePart.class);
    public static final MapCodec<BlockFramingTable> CODEC = BlockFramingTable.simpleCodec(BlockFramingTable::new);
    protected static final VoxelShape TABLE_TOP = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape TABLE_BOTTOM_NORTH = Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape TABLE_BOTTOM_SOUTH = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0);
    protected static final VoxelShape TABLE_BOTTOM_WEST = Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0);
    protected static final VoxelShape TABLE_BOTTOM_EAST = Block.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape TABLE_SHAPE_NORTH = Shapes.or((VoxelShape)TABLE_TOP, (VoxelShape)TABLE_BOTTOM_NORTH);
    protected static final VoxelShape TABLE_SHAPE_SOUTH = Shapes.or((VoxelShape)TABLE_TOP, (VoxelShape)TABLE_BOTTOM_SOUTH);
    protected static final VoxelShape TABLE_SHAPE_WEST = Shapes.or((VoxelShape)TABLE_TOP, (VoxelShape)TABLE_BOTTOM_WEST);
    protected static final VoxelShape TABLE_SHAPE_EAST = Shapes.or((VoxelShape)TABLE_TOP, (VoxelShape)TABLE_BOTTOM_EAST);

    public BlockFramingTable(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(PART, (Comparable)((Object)EnumFramingTablePart.RIGHT)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public static Direction getTableDirection(BlockGetter getter, BlockPos pos) {
        BlockState state = getter.getBlockState(pos);
        return state.getBlock() instanceof BlockFramingTable ? (Direction)state.getValue((Property)FACING) : null;
    }

    private static Direction getNeighborDirection(EnumFramingTablePart part, Direction direction) {
        return part == EnumFramingTablePart.LEFT ? direction.getClockWise() : direction.getCounterClockWise();
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        EnumFramingTablePart part = (EnumFramingTablePart)((Object)state.getValue(PART));
        Direction facing = (Direction)state.getValue((Property)FACING);
        return switch (facing) {
            case Direction.NORTH -> {
                if (part == EnumFramingTablePart.LEFT) {
                    yield TABLE_SHAPE_WEST;
                }
                yield TABLE_SHAPE_EAST;
            }
            case Direction.SOUTH -> {
                if (part == EnumFramingTablePart.LEFT) {
                    yield TABLE_SHAPE_EAST;
                }
                yield TABLE_SHAPE_WEST;
            }
            case Direction.WEST -> {
                if (part == EnumFramingTablePart.LEFT) {
                    yield TABLE_SHAPE_NORTH;
                }
                yield TABLE_SHAPE_SOUTH;
            }
            case Direction.EAST -> {
                if (part == EnumFramingTablePart.LEFT) {
                    yield TABLE_SHAPE_SOUTH;
                }
                yield TABLE_SHAPE_NORTH;
            }
            default -> TABLE_TOP;
        };
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            BlockFramingTable.preventCreativeDropFromLeft(level, pos, state, player);
            if (!player.isCreative() && state.getValue(PART) != EnumFramingTablePart.RIGHT) {
                BlockFramingTable.dropResources((BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)EnumFramingTablePart.RIGHT))), (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected static void preventCreativeDropFromLeft(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos pos2;
        BlockState state2;
        EnumFramingTablePart part = (EnumFramingTablePart)((Object)state.getValue(PART));
        if (part == EnumFramingTablePart.RIGHT) {
            BlockPos pos22 = pos.relative(BlockFramingTable.getNeighborDirection(part, (Direction)state.getValue((Property)FACING)));
            BlockState state22 = level.getBlockState(pos22);
            if (state22.is(state.getBlock()) && state22.getValue(PART) == EnumFramingTablePart.LEFT) {
                level.setBlock(pos22, Blocks.AIR.defaultBlockState(), 35);
                level.levelEvent((Entity)player, 2001, pos22, Block.getId((BlockState)state22));
            }
        } else if (part == EnumFramingTablePart.LEFT && (state2 = level.getBlockState(pos2 = pos.relative(BlockFramingTable.getNeighborDirection(part, (Direction)state.getValue((Property)FACING))))).is(state.getBlock()) && state2.getValue(PART) == EnumFramingTablePart.RIGHT) {
            level.setBlock(pos2, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent((Entity)player, 2001, pos2, Block.getId((BlockState)state2));
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        Direction dirLeft = direction.getCounterClockWise();
        BlockPos pos = context.getClickedPos();
        BlockPos pos2 = pos.relative(dirLeft);
        return context.getLevel().getBlockState(pos2).canBeReplaced(context) && context.getLevel().getWorldBorder().isWithinBounds(pos2) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction) : null;
    }

    public static Direction getConnectedDirection(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return state.getValue(PART) == EnumFramingTablePart.RIGHT ? direction.getOpposite() : direction;
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState state) {
        EnumFramingTablePart part = (EnumFramingTablePart)((Object)state.getValue(PART));
        return part == EnumFramingTablePart.RIGHT ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityFramingTable((BlockEntityType)ModBlockEntities.FRAMING_TABLE.get(), pos, state);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        if (!level.isClientSide) {
            Direction dirLeft = ((Direction)state.getValue((Property)FACING)).getCounterClockWise();
            BlockPos pos2 = pos.relative(dirLeft);
            level.setBlock(pos2, (BlockState)state.setValue(PART, (Comparable)((Object)EnumFramingTablePart.LEFT)), 3);
            level.updateNeighborsAt(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    public InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (state.getValue(PART) != EnumFramingTablePart.RIGHT) {
            pos = pos.relative(BlockFramingTable.getNeighborDirection((EnumFramingTablePart)((Object)state.getValue(PART)), (Direction)state.getValue((Property)FACING)));
        }
        this.openUI(level, pos, player);
        return InteractionResult.CONSUME;
    }

    @Nullable
    protected MenuProvider getMenuProvider(BlockState blockState, Level level, BlockPos blockPos) {
        BlockEntityFramingTable blockEntity = WorldUtils.getBlockEntity((BlockGetter)level, blockPos, BlockEntityFramingTable.class);
        if (blockEntity == null) {
            return null;
        }
        return new BlockEntityFramingTable.ContentProvider(blockEntity);
    }

    private void openUI(Level level, BlockPos pos, Player player) {
        if (!((Boolean)ModCommonConfig.INSTANCE.GENERAL.enableUI.get()).booleanValue() || !((Boolean)ModCommonConfig.INSTANCE.DRAWERS.framed.enable.get()).booleanValue()) {
            return;
        }
        MenuProvider provider = level.getBlockState(pos).getMenuProvider(level, pos);
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("Open BlockDrawers UI " + String.valueOf(pos));
        }
        if (provider instanceof ContentMenuProvider) {
            ContentMenuProvider menu = (ContentMenuProvider)provider;
            menu.openMenu((ServerPlayer)player);
        }
    }
}

