/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.config.ClientConfig;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class AnvilRenderer
implements BlockEntityRenderer<BlockEntity> {
    private final ItemRenderer itemRenderer;

    public AnvilRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(BlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPosition) {
        if (!((ClientConfig)EasyAnvils.CONFIG.get(ClientConfig.class)).renderAnvilContents) {
            return;
        }
        Direction direction = (Direction)blockEntity.getBlockState().getValue((Property)AnvilBlock.FACING);
        int posData = (int)blockEntity.getBlockPos().asLong();
        this.renderFlatItem(blockEntity.getLevel(), 0, ((Container)blockEntity).getItem(0), direction, poseStack, bufferSource, packedLight, packedOverlay, posData);
        this.renderFlatItem(blockEntity.getLevel(), 1, ((Container)blockEntity).getItem(1), direction, poseStack, bufferSource, packedLight, packedOverlay, posData);
    }

    private void renderFlatItem(Level level, int index, ItemStack itemStack, Direction direction, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, int posData) {
        if (itemStack.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0, 1.0375, 0.0);
        poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(90.0f));
        boolean mirrored = (direction.getAxisDirection().getStep() == 1 ? 1 : 0) != index % 2;
        switch (direction.getAxis()) {
            case X: {
                if (mirrored) {
                    poseStack.translate(0.25, -0.5, 0.0);
                    break;
                }
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
                poseStack.translate(-0.75, 0.5, 0.0);
                break;
            }
            case Z: {
                if (mirrored) {
                    poseStack.mulPose((Quaternionfc)Axis.ZN.rotationDegrees(90.0f));
                    poseStack.translate(0.25, 0.5, 0.0);
                    break;
                }
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(90.0f));
                poseStack.translate(-0.75, -0.5, 0.0);
            }
        }
        poseStack.scale(0.375f, 0.375f, 0.375f);
        this.itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, level, posData + index);
        poseStack.popPose();
    }
}

