/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.client.core.context;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import fuzs.puzzleslib.api.client.core.v1.context.BlockStateResolverContext;
import fuzs.puzzleslib.api.client.renderer.v1.model.ModelLoadingHelper;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.PuzzlesLibMod;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelDiscovery;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelLoader;

public final class BlockStateResolverContextNeoForgeImpl
implements BlockStateResolverContext {
    private final ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
    private final Function<Material, TextureAtlasSprite> textureGetter;
    private final ResolvedModel missingModel;
    private final Supplier<TextureAtlasSprite> missingSprite;
    private final Map<ResourceLocation, ResolvedModel> resolvedModels;
    private final BiConsumer<BlockState, BlockStateModel> blockStateModelOutput;

    public BlockStateResolverContextNeoForgeImpl(ModelEvent.ModifyBakingResult event) {
        this.textureGetter = event.getTextureGetter();
        this.missingModel = event.getModelBakery().missingModel;
        this.missingSprite = Suppliers.memoize(() -> {
            Material material = new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation());
            TextureAtlasSprite textureAtlasSprite = (TextureAtlasSprite)event.getTextureGetter().apply(material);
            Objects.requireNonNull(textureAtlasSprite, "missing sprite is null");
            return textureAtlasSprite;
        });
        this.resolvedModels = new HashMap<ResourceLocation, ResolvedModel>(event.getModelBakery().resolvedModels);
        this.blockStateModelOutput = event.getBakingResult().blockStateModels()::put;
    }

    @Override
    public void registerBlockStateResolver(Block block, Consumer<BiConsumer<BlockState, BlockStateModel.UnbakedRoot>> blockStateConsumer) {
        ModelDiscovery modelDiscovery = new ModelDiscovery(Collections.emptyMap(), this.missingModel.wrapped());
        modelDiscovery.uncachedResolver = object -> {
            ResourceLocation resourcelocation = (ResourceLocation)object;
            ResolvedModel resolvedModel = this.resolvedModels.get(resourcelocation);
            if (resolvedModel instanceof ModelDiscovery.ModelWrapper) {
                ModelDiscovery.ModelWrapper modelWrapper = (ModelDiscovery.ModelWrapper)resolvedModel;
                return modelWrapper;
            }
            UnbakedModel unbakedmodel = ModelLoadingHelper.loadBlockModel(this.resourceManager, resourcelocation);
            if (unbakedmodel == null) {
                PuzzlesLib.LOGGER.warn("Missing block model: {}", (Object)resourcelocation);
                return (ModelDiscovery.ModelWrapper)this.missingModel;
            }
            return modelDiscovery.createAndQueueWrapper(resourcelocation, unbakedmodel);
        };
        HashMap<BlockState, BlockStateModel.UnbakedRoot> unbakedBlockStateModels = new HashMap<BlockState, BlockStateModel.UnbakedRoot>();
        blockStateConsumer.accept((blockState, unbakedBlockStateModel) -> {
            modelDiscovery.addRoot((ResolvableModel)unbakedBlockStateModel);
            unbakedBlockStateModels.put((BlockState)blockState, (BlockStateModel.UnbakedRoot)unbakedBlockStateModel);
        });
        modelDiscovery.resolve().forEach(this.resolvedModels::putIfAbsent);
        this.loadModels(unbakedBlockStateModels).blockStateModels().forEach(this.blockStateModelOutput);
    }

    ModelBakery.BakingResult loadModels(Map<BlockState, BlockStateModel.UnbakedRoot> unbakedBlockStateModels) {
        ModelBakery modelBakery = new ModelBakery(EntityModelSet.EMPTY, unbakedBlockStateModels, Collections.emptyMap(), this.resolvedModels, this.missingModel, StandaloneModelLoader.LoadedModels.EMPTY);
        return BlockStateResolverContextNeoForgeImpl.loadModels(Profiler.get(), this.textureGetter, modelBakery, this.missingSprite);
    }

    @Override
    public <T> void registerBlockStateResolver(Block block, BiFunction<ResourceManager, Executor, CompletableFuture<T>> resourceLoader, BiConsumer<T, BiConsumer<BlockState, BlockStateModel.UnbakedRoot>> blockStateConsumer) {
        this.registerBlockStateResolver(block, consumer -> blockStateConsumer.accept(((CompletableFuture)resourceLoader.apply(this.resourceManager, (Executor)Util.backgroundExecutor())).join(), (BiConsumer<BlockState, BlockStateModel.UnbakedRoot>)consumer));
    }

    static ModelBakery.BakingResult loadModels(ProfilerFiller profiler, final Function<Material, TextureAtlasSprite> textureGetter, ModelBakery modelBakery, Supplier<TextureAtlasSprite> missingSprite) {
        profiler.push(PuzzlesLibMod.id("baking").toString());
        HashMultimap multimap = HashMultimap.create();
        HashMultimap multimap1 = HashMultimap.create();
        ModelBakery.BakingResult bakingResult = (ModelBakery.BakingResult)modelBakery.bakeModels(new SpriteGetter(){
            final /* synthetic */ Multimap val$multimap;
            final /* synthetic */ Supplier val$missingSprite;
            final /* synthetic */ Multimap val$multimap1;
            {
                this.val$multimap = multimap;
                this.val$missingSprite = supplier;
                this.val$multimap1 = multimap2;
            }

            public TextureAtlasSprite get(Material material, ModelDebugName name) {
                TextureAtlasSprite textureAtlasSprite = (TextureAtlasSprite)textureGetter.apply(material);
                if (textureAtlasSprite != null) {
                    return textureAtlasSprite;
                }
                this.val$multimap.put((Object)name.debugName(), (Object)material);
                return (TextureAtlasSprite)this.val$missingSprite.get();
            }

            public TextureAtlasSprite reportMissingReference(String reference, ModelDebugName name) {
                this.val$multimap1.put((Object)name.debugName(), (Object)reference);
                return (TextureAtlasSprite)this.val$missingSprite.get();
            }
        }, (Executor)Util.backgroundExecutor()).join();
        multimap.asMap().forEach((string, collection) -> PuzzlesLib.LOGGER.warn("Missing textures in model {}:\n{}", string, (Object)collection.stream().sorted(Material.COMPARATOR).map(material -> "    " + String.valueOf(material.atlasLocation()) + ":" + String.valueOf(material.texture())).collect(Collectors.joining("\n"))));
        multimap1.asMap().forEach((string, collection) -> PuzzlesLib.LOGGER.warn("Missing texture references in model {}:\n{}", string, (Object)collection.stream().sorted().map(stringx -> "    " + stringx).collect(Collectors.joining("\n"))));
        profiler.pop();
        return bakingResult;
    }
}

