/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.event.core;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import fuzs.puzzleslib.api.event.v1.core.EventInvoker;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.impl.core.proxy.ProxyImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import org.jetbrains.annotations.Nullable;

public final class EventInvokerImpl {
    private static final Map<Class<?>, EventInvokerLike<?>> EVENT_INVOKER_LOOKUP = Collections.synchronizedMap(Maps.newIdentityHashMap());
    private static final Queue<Runnable> DEFERRED_INVOKER_REGISTRATIONS = Queues.newConcurrentLinkedQueue();
    private static boolean initialized;

    private EventInvokerImpl() {
    }

    public static void initialize() {
        if (!initialized) {
            ProxyImpl.get().registerEventHandlers();
            initialized = true;
            while (!DEFERRED_INVOKER_REGISTRATIONS.isEmpty()) {
                DEFERRED_INVOKER_REGISTRATIONS.poll().run();
            }
        }
    }

    public static <T> EventInvoker<T> softLookup(Class<T> clazz, @Nullable Object context) {
        Objects.requireNonNull(clazz, "type is null");
        Supplier invoker = Suppliers.memoize(() -> EventInvokerImpl.lookup(clazz, context));
        return (arg_0, arg_1) -> EventInvokerImpl.lambda$softLookup$2(clazz, (java.util.function.Supplier)invoker, arg_0, arg_1);
    }

    private static <T> EventInvoker<T> lookup(Class<T> clazz, @Nullable Object context) {
        Objects.requireNonNull(clazz, "type is null");
        EventInvokerLike<?> invokerLike = EVENT_INVOKER_LOOKUP.get(clazz);
        Objects.requireNonNull(invokerLike, "invoker is null for type " + String.valueOf(clazz));
        EventInvoker<?> invoker = invokerLike.asEventInvoker(context);
        Objects.requireNonNull(invoker, "invoker is null for type " + String.valueOf(clazz));
        return invoker;
    }

    public static <T> void register(Class<T> clazz, EventInvokerLike<T> invoker, boolean joinInvokers) {
        EventInvokerLike<?> other;
        if (joinInvokers && (other = EVENT_INVOKER_LOOKUP.get(clazz)) != null) {
            invoker = EventInvokerImpl.join(invoker, other);
        }
        EVENT_INVOKER_LOOKUP.put(clazz, invoker);
    }

    private static <T> EventInvokerLike<T> join(EventInvokerLike<T> invoker, EventInvokerLike<T> other) {
        return context -> (phase, callback) -> {
            invoker.asEventInvoker(context).register(phase, callback);
            other.asEventInvoker(context).register(phase, callback);
        };
    }

    private static /* synthetic */ void lambda$softLookup$2(Class clazz, java.util.function.Supplier invoker, EventPhase phase, Object callback) {
        if (!initialized && !EVENT_INVOKER_LOOKUP.containsKey(clazz)) {
            DEFERRED_INVOKER_REGISTRATIONS.offer(() -> EventInvokerImpl.lambda$softLookup$1((java.util.function.Supplier)invoker, phase, callback));
        } else {
            ((EventInvoker)invoker.get()).register(phase, callback);
        }
    }

    private static /* synthetic */ void lambda$softLookup$1(java.util.function.Supplier invoker, EventPhase phase, Object callback) {
        ((EventInvoker)invoker.get()).register(phase, callback);
    }

    static {
        ProxyImpl.get().registerLoadingHandlers();
    }

    @FunctionalInterface
    public static interface EventInvokerLike<T> {
        public EventInvoker<T> asEventInvoker(@Nullable Object var1);
    }
}

