/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.renderer.v1;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.model.ChestModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class SingleChestRenderer<T extends BlockEntity, M extends ChestModel>
extends ChestRenderer<T> {
    protected final M model;
    @Nullable
    private T blockEntity;
    @Nullable
    private Float partialTick;
    @Nullable
    private MultiBufferSource bufferSource;

    protected SingleChestRenderer(BlockEntityRendererProvider.Context context, M model) {
        super(context);
        this.model = model;
    }

    public final void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPosition) {
        this.blockEntity = blockEntity;
        this.partialTick = Float.valueOf(partialTick);
        this.bufferSource = bufferSource;
        super.render(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay, cameraPosition);
        this.blockEntity = null;
        this.partialTick = null;
        this.bufferSource = null;
    }

    @ApiStatus.Internal
    protected final void render(PoseStack poseStack, VertexConsumer buffer, ChestModel model, float openness, int packedLight, int packedOverlay) {
        Objects.requireNonNull(this.blockEntity, "block entity is null");
        Objects.requireNonNull(this.partialTick, "partial tick is null");
        Objects.requireNonNull(this.bufferSource, "buffer source is null");
        this.model.setupAnim(openness);
        this.renderModel(this.blockEntity, this.partialTick.floatValue(), poseStack, this.bufferSource, packedLight, packedOverlay);
    }

    protected void renderModel(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        VertexConsumer vertexConsumer = this.getChestMaterial(blockEntity, this.getXmasTextures()).buffer(bufferSource, RenderType::entityCutout);
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    protected abstract Material getChestMaterial(T var1, boolean var2);

    protected boolean getXmasTextures() {
        return this.xmasTextures;
    }
}

