/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2;

import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.client.data.models.EquipmentAssetProvider;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.equipment.EquipmentAsset;

public abstract class AbstractEquipmentProvider
extends EquipmentAssetProvider {
    public AbstractEquipmentProvider(DataProviderContext context) {
        this(context.getPackOutput());
    }

    public AbstractEquipmentProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        LinkedHashMap values = new LinkedHashMap();
        this.addEquipmentAssets((resourceKey, equipmentClientInfo) -> {
            if (values.putIfAbsent(resourceKey, equipmentClientInfo) != null) {
                throw new IllegalStateException("Tried to register equipment asset twice for id: " + String.valueOf(resourceKey));
            }
        });
        return DataProvider.saveAll((CachedOutput)cachedOutput, (Codec)EquipmentClientInfo.CODEC, arg_0 -> ((PackOutput.PathProvider)this.pathProvider).json(arg_0), values);
    }

    public abstract void addEquipmentAssets(BiConsumer<ResourceKey<EquipmentAsset>, EquipmentClientInfo> var1);

    public static EquipmentClientInfo onlyHumanoid(ResourceLocation resourceLocation) {
        return EquipmentClientInfo.builder().addHumanoidLayers(resourceLocation).build();
    }

    public static EquipmentClientInfo humanoidAndHorse(ResourceLocation resourceLocation) {
        return EquipmentClientInfo.builder().addHumanoidLayers(resourceLocation).addLayers(EquipmentClientInfo.LayerType.HORSE_BODY, new EquipmentClientInfo.Layer[]{EquipmentClientInfo.Layer.leatherDyeable((ResourceLocation)resourceLocation, (boolean)false)}).build();
    }

    public static EquipmentClientInfo simple(EquipmentClientInfo.LayerType layerType, ResourceLocation resourceLocation) {
        return EquipmentClientInfo.builder().addLayers(layerType, new EquipmentClientInfo.Layer[]{new EquipmentClientInfo.Layer(resourceLocation)}).build();
    }
}

