/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2;

import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.data.AtlasProvider;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractAtlasProvider
extends AtlasProvider {
    private final Map<ResourceLocation, List<SpriteSource>> values = new LinkedHashMap<ResourceLocation, List<SpriteSource>>();

    public AbstractAtlasProvider(DataProviderContext context) {
        this(context.getPackOutput());
    }

    public AbstractAtlasProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public final CompletableFuture<?> run(CachedOutput output) {
        this.addAtlases();
        return CompletableFuture.allOf((CompletableFuture[])this.values.entrySet().stream().map(entry -> this.storeAtlas(output, (ResourceLocation)entry.getKey(), (List)entry.getValue())).toArray(CompletableFuture[]::new));
    }

    public abstract void addAtlases();

    protected void addMaterial(Material material) {
        this.add((ResourceLocation)ModelManager.VANILLA_ATLASES.get(material.atlasLocation()), AbstractAtlasProvider.forMaterial((Material)material));
    }

    protected void add(ResourceLocation resourceLocation, SpriteSource ... spriteSources) {
        this.add(resourceLocation, Arrays.asList(spriteSources));
    }

    protected void add(ResourceLocation resourceLocation, List<SpriteSource> spriteSources) {
        this.values.computeIfAbsent(resourceLocation, resourceLocationX -> new ArrayList()).addAll(spriteSources);
    }
}

