/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.biome.v1;

import fuzs.puzzleslib.api.biome.v1.MobSpawnSettingsContext;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import java.util.function.ToIntFunction;
import net.minecraft.util.random.Weighted;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.apache.commons.lang3.math.Fraction;

public final class SpawnerDataBuilder {
    private final MobSpawnSettingsContext context;
    private final EntityType<?> entityType;
    private IntUnaryOperator weightMapper = IntUnaryOperator.identity();
    private ToIntFunction<MobSpawnSettings.SpawnerData> minCountMapper = MobSpawnSettings.SpawnerData::minCount;
    private ToIntFunction<MobSpawnSettings.SpawnerData> maxCountMapper = MobSpawnSettings.SpawnerData::maxCount;

    private SpawnerDataBuilder(MobSpawnSettingsContext context, EntityType<?> entityType) {
        Objects.requireNonNull(context, "context is null");
        Objects.requireNonNull(entityType, "entity type is null");
        this.context = context;
        this.entityType = entityType;
    }

    public static SpawnerDataBuilder create(MobSpawnSettingsContext context, EntityType<?> entityType) {
        return new SpawnerDataBuilder(context, entityType);
    }

    public SpawnerDataBuilder setWeight(int weight) {
        return this.setWeight((int oldWeight) -> weight);
    }

    public SpawnerDataBuilder setWeight(Fraction weight) {
        Objects.requireNonNull(weight, "weight is null");
        return this.setWeight((int oldWeight) -> weight.multiplyBy(Fraction.getFraction((int)oldWeight, (int)1)).intValue());
    }

    public SpawnerDataBuilder setWeight(IntUnaryOperator weight) {
        Objects.requireNonNull(weight, "weight is null");
        this.weightMapper = oldWeight -> Math.max(1, weight.applyAsInt(oldWeight));
        return this;
    }

    public SpawnerDataBuilder setMinCount(int minCount) {
        return this.setMinCount((MobSpawnSettings.SpawnerData spawnerData) -> minCount);
    }

    public SpawnerDataBuilder setMinCount(Fraction minCount) {
        Objects.requireNonNull(minCount, "min count is null");
        return this.setMinCount((MobSpawnSettings.SpawnerData spawnerData) -> minCount.multiplyBy(Fraction.getFraction((int)spawnerData.minCount(), (int)1)).intValue());
    }

    public SpawnerDataBuilder setMinCount(ToIntFunction<MobSpawnSettings.SpawnerData> minCount) {
        Objects.requireNonNull(minCount, "min count is null");
        this.minCountMapper = spawnerData -> Math.max(1, minCount.applyAsInt((MobSpawnSettings.SpawnerData)spawnerData));
        return this;
    }

    public SpawnerDataBuilder setMaxCount(int maxCount) {
        return this.setMaxCount((MobSpawnSettings.SpawnerData spawnerData) -> maxCount);
    }

    public SpawnerDataBuilder setMaxCount(Fraction maxCount) {
        Objects.requireNonNull(maxCount, "max count is null");
        return this.setMaxCount((MobSpawnSettings.SpawnerData spawnerData) -> maxCount.multiplyBy(Fraction.getFraction((int)spawnerData.maxCount(), (int)1)).intValue());
    }

    public SpawnerDataBuilder setMaxCount(ToIntFunction<MobSpawnSettings.SpawnerData> maxCount) {
        Objects.requireNonNull(maxCount, "max count is null");
        this.maxCountMapper = spawnerData -> Math.max(1, maxCount.applyAsInt((MobSpawnSettings.SpawnerData)spawnerData));
        return this;
    }

    public void apply(EntityType<?> entityType) {
        for (MobCategory mobCategory : this.context.getMobCategoriesWithSpawns()) {
            this.getSpawnerDataForType(this.context, mobCategory, this.entityType).ifPresent(spawnerData -> {
                int weight = this.weightMapper.applyAsInt(spawnerData.weight());
                int minCount = this.minCountMapper.applyAsInt((MobSpawnSettings.SpawnerData)spawnerData.value());
                int maxCount = this.maxCountMapper.applyAsInt((MobSpawnSettings.SpawnerData)spawnerData.value());
                this.context.addSpawn(mobCategory, weight, new MobSpawnSettings.SpawnerData(entityType, Math.min(minCount, maxCount), maxCount));
            });
        }
    }

    private Optional<Weighted<MobSpawnSettings.SpawnerData>> getSpawnerDataForType(MobSpawnSettingsContext context, MobCategory mobCategory, EntityType<?> entityType) {
        return context.getSpawnerData(mobCategory).stream().filter(spawnerData -> ((MobSpawnSettings.SpawnerData)spawnerData.value()).type() == entityType).findAny();
    }
}

