/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.network;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.NotNull;
import snownee.jade.Jade;
import snownee.jade.api.JadeIds;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.network.ClientPayloadContext;
import snownee.jade.network.ServerPayloadContext;

public record ReceiveDataPacket(CompoundTag tag) implements CustomPacketPayload
{
    public static final int MAX_SIZE = 16384;
    public static final CustomPacketPayload.Type<ReceiveDataPacket> TYPE = new CustomPacketPayload.Type(JadeIds.PACKET_RECEIVE_DATA);
    public static final StreamCodec<FriendlyByteBuf, ReceiveDataPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, ReceiveDataPacket::tag, ReceiveDataPacket::new);
    private static int spamCount;

    public static void handle(ReceiveDataPacket message, ClientPayloadContext context) {
        context.execute(() -> ObjectDataCenter.setServerData(message.tag));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void send(CompoundTag tag, ServerPayloadContext context) {
        int size = tag.sizeInBytes();
        if (size > 16384) {
            if (spamCount++ < 1) {
                Jade.LOGGER.debug("Data size is too large: {}, max: {}, data: {}", new Object[]{size, 16384, tag});
            }
            int c = 0;
            do {
                if (++c > 10) {
                    return;
                }
                ReceiveDataPacket.removeLargest(tag, 0, 1);
            } while (tag.sizeInBytes() > 16384);
        }
        context.sendPacket(new ReceiveDataPacket(tag));
    }

    private static boolean removeLargest(CompoundTag tag, int depth, int maxDepth) {
        int largestSize = 0;
        String largestKey = null;
        Tag largestValue = null;
        for (String key : tag.keySet()) {
            Tag childTag = Objects.requireNonNull(tag.get(key));
            int size = childTag.sizeInBytes();
            if (size <= largestSize) continue;
            largestSize = size;
            largestKey = key;
            largestValue = childTag;
        }
        if (largestKey == null) {
            return false;
        }
        if (depth < maxDepth && largestValue instanceof CompoundTag) {
            if (!ReceiveDataPacket.removeLargest((CompoundTag)largestValue, depth + 1, maxDepth)) {
                tag.remove(largestKey);
            }
        } else {
            tag.remove(largestKey);
        }
        return true;
    }
}

