/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.key_extension;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import org.jetbrains.annotations.Nullable;
import snownee.jade.key_extension.KeyMappingEx;

public final class KeyExManager {
    private static final ListMultimap<InputConstants.Key, KeyMapping> MAP = ArrayListMultimap.create();
    private static List<KeyMapping> activeKeys = List.of();
    private static boolean globalNoConflict;
    private static boolean dirty;

    public static boolean isGlobalNoConflict() {
        return globalNoConflict;
    }

    public static void setGlobalNoConflict(boolean globalNoConflict) {
        KeyExManager.globalNoConflict = globalNoConflict;
        KeyExManager.markDirty();
    }

    public static void markDirty() {
        dirty = true;
    }

    public static void click(InputConstants.Key key, @Nullable KeyMapping keyMapping) {
        for (KeyMapping mapping : MAP.get((Object)key)) {
            if (mapping == keyMapping) continue;
            ++mapping.clickCount;
        }
    }

    public static void set(InputConstants.Key key, boolean bl, @Nullable KeyMapping keyMapping) {
        for (KeyMapping mapping : MAP.get((Object)key)) {
            if (mapping == keyMapping) continue;
            mapping.setDown(bl);
        }
    }

    public static void resetMapping(Map<String, KeyMapping> all) {
        activeKeys = all.values().stream().filter(keyMapping -> ((KeyMappingEx)keyMapping).keyEx$isActive()).toList();
        MAP.clear();
        for (KeyMapping keyMapping2 : activeKeys) {
            if (keyMapping2.isUnbound() || !((KeyMappingEx)keyMapping2).keyEx$isNoConflict()) continue;
            MAP.put((Object)((KeyMappingEx)keyMapping2).keyEx$key(), (Object)keyMapping2);
        }
        dirty = false;
    }

    public static List<KeyMapping> activeKeys() {
        return activeKeys;
    }

    public static void checkDirty() {
        if (dirty) {
            KeyMapping.resetMapping();
        }
    }
}

