/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import snownee.jade.JadeClient;
import snownee.jade.api.JadeIds;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.NarratableComponent;
import snownee.jade.api.ui.Orientation;
import snownee.jade.api.ui.ResizeableElement;
import snownee.jade.api.ui.ScreenDirection;
import snownee.jade.api.view.ProgressView;
import snownee.jade.gui.ResizeableLayout;
import snownee.jade.impl.ui.ProgressOverlayElement;
import snownee.jade.impl.ui.SpriteElement;
import snownee.jade.impl.ui.StyledElement;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.track.ProgressTrackInfo;

public class ProgressElement
extends ResizeableElement
implements StyledElement {
    private static final SpriteElement DEFAULT_OVERLAY = new SpriteElement(JadeIds.JADE("progressbar"), 16, 16);
    private final ProgressView view;
    private ProgressTrackInfo track;

    public ProgressElement(ProgressView view) {
        this.view = view;
        this.width = 100;
        this.height = 8;
        if (view.text != null) {
            this.width = Math.max(this.width, DisplayHelper.font().width((FormattedText)view.text) + 10);
            this.height = 14;
        }
        if (view.style.direction().isHorizontal()) {
            if (view.style.fitContentX()) {
                this.flexGrow(1);
            }
            if (view.style.fitContentY()) {
                this.alignSelfStretch();
            }
        } else {
            if (view.style.fitContentY()) {
                this.flexGrow(1);
            }
            if (view.style.fitContentX()) {
                this.alignSelfStretch();
            }
        }
    }

    public ProgressElement(ProgressView view, int width, int height) {
        this.view = view;
        this.width = width;
        this.height = height;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.view.boxStyle.render(graphics, this, this.getX(), this.getY(), this.width, this.height, IDisplayHelper.get().opacity());
        if (this.track != null) {
            this.track.setProgress(this.view.parts);
            this.track.update(Minecraft.getInstance().getDeltaTracker().getRealtimeDeltaTicks());
        }
        int borderWidth = this.view.boxStyle.borderWidth();
        int freeX = this.getX() + borderWidth;
        int freeY = this.getY() + borderWidth;
        int freeWidth = this.width - borderWidth * 2;
        int freeHeight = this.height - borderWidth * 2;
        float progress = 0.0f;
        float start = 0.0f;
        for (int i = 0; i < this.view.parts.size(); ++i) {
            ProgressView.Part part = this.view.parts.get(i);
            float partProgress = part.progress();
            if (partProgress <= 0.0f) continue;
            if (this.track != null) {
                partProgress = this.track.getSmoothProgress(part);
            }
            progress = Math.min(progress + partProgress, 1.0f);
            start = this.renderPart(graphics, partialTicks, part, partProgress, start, freeX, freeY, freeWidth, freeHeight, i == this.view.parts.size() - 1);
            if (progress == 1.0f) break;
        }
        if (progress > 0.0f && this.view.style.foreground() != null) {
            DisplayHelper.INSTANCE.blitSprite(graphics, RenderPipelines.GUI_TEXTURED, this.view.style.foreground(), freeX, freeY, (int)((float)freeWidth - start), freeHeight);
        }
        if (this.view.text != null) {
            IDisplayHelper.get().drawText(graphics, (FormattedText)this.view.text, (float)(this.getX() + 4), (float)(this.getY() + 3), IThemeHelper.get().getNormalColor());
        }
    }

    private float renderPart(GuiGraphics graphics, float partialTicks, ProgressView.Part part, float partProgress, float start, int x, int y, int width, int height, boolean isLast) {
        ProgressOverlayElement element;
        float partWidth = Math.min(partProgress * (float)width, (float)width - start);
        int roundedPartWidth = Mth.ceil((float)partWidth);
        Element overlay = part.overlay();
        if (overlay == null) {
            DEFAULT_OVERLAY.setColor(part.themeColor());
            ProgressElement.DEFAULT_OVERLAY.tiledOrientation = this.view.style.direction() == ScreenDirection.RIGHT ? Orientation.HORIZONTAL : Orientation.VERTICAL;
            overlay = DEFAULT_OVERLAY;
        }
        if (isLast && this.view.style.foreground() == null && overlay instanceof ProgressOverlayElement && (element = (ProgressOverlayElement)overlay).canUseFloatingRect()) {
            element.setFloatingRect((float)x + start, y, partWidth, height);
            element.render(graphics, -1, -1, partialTicks);
            element.setFloatingRect(null);
            return start + partWidth;
        }
        this.resizeElement(overlay, x + (int)start, y, roundedPartWidth, height);
        overlay.render(graphics, -1, -1, partialTicks);
        return start + (float)roundedPartWidth;
    }

    private void resizeElement(Element element, int x, int y, int width, int height) {
        element.setX(x);
        element.setY(y);
        if (element instanceof ResizeableLayout) {
            ResizeableLayout resizeableLayout = (ResizeableLayout)((Object)element);
            resizeableLayout.setFreeSpace(width, height);
        }
    }

    @Override
    @Nullable
    public Component getNarration() {
        return this.view.text == null ? null : NarratableComponent.getNarration((FormattedText)this.view.text);
    }

    @Override
    public Element getIcon() {
        return null;
    }

    @Override
    public BoxStyle getStyle() {
        return this.view.boxStyle;
    }

    @Override
    public void setFreeSpace(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void updateSize() {
        if (this.getTag() != null && this.view.parts.size() < 2) {
            this.track = JadeClient.tickHandler().progressTracker.getOrCreate(this.getTag(), ProgressTrackInfo.class, () -> new ProgressTrackInfo(this.view.parts, this.view.style.canDecrease(), this.width));
            this.track.setExpectedWidth(this.width);
            this.width = this.track.getWidth();
        } else {
            this.track = null;
        }
    }
}

