/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import snownee.jade.JadeInternals;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxElement;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.MessageType;
import snownee.jade.api.ui.Rect2f;
import snownee.jade.api.ui.ResizeableElement;
import snownee.jade.api.ui.ScreenDirection;
import snownee.jade.api.ui.TooltipAnimation;
import snownee.jade.gui.JadeLinearLayout;
import snownee.jade.gui.LayoutWithPadding;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.gui.ResizeableLayout;
import snownee.jade.impl.Tooltip;
import snownee.jade.track.ProgressTrackInfo;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.ToFloatFunction;
import snownee.jade.util.WailaExceptionHandler;

public class BoxElementImpl
extends BoxElement
implements ContainerEventHandler {
    public LayoutWithPadding layout;
    private final Tooltip tooltip;
    private final BoxStyle style;
    private final List<Renderable> renderables;
    @Nullable
    private List<AbstractWidget> widgets;
    @Nullable
    private List<GuiEventListener> eventListeners;
    private Element icon;
    private float boxProgress;
    private MessageType boxProgressType;
    private ProgressTrackInfo track;

    public BoxElementImpl(Tooltip tooltip, BoxStyle style) {
        this.tooltip = Objects.requireNonNull(tooltip);
        this.style = Objects.requireNonNull(style);
        this.icon = tooltip.getIcon();
        this.updateSize();
        this.renderables = Lists.newArrayListWithExpectedSize((int)(tooltip.size() + 1));
        JadeUI.visitChildrenRecursive(this.layout, element -> {
            if (element instanceof Renderable) {
                Renderable renderable = (Renderable)element;
                this.renderables.add(renderable);
            }
        });
    }

    @Override
    public void updateSize() {
        JadeLinearLayout linearLayout = JadeLinearLayout.vertical().alignItems(JadeLinearLayout.Align.STRETCH);
        for (Tooltip.Line line : this.tooltip.lines) {
            JadeLinearLayout lineLayout = JadeLinearLayout.horizontal();
            for (LayoutElement element : line.elements()) {
                if (element instanceof ResizeableElement) {
                    ResizeableElement resizeableElement = (ResizeableElement)element;
                    resizeableElement.updateSize();
                }
                lineLayout.addChild(element, lineLayout.newChildLayoutSettings(element), container -> {
                    LayoutElement patt1$temp;
                    Element element0;
                    LayoutElement patt0$temp = container.child;
                    if (patt0$temp instanceof Element && (element0 = (Element)patt0$temp).getAlignSelf() != null) {
                        container.alignSelf = element0.getAlignSelf();
                    }
                    if ((patt1$temp = container.child) instanceof ResizeableLayout) {
                        ResizeableLayout resizeableLayout = (ResizeableLayout)patt1$temp;
                        container.flexGrow = resizeableLayout.getFlexGrow();
                    }
                });
            }
            LayoutSettings lineSettings = linearLayout.newChildLayoutSettings(lineLayout);
            if (line.settings != null) {
                lineSettings = (LayoutSettings)line.settings.apply(lineSettings);
            }
            linearLayout.addChild(lineLayout, lineSettings, container -> {
                container.headMargin = line.marginTop;
                container.tailMargin = line.marginBottom;
            });
        }
        if (this.icon != null) {
            JadeLinearLayout iconLayout = JadeLinearLayout.horizontal().alignItems(JadeLinearLayout.Align.START).spacing(3);
            if (IWailaConfig.get().overlay().getIconMode() == IWailaConfig.IconMode.CENTERED) {
                iconLayout.alignItems(JadeLinearLayout.Align.CENTER);
            }
            iconLayout.addChild(this.icon);
            iconLayout.addChild(linearLayout);
            linearLayout = iconLayout;
        }
        this.layout = new LayoutWithPadding(linearLayout, this.style.padding(ScreenDirection.LEFT), this.style.padding(ScreenDirection.UP), this.style.padding(ScreenDirection.RIGHT), this.style.padding(ScreenDirection.DOWN));
        this.layout.arrangeElements();
        this.width = this.layout.getWidth();
        this.height = this.layout.getHeight();
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        this.layout.setX(x);
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.layout.setY(y);
    }

    private static void chase(TooltipAnimation animation, ToFloatFunction<Rect2f> getter, FloatConsumer setter, float progress) {
        if (IWailaConfig.get().overlay().getAnimation()) {
            float source = getter.applyAsFloat(animation.rect);
            float target = getter.applyAsFloat(animation.expectedRect);
            float diff = target - source;
            if (diff == 0.0f) {
                return;
            }
            if (progress >= 1.0f) {
                animation.startTime = -1L;
                setter.accept(target);
                return;
            }
            float startValue = getter.applyAsFloat(animation.startRect);
            float deltaValue = target - startValue;
            setter.accept(startValue + progress * deltaValue);
        } else {
            setter.accept(getter.applyAsFloat(animation.expectedRect));
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.tooltip.isEmpty()) {
            return;
        }
        float alpha = IDisplayHelper.get().backgroundOpacity();
        boolean root = JadeIds.ROOT.equals((Object)this.getTag());
        if (root) {
            alpha *= IWailaConfig.get().overlay().getAlpha();
        }
        if (alpha > 0.0f) {
            this.style.render(graphics, this, this.getX(), this.getY(), this.getWidth(), this.getHeight(), alpha);
        }
        graphics.enableScissor(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight());
        for (Renderable renderable : this.renderables) {
            try {
                renderable.render(graphics, mouseX, mouseY, partialTicks);
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, null, null);
                IDisplayHelper.get().drawBorder(graphics, ((LayoutElement)renderable).getRectangle(), 1, -1996554240, true);
            }
        }
        graphics.disableScissor();
        if (root && this.tooltip.sneakyDetails) {
            IThemeHelper.get().theme().sneakyDetails.render(graphics, partialTicks, this);
        }
    }

    @Override
    public void renderDebug(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, Element.RenderDebugContext context) {
        super.renderDebug(graphics, mouseX, mouseY, partialTicks, context);
        JadeUI.visitChildrenRecursive(this.layout, layoutElement -> {
            if (layoutElement instanceof Element) {
                Element element = (Element)layoutElement;
                element.renderDebug(graphics, mouseX, mouseY, partialTicks, context);
            } else if (layoutElement instanceof Layout) {
                JadeInternals.getDisplayHelper().drawBorder(graphics, layoutElement.getRectangle(), 1, -2013200640, true);
            }
        });
    }

    @Override
    public Tooltip getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setBoxProgress(MessageType type, float progress) {
        this.boxProgress = progress;
        this.boxProgressType = type;
    }

    @Override
    public float getBoxProgress() {
        return this.boxProgressType == null ? Float.NaN : this.boxProgress;
    }

    @Override
    public void clearBoxProgress() {
        this.boxProgress = 0.0f;
        this.boxProgressType = null;
    }

    @Override
    @Nullable
    public Element getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(@Nullable Element icon) {
        this.icon = icon;
    }

    public void updateExpectedRect(TooltipAnimation animation) {
        Rect2i bossBarRect;
        Window window = Minecraft.getInstance().getWindow();
        IWailaConfig.Overlay overlay = IWailaConfig.get().overlay();
        IWailaConfig.Accessibility accessibility = IWailaConfig.get().accessibility();
        float x = (float)window.getGuiScaledWidth() * accessibility.tryFlip(overlay.getOverlayPosX());
        float y = (float)window.getGuiScaledHeight() * (1.0f - overlay.getOverlayPosY());
        float width = this.layout.getWidth();
        float height = this.layout.getHeight();
        animation.scale = overlay.getOverlayScale();
        float thresholdHeight = (float)window.getGuiScaledHeight() * overlay.getAutoScaleThreshold();
        if (!JadeUI.isPinned() && (float)this.layout.getHeight() * animation.scale > thresholdHeight) {
            animation.scale = Math.max(animation.scale * 0.5f, thresholdHeight / (float)this.layout.getHeight());
        }
        Rect2f expectedRect = animation.expectedRect;
        expectedRect.setWidth((int)(width * animation.scale));
        expectedRect.setHeight((int)(height * animation.scale));
        expectedRect.setX((int)(x - expectedRect.getWidth() * accessibility.tryFlip(overlay.getAnchorX())));
        expectedRect.setY((int)(y - expectedRect.getHeight() * overlay.getAnchorY()));
        if (PreviewOptionsScreen.isAdjustingPosition()) {
            return;
        }
        IWailaConfig.BossBarOverlapMode mode = IWailaConfig.get().general().getBossBarOverlapMode();
        if (mode == IWailaConfig.BossBarOverlapMode.PUSH_DOWN && (bossBarRect = ClientProxy.getBossBarRect()) != null) {
            width = expectedRect.getWidth();
            height = expectedRect.getHeight();
            int rw = bossBarRect.getWidth();
            int rh = bossBarRect.getHeight();
            x = expectedRect.getX();
            y = expectedRect.getY();
            int rx = bossBarRect.getX();
            int ry = bossBarRect.getY();
            rw += rx;
            rh += ry;
            width += x;
            height += y;
            if ((float)rw > x && (float)rh > y && width > (float)rx && height > (float)ry) {
                expectedRect.setY(bossBarRect.getHeight());
            }
        }
    }

    public void updateRect(TooltipAnimation animation) {
        Rect2f src = animation.rect;
        Rect2f target = animation.expectedRect;
        if (src.getWidth() == 0.0f) {
            src.setX(target.getX());
            src.setY(target.getY());
            src.setWidth(target.getWidth());
            src.setHeight(target.getHeight());
            animation.alpha = animation.showHideAlpha;
        } else {
            Duration duration = Duration.ofMillis(75L);
            long deltaTime = System.currentTimeMillis() - animation.startTime;
            long durationMillis = duration.toMillis();
            float progress = (float)deltaTime / (float)durationMillis;
            animation.alpha = Math.min(animation.showHideAlpha, Math.max(progress, 0.55f));
            BoxElementImpl.chase(animation, Rect2f::getX, src::setX, progress);
            BoxElementImpl.chase(animation, Rect2f::getY, src::setY, progress);
            BoxElementImpl.chase(animation, Rect2f::getWidth, it -> {
                src.setWidth(it);
                this.width = (int)(it / animation.scale);
            }, progress);
            BoxElementImpl.chase(animation, Rect2f::getHeight, it -> {
                src.setHeight(it);
                this.height = (int)(it / animation.scale);
            }, progress);
        }
    }

    @Override
    public BoxStyle getStyle() {
        return this.style;
    }

    @Override
    @Nullable
    public Component getNarration() {
        if (this.tooltip.isEmpty()) {
            return null;
        }
        String narration = this.tooltip.getNarration();
        if (narration.isEmpty()) {
            return null;
        }
        return Component.literal((String)narration);
    }

    @Override
    public void setFreeSpace(int width, int height) {
        this.layout.setFreeSpace(width, height);
        this.width = this.layout.getWidth();
        this.height = this.layout.getHeight();
    }

    @Override
    public void visitWidgets(Consumer<AbstractWidget> consumer) {
        this.layout.visitWidgets(consumer);
    }

    public void setWidgetAlpha(float alpha) {
        if (this.widgets == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.visitWidgets(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            this.widgets = builder.build();
        }
        for (AbstractWidget widget : this.widgets) {
            widget.setAlpha(alpha);
        }
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        if (this.eventListeners == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Renderable renderable : this.renderables) {
                if (!(renderable instanceof GuiEventListener)) continue;
                GuiEventListener listener = (GuiEventListener)renderable;
                builder.add((Object)listener);
            }
            this.eventListeners = builder.build();
        }
        return this.eventListeners;
    }

    public boolean isDragging() {
        return false;
    }

    public void setDragging(boolean bl) {
    }

    @Nullable
    public GuiEventListener getFocused() {
        return null;
    }

    public void setFocused(@Nullable GuiEventListener guiEventListener) {
    }
}

