/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.lookup;

import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.IdMapper;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.IJadeProvider;
import snownee.jade.impl.PriorityStore;
import snownee.jade.impl.WailaCommonRegistration;

public interface IHierarchyLookup<T extends IJadeProvider> {
    public static final Comparator<IJadeProvider> COMPARATOR = Comparator.comparingInt($ -> WailaCommonRegistration.instance().priorities.byValue((IJadeProvider)$));

    default public IHierarchyLookup<? extends T> cast() {
        return this;
    }

    public void idMapped();

    @Nullable
    public IdMapper<T> idMapper();

    default public List<ResourceLocation> mappedIds() {
        return Streams.stream((Iterable)((Iterable)Objects.requireNonNull(this.idMapper()))).map(IJadeProvider::getUid).toList();
    }

    public void register(Class<?> var1, T var2);

    public boolean isClassAcceptable(Class<?> var1);

    default public List<T> get(Object obj) {
        if (obj == null) {
            return List.of();
        }
        return this.get(obj.getClass());
    }

    public List<T> get(Class<?> var1);

    public void keyed();

    public T byKey(ResourceLocation var1);

    public boolean isEmpty();

    public Stream<Map.Entry<Class<?>, Collection<T>>> entries();

    public void invalidate();

    public void loadComplete(PriorityStore<ResourceLocation, IJadeProvider> var1);

    default public IdMapper<T> createIdMapper() {
        List list = this.entries().flatMap(entry -> ((Collection)entry.getValue()).stream()).toList();
        IdMapper idMapper = this.idMapper();
        if (idMapper == null) {
            idMapper = new IdMapper(list.size());
        }
        for (IJadeProvider provider : list) {
            if (idMapper.getId((Object)provider) != -1) continue;
            idMapper.add((Object)provider);
        }
        return idMapper;
    }

    default public void remapIds(List<ResourceLocation> keys) {
        IdMapper<T> idMapper = Objects.requireNonNull(this.idMapper());
        int i = 0;
        for (ResourceLocation key : keys) {
            T object = this.byKey(key);
            if (object != null) {
                idMapper.addMapping(object, i);
            }
            ++i;
        }
    }
}

