/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ProgressView;
import snownee.jade.impl.PriorityStore;
import snownee.jade.impl.lookup.HierarchyLookup;
import snownee.jade.impl.lookup.PairHierarchyLookup;
import snownee.jade.impl.lookup.WrappedHierarchyLookup;
import snownee.jade.util.CommonProxy;

public class WailaCommonRegistration
implements IWailaCommonRegistration {
    private static volatile WailaCommonRegistration INSTANCE = new WailaCommonRegistration();
    public final PairHierarchyLookup<IServerDataProvider<BlockAccessor>> blockDataProviders = new PairHierarchyLookup(new HierarchyLookup(Block.class), new HierarchyLookup(BlockEntity.class));
    public final HierarchyLookup<IServerDataProvider<EntityAccessor>> entityDataProviders;
    public final PriorityStore<ResourceLocation, IJadeProvider> priorities;
    public final WrappedHierarchyLookup<IServerExtensionProvider<ItemStack>> itemStorageProviders;
    public final WrappedHierarchyLookup<IServerExtensionProvider<FluidView.Data>> fluidStorageProviders;
    public final WrappedHierarchyLookup<IServerExtensionProvider<EnergyView.Data>> energyStorageProviders;
    public final WrappedHierarchyLookup<IServerExtensionProvider<ProgressView.Data>> progressProviders;

    WailaCommonRegistration() {
        this.blockDataProviders.idMapped();
        this.entityDataProviders = new HierarchyLookup(Entity.class);
        this.entityDataProviders.idMapped();
        this.priorities = new PriorityStore<ResourceLocation, IJadeProvider>(IJadeProvider::getDefaultPriority, IJadeProvider::getUid);
        this.priorities.setSortingFunction((store, allKeys) -> {
            List keys = allKeys.stream().filter(IPluginConfig::isPrimaryKey).sorted(Comparator.comparingInt(store::byKey)).collect(Collectors.toCollection(ArrayList::new));
            allKeys.stream().filter(Predicate.not(IPluginConfig::isPrimaryKey)).forEach($ -> {
                int index = keys.indexOf(IPluginConfig.getPrimaryKey($));
                keys.add(index + 1, $);
            });
            return keys;
        });
        this.priorities.configurable("jade/sort-order", (Codec<ResourceLocation>)ResourceLocation.CODEC);
        this.itemStorageProviders = WrappedHierarchyLookup.forAccessor();
        this.fluidStorageProviders = WrappedHierarchyLookup.forAccessor();
        this.energyStorageProviders = WrappedHierarchyLookup.forAccessor();
        this.progressProviders = WrappedHierarchyLookup.forAccessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WailaCommonRegistration instance() {
        if (INSTANCE != null) return INSTANCE;
        Jade.LOGGER.error("WailaCommonRegistration is not initialized yet.");
        Class<WailaCommonRegistration> clazz = WailaCommonRegistration.class;
        synchronized (WailaCommonRegistration.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new WailaCommonRegistration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Class<WailaCommonRegistration> clazz = WailaCommonRegistration.class;
        synchronized (WailaCommonRegistration.class) {
            INSTANCE = new WailaCommonRegistration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void registerBlockDataProvider(IServerDataProvider<BlockAccessor> dataProvider, Class<?> blockOrBlobkEntityClass) {
        WailaCommonRegistration.checkDataProvider(dataProvider);
        this.blockDataProviders.register(blockOrBlobkEntityClass, dataProvider);
    }

    @Override
    public void registerEntityDataProvider(IServerDataProvider<EntityAccessor> dataProvider, Class<? extends Entity> entityClass) {
        WailaCommonRegistration.checkDataProvider(dataProvider);
        this.entityDataProviders.register(entityClass, dataProvider);
    }

    private static void checkDataProvider(IServerDataProvider<?> dataProvider) {
        if (CommonProxy.isPhysicallyClient() && dataProvider instanceof IComponentProvider) {
            throw new IllegalArgumentException("Data providers cannot implement IComponentProvider since Minecraft 1.21.6. Use a separate client provider instead.");
        }
    }

    public List<IServerDataProvider<BlockAccessor>> getBlockNBTProviders(Block block, @Nullable BlockEntity blockEntity) {
        if (blockEntity == null) {
            return this.blockDataProviders.first.get(block);
        }
        return this.blockDataProviders.getMerged(block, blockEntity);
    }

    public List<IServerDataProvider<EntityAccessor>> getEntityNBTProviders(Entity entity) {
        return this.entityDataProviders.get(entity);
    }

    public void loadComplete() {
        this.blockDataProviders.loadComplete(this.priorities);
        this.entityDataProviders.loadComplete(this.priorities);
        this.itemStorageProviders.loadComplete(this.priorities);
        this.fluidStorageProviders.loadComplete(this.priorities);
        this.energyStorageProviders.loadComplete(this.priorities);
        this.progressProviders.loadComplete(this.priorities);
    }

    @Override
    public <T> void registerItemStorage(IServerExtensionProvider<ItemStack> provider, Class<? extends T> clazz) {
        this.itemStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerFluidStorage(IServerExtensionProvider<FluidView.Data> provider, Class<? extends T> clazz) {
        this.fluidStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerEnergyStorage(IServerExtensionProvider<EnergyView.Data> provider, Class<? extends T> clazz) {
        this.energyStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerProgress(IServerExtensionProvider<ProgressView.Data> provider, Class<? extends T> clazz) {
        this.progressProviders.register(clazz, provider);
    }
}

